/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class PrefetchDispatcher
extends ChangeDispatcher {
    private final Executor executor;
    private NodeState root;

    public PrefetchDispatcher(@Nonnull NodeState root, @Nonnull Executor executor) {
        super(root);
        this.root = root;
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Override
    public synchronized void contentChanged(@Nonnull NodeState root, @Nullable CommitInfo info) {
        DocumentNodeState state;
        if (root instanceof DocumentNodeState && (state = (DocumentNodeState)root).isFromExternalChange()) {
            this.executor.execute(new Runnable(){
                private final NodeState before;
                {
                    this.before = PrefetchDispatcher.this.root;
                }

                @Override
                public void run() {
                    EditorDiff.process(new VisibleEditor(TraversingEditor.INSTANCE), this.before, state);
                }
            });
        }
        super.contentChanged(root, info);
        this.root = root;
    }

    private static final class TraversingEditor
    extends DefaultEditor {
        static final Editor INSTANCE = new TraversingEditor();

        private TraversingEditor() {
        }

        @Override
        public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
            return this;
        }

        @Override
        public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            return this;
        }

        @Override
        public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            return this;
        }
    }
}

