/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LastRevs;
import org.apache.jackrabbit.oak.plugins.document.PropertyHistory;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionListener;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitOperations;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.ValueMap;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDocument
extends Document
implements CachedNodeDocument {
    public static final NodeDocument NULL = new NodeDocument(new MemoryDocumentStore());
    static final Logger LOG;
    public static final String MIN_ID_VALUE = "0000000";
    public static final String MAX_ID_VALUE = ";";
    static final int SPLIT_CANDIDATE_THRESHOLD = 8192;
    static final int DOC_SIZE_THRESHOLD = 262144;
    static final int NUM_REVS_THRESHOLD = 100;
    static final float SPLIT_RATIO = 0.3f;
    static final int PREV_SPLIT_FACTOR = 10;
    public static final String COLLISIONS = "_collisions";
    public static final String MODIFIED_IN_SECS = "_modified";
    static final int MODIFIED_IN_SECS_RESOLUTION = 5;
    private static final NavigableMap<Revision, Range> EMPTY_RANGE_MAP;
    static final String COMMIT_ROOT = "_commitRoot";
    private static final String PREVIOUS = "_prev";
    private static final String DELETED = "_deleted";
    public static final String DELETED_ONCE = "_deletedOnce";
    static final String REVISIONS = "_revisions";
    private static final String LAST_REV = "_lastRev";
    private static final String CHILDREN_FLAG = "_children";
    public static final String PATH = "_path";
    public static final String HAS_BINARY_FLAG = "_bin";
    private static final String STALE_PREV = "_stalePrev";
    public static final String SD_TYPE = "_sdType";
    public static final String SD_MAX_REV_TIME_IN_SECS = "_sdMaxRevTime";
    public static final long HAS_BINARY_VAL = 1L;
    final DocumentStore store;
    private NavigableMap<Revision, Range> previous;
    private final AtomicLong lastCheckTime = new AtomicLong(Revision.getCurrentTimestamp());
    private final long creationTime;

    public static long getModifiedInSecs(long timestamp) {
        long timeInSec = TimeUnit.MILLISECONDS.toSeconds(timestamp);
        return timeInSec - timeInSec % 5L;
    }

    NodeDocument(@Nonnull DocumentStore store) {
        this(store, Revision.getCurrentTimestamp());
    }

    public NodeDocument(@Nonnull DocumentStore store, long creationTime) {
        this.store = Preconditions.checkNotNull(store);
        this.creationTime = creationTime;
    }

    @Nonnull
    public Map<Revision, String> getValueMap(@Nonnull String key) {
        return ValueMap.create(this, key);
    }

    @Override
    public long getCreated() {
        return this.creationTime;
    }

    @CheckForNull
    public Long getModified() {
        return (Long)this.get(MODIFIED_IN_SECS);
    }

    public boolean hasChildren() {
        Boolean childrenFlag = (Boolean)this.get(CHILDREN_FLAG);
        return childrenFlag != null && childrenFlag != false;
    }

    public boolean wasDeletedOnce() {
        Boolean deletedOnceFlag = (Boolean)this.get(DELETED_ONCE);
        return deletedOnceFlag != null && deletedOnceFlag != false;
    }

    public boolean hasBeenModifiedSince(long lastModifiedTime) {
        Long modified = (Long)this.get(MODIFIED_IN_SECS);
        return modified != null && modified > TimeUnit.MILLISECONDS.toSeconds(lastModifiedTime);
    }

    public boolean hasAllRevisionLessThan(long maxRevisionTime) {
        Long maxRevTimeStamp = (Long)this.get(SD_MAX_REV_TIME_IN_SECS);
        return maxRevTimeStamp != null && maxRevTimeStamp < TimeUnit.MILLISECONDS.toSeconds(maxRevisionTime);
    }

    public boolean isSplitDocument() {
        return this.getSplitDocType() != SplitDocType.NONE;
    }

    public SplitDocType getSplitDocType() {
        Object t = this.get(SD_TYPE);
        return t == null ? SplitDocType.valueOf((Integer)null) : SplitDocType.valueOf(((Number)t).intValue());
    }

    @Override
    public void markUpToDate(long checkTime) {
        this.lastCheckTime.set(checkTime);
    }

    @Override
    public boolean isUpToDate(long lastCheckTime) {
        return lastCheckTime <= this.lastCheckTime.get();
    }

    @Override
    public long getLastCheckTime() {
        return this.lastCheckTime.get();
    }

    public boolean hasBinary() {
        Number flag = (Number)this.get(HAS_BINARY_FLAG);
        return flag != null && (long)flag.intValue() == 1L;
    }

    @Nonnull
    public String getMainPath() {
        String p = this.getPath();
        if (p.startsWith("p")) {
            if ((p = PathUtils.getAncestorPath(p, 2)).length() == 1) {
                return "/";
            }
            return p.substring(1);
        }
        return p;
    }

    @Nonnull
    public Map<Integer, Revision> getLastRev() {
        HashMap<Integer, Revision> map = Maps.newHashMap();
        SortedMap<Revision, String> valueMap = this.getLocalMap(LAST_REV);
        for (Map.Entry e : valueMap.entrySet()) {
            int clusterId = ((Revision)e.getKey()).getClusterId();
            Revision rev = Revision.fromString((String)e.getValue());
            map.put(clusterId, rev);
        }
        return map;
    }

    public boolean isCommitted(@Nonnull Revision revision) {
        NodeDocument commitRootDoc = this.getCommitRoot(Preconditions.checkNotNull(revision));
        if (commitRootDoc == null) {
            return false;
        }
        String value = (String)commitRootDoc.getLocalRevisions().get(revision);
        if (value != null) {
            return Utils.isCommitted(value);
        }
        for (NodeDocument prev : commitRootDoc.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return prev.isCommitted(revision);
        }
        return false;
    }

    @CheckForNull
    public Revision getCommitRevision(@Nonnull Revision revision) {
        NodeDocument commitRoot = this.getCommitRoot(Preconditions.checkNotNull(revision));
        if (commitRoot == null) {
            return null;
        }
        String value = commitRoot.getCommitValue(revision);
        if (Utils.isCommitted(value)) {
            return Utils.resolveCommitRevision(revision, value);
        }
        return null;
    }

    public boolean containsRevision(@Nonnull Revision revision) {
        if (this.getLocalRevisions().containsKey(revision)) {
            return true;
        }
        for (NodeDocument prev : this.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return true;
        }
        return false;
    }

    int purgeUncommittedRevisions(RevisionContext context) {
        SortedMap<Revision, String> valueMap = this.getLocalRevisions();
        UpdateOp op = new UpdateOp(this.getId(), false);
        int purgeCount = 0;
        for (Map.Entry commit : valueMap.entrySet()) {
            Revision r;
            if (Utils.isCommitted((String)commit.getValue()) || (r = (Revision)commit.getKey()).getClusterId() != context.getClusterId()) continue;
            ++purgeCount;
            op.removeMapEntry(REVISIONS, r);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
        }
        return purgeCount;
    }

    int purgeCollisionMarkers(RevisionContext context) {
        SortedMap<Revision, String> valueMap = this.getLocalMap(COLLISIONS);
        UpdateOp op = new UpdateOp(this.getId(), false);
        int purgeCount = 0;
        for (Map.Entry commit : valueMap.entrySet()) {
            Revision r = (Revision)commit.getKey();
            if (r.getClusterId() != context.getClusterId()) continue;
            ++purgeCount;
            NodeDocument.removeCollision(op, r);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
        }
        return purgeCount;
    }

    @Nonnull
    Set<Revision> getConflictsFor(@Nonnull Iterable<Revision> changes) {
        Preconditions.checkNotNull(changes);
        HashSet<Revision> conflicts = Sets.newHashSet();
        SortedMap<Revision, String> collisions = this.getLocalMap(COLLISIONS);
        for (Revision r : changes) {
            String value = (String)collisions.get(r.asTrunkRevision());
            if (value == null) continue;
            try {
                conflicts.add(Revision.fromString(value));
            }
            catch (IllegalArgumentException e) {}
        }
        return conflicts;
    }

    @CheckForNull
    public String getCommitRootPath(Revision revision) {
        String depth = this.getCommitRootDepth(revision);
        if (depth != null) {
            return this.getPathAtDepth(depth);
        }
        return null;
    }

    @CheckForNull
    Revision getNewestRevision(RevisionContext context, RevisionVector baseRev, Revision changeRev, Branch branch, Set<Revision> collisions) {
        Preconditions.checkArgument(!baseRev.isBranch() || branch != null, "Branch must be non-null if baseRev is a branch revision");
        RevisionVector head = context.getHeadRevision();
        RevisionVector lower = branch != null ? branch.getBase() : baseRev;
        Set clusterIds = Collections.emptySet();
        if (!this.getPreviousRanges().isEmpty()) {
            clusterIds = Sets.newHashSet();
            for (Revision prevRev : this.getPreviousRanges().keySet()) {
                if (!lower.isRevisionNewer(prevRev) && !Objects.equal(prevRev, lower.getRevision(prevRev.getClusterId()))) continue;
                clusterIds.add(prevRev.getClusterId());
            }
            if (!clusterIds.isEmpty()) {
                for (Revision r : this.getLocalCommitRoot().keySet()) {
                    clusterIds.add(r.getClusterId());
                }
                for (Revision r : this.getLocalRevisions().keySet()) {
                    clusterIds.add(r.getClusterId());
                }
            }
        }
        boolean fullScan = true;
        Iterable<Revision> changes = Iterables.mergeSorted(ImmutableList.of(this.getLocalRevisions().keySet(), this.getLocalCommitRoot().keySet()), this.getLocalRevisions().comparator());
        if (!clusterIds.isEmpty()) {
            fullScan = false;
            changes = Iterables.mergeSorted(ImmutableList.of(changes, this.getChanges(REVISIONS, lower), this.getChanges(COMMIT_ROOT, lower)), this.getLocalRevisions().comparator());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNewestRevision() with changeRev {} on {}, _revisions {}, _commitRoot {}", changeRev, this.getId(), this.getLocalRevisions(), this.getLocalCommitRoot());
            }
        }
        HashMap<Integer, Revision> newestRevs = Maps.newHashMap();
        HashMap<Revision, String> validRevisions = Maps.newHashMap();
        for (Revision r : changes) {
            if (r.equals(changeRev)) continue;
            if (!fullScan && clusterIds.contains(r.getClusterId()) && !lower.isRevisionNewer(r) && newestRevs.containsKey(r.getClusterId())) {
                clusterIds.remove(r.getClusterId());
                if (clusterIds.isEmpty()) break;
            }
            if (newestRevs.containsKey(r.getClusterId())) {
                if (branch == null || branch.containsCommit(r) || !branch.getBase(changeRev).isRevisionNewer(r)) continue;
                collisions.add(r);
                continue;
            }
            if (this.isValidRevision(context, r, null, baseRev, validRevisions)) {
                newestRevs.put(r.getClusterId(), r);
                continue;
            }
            NodeDocument commitRoot = this.getCommitRoot(r);
            Revision commitRevision = null;
            if (commitRoot != null) {
                commitRevision = commitRoot.getCommitRevision(r);
            }
            if (commitRevision != null && head.isRevisionNewer(commitRevision)) {
                collisions.add(r);
                continue;
            }
            if (commitRevision != null && branch == null && baseRev.isRevisionNewer(r)) {
                newestRevs.put(r.getClusterId(), r);
                continue;
            }
            collisions.add(r);
        }
        Revision newestRev = null;
        for (Revision r : newestRevs.values()) {
            newestRev = Utils.max(newestRev, r, StableRevisionComparator.INSTANCE);
        }
        if (newestRev == null) {
            return null;
        }
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        String value = (String)deleted.get(newestRev);
        if (value == null && deleted.headMap(newestRev).isEmpty()) {
            return newestRev;
        }
        if (value == null) {
            value = this.getDeleted().get(newestRev);
        }
        if ("true".equals(value)) {
            return null;
        }
        return newestRev;
    }

    boolean isValidRevision(@Nonnull RevisionContext context, @Nonnull Revision rev, @Nullable String commitValue, @Nonnull RevisionVector readRevision, @Nonnull Map<Revision, String> validRevisions) {
        if (validRevisions.containsKey(rev)) {
            return true;
        }
        NodeDocument doc = this.getCommitRoot(rev);
        if (doc == null) {
            return false;
        }
        if (doc.isCommitted(context, rev, commitValue, readRevision)) {
            validRevisions.put(rev, commitValue);
            return true;
        }
        return false;
    }

    @CheckForNull
    public DocumentNodeState getNodeAtRevision(@Nonnull DocumentNodeStore nodeStore, @Nonnull RevisionVector readRevision, @Nullable Revision lastModified) {
        Branch branch;
        LastRevs lastRevs;
        HashMap<Revision, String> validRevisions = Maps.newHashMap();
        Revision min = this.getLiveRevision(nodeStore, readRevision, validRevisions, lastRevs = this.createLastRevs(readRevision, validRevisions, branch = nodeStore.getBranches().getBranch(readRevision), lastModified));
        if (min == null) {
            return null;
        }
        String path = this.getPath();
        ArrayList<PropertyState> props = Lists.newArrayList();
        for (String key : this.keySet()) {
            SortedMap<Revision, String> local;
            if (!Utils.isPropertyName(key) || (local = this.getLocalMap(key)).isEmpty()) continue;
            Value value = this.getLatestValue(nodeStore, local.entrySet(), readRevision, validRevisions, lastRevs);
            if (value != null && !this.getPreviousRanges().isEmpty() && !this.isMostRecentCommitted(local, value.revision)) {
                for (Revision prev : this.getPreviousRanges().keySet()) {
                    if (prev.compareRevisionTimeThenClusterId(value.revision) <= 0) continue;
                    value = null;
                    break;
                }
            }
            if (value == null && !this.getPreviousRanges().isEmpty()) {
                value = this.getLatestValue(nodeStore, this.getVisibleChanges(key, readRevision), readRevision, validRevisions, lastRevs);
            }
            String propertyName = Utils.unescapePropertyName(key);
            String v = value != null ? value.value : null;
            if (v == null) continue;
            props.add(nodeStore.createPropertyState(propertyName, v));
        }
        RevisionVector lastRevision = new RevisionVector(min);
        RevisionVector branchBase = null;
        if (branch != null) {
            branchBase = branch.getBase(readRevision.getBranchRevision());
        }
        for (Revision r : lastRevs) {
            Revision rev;
            if (readRevision.isRevisionNewer(r)) {
                rev = readRevision.getRevision(r.getClusterId());
                if (rev != null) {
                    lastRevision = lastRevision.update(rev);
                    continue;
                }
                lastRevision = lastRevision.remove(r.getClusterId());
                continue;
            }
            if (branchBase != null && branchBase.isRevisionNewer(r)) {
                rev = branchBase.getRevision(r.getClusterId());
                if (rev != null) {
                    lastRevision = lastRevision.update(rev);
                    continue;
                }
                lastRevision = lastRevision.remove(r.getClusterId());
                continue;
            }
            if (!lastRevision.isRevisionNewer(r)) continue;
            lastRevision = lastRevision.update(r);
        }
        if (branch != null) {
            lastRevs.updateBranch(branch.getUnsavedLastRevision(path, readRevision.getBranchRevision()));
            Revision r = lastRevs.getBranchRevision();
            if (r != null) {
                lastRevision = lastRevision.update(r);
            }
        }
        if (this.store instanceof RevisionListener) {
            ((RevisionListener)((Object)this.store)).updateAccessedRevision(lastRevision);
        }
        return new DocumentNodeState(nodeStore, path, readRevision, props, this.hasChildren(), lastRevision);
    }

    @CheckForNull
    public Revision getLiveRevision(RevisionContext context, RevisionVector readRevision, Map<Revision, String> validRevisions, LastRevs lastRevs) {
        Value value = this.getLatestValue(context, this.getLocalDeleted().entrySet(), readRevision, validRevisions, lastRevs);
        if (value == null && !this.getPreviousRanges().isEmpty()) {
            value = this.getLatestValue(context, this.getDeleted().entrySet(), readRevision, validRevisions, lastRevs);
        }
        return value != null && "false".equals(value.value) ? value.revision : null;
    }

    boolean isConflicting(@Nonnull UpdateOp op, @Nonnull RevisionVector baseRevision, @Nonnull Revision commitRevision, boolean enableConcurrentAddRemove) {
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        boolean allowConflictingDeleteChange = enableConcurrentAddRemove && this.allowConflictingDeleteChange(op);
        for (Map.Entry entry : deleted.entrySet()) {
            if (((Revision)entry.getKey()).equals(commitRevision) || !baseRevision.isRevisionNewer((Revision)entry.getKey())) continue;
            boolean newerDeleted = Boolean.parseBoolean((String)entry.getValue());
            if (allowConflictingDeleteChange && op.isDelete() == newerDeleted) continue;
            return true;
        }
        for (Map.Entry<Object, Object> entry : op.getChanges().entrySet()) {
            if (((UpdateOp.Operation)entry.getValue()).type != UpdateOp.Operation.Type.SET_MAP_ENTRY) continue;
            String name = ((UpdateOp.Key)entry.getKey()).getName();
            if (DELETED.equals(name) && !allowConflictingDeleteChange) {
                return true;
            }
            if (!Utils.isPropertyName(name)) continue;
            for (Revision rev : this.getChanges(name, baseRevision)) {
                if (rev.equals(commitRevision) || !baseRevision.isRevisionNewer(rev)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allowConflictingDeleteChange(UpdateOp op) {
        String path = this.getPath();
        if (!Utils.isHiddenPath(path)) {
            return false;
        }
        if (!op.isNew() && !op.isDelete()) {
            return false;
        }
        for (UpdateOp.Key opKey : op.getChanges().keySet()) {
            String name = opKey.getName();
            if (!Utils.isPropertyName(name)) continue;
            return false;
        }
        for (String dataKey : this.keySet()) {
            if (!Utils.isPropertyName(dataKey)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Iterable<UpdateOp> split(@Nonnull RevisionContext context, @Nonnull RevisionVector head, @Nonnull Predicate<String> isBinaryValue) {
        return SplitOperations.forDocument(this, context, head, isBinaryValue, 100);
    }

    @Nonnull
    NavigableMap<Revision, Range> getPreviousRanges() {
        return this.getPreviousRanges(false);
    }

    @Nonnull
    NavigableMap<Revision, Range> getPreviousRanges(boolean includeStale) {
        if (includeStale) {
            return this.createPreviousRanges(true);
        }
        if (this.previous == null) {
            this.previous = this.createPreviousRanges(false);
        }
        return this.previous;
    }

    @Nonnull
    private NavigableMap<Revision, Range> createPreviousRanges(boolean includeStale) {
        NavigableMap<Revision, Range> ranges;
        SortedMap<Revision, String> map = this.getLocalMap(PREVIOUS);
        if (map.isEmpty()) {
            ranges = EMPTY_RANGE_MAP;
        } else {
            Map stale = Collections.emptyMap();
            if (!includeStale) {
                stale = this.getLocalMap(STALE_PREV);
            }
            TreeMap<Revision, Range> transformed = new TreeMap<Revision, Range>(StableRevisionComparator.REVERSE);
            for (Map.Entry entry : map.entrySet()) {
                Range r = Range.fromEntry((Revision)entry.getKey(), (String)entry.getValue());
                if (String.valueOf(r.height).equals(stale.get(r.high))) continue;
                transformed.put(r.high, r);
            }
            ranges = Maps.unmodifiableNavigableMap(transformed);
        }
        return ranges;
    }

    @Nonnull
    Iterable<NodeDocument> getPreviousDocs(final @Nonnull String property, final @Nullable Revision revision) {
        if (this.getPreviousRanges().isEmpty()) {
            return Collections.emptyList();
        }
        if (revision == null) {
            return new PropertyHistory(this, property);
        }
        String mainPath = this.getMainPath();
        Map.Entry<Revision, Range> entry = this.getPreviousRanges().floorEntry(revision);
        if (entry != null) {
            int h;
            Revision r = entry.getKey();
            String prevId = Utils.getPreviousIdFor(mainPath, r, h = entry.getValue().height);
            NodeDocument prev = this.getPreviousDocument(prevId);
            if (prev != null) {
                if (prev.getValueMap(property).containsKey(revision)) {
                    return Collections.singleton(prev);
                }
            } else {
                this.previousDocumentNotFound(prevId, revision);
            }
        }
        return Iterables.filter(Iterables.transform(this.getPreviousRanges().headMap(revision).entrySet(), new Function<Map.Entry<Revision, Range>, NodeDocument>(){

            @Override
            public NodeDocument apply(Map.Entry<Revision, Range> input) {
                if (input.getValue().includes(revision)) {
                    return NodeDocument.this.getPreviousDoc(input.getKey(), input.getValue());
                }
                return null;
            }
        }), new Predicate<NodeDocument>(){

            @Override
            public boolean apply(@Nullable NodeDocument input) {
                return input != null && input.getValueMap(property).containsKey(revision);
            }
        });
    }

    NodeDocument getPreviousDocument(String prevId) {
        LOG.trace("get previous document {}", (Object)prevId);
        NodeDocument doc = this.store.find(Collection.NODES, prevId);
        if (doc == null) {
            doc = this.store.find(Collection.NODES, prevId, 0);
        }
        return doc;
    }

    @Nonnull
    Iterator<NodeDocument> getAllPreviousDocs() {
        if (this.getPreviousRanges().isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new AbstractIterator<NodeDocument>(){
            private Queue<Map.Entry<Revision, Range>> previousRanges;
            {
                this.previousRanges = Queues.newArrayDeque(NodeDocument.this.getPreviousRanges().entrySet());
            }

            @Override
            protected NodeDocument computeNext() {
                Map.Entry<Revision, Range> e;
                NodeDocument prev;
                if (!this.previousRanges.isEmpty() && (prev = NodeDocument.this.getPreviousDoc((e = this.previousRanges.remove()).getKey(), e.getValue())) != null) {
                    this.previousRanges.addAll(prev.getPreviousRanges().entrySet());
                    return prev;
                }
                return (NodeDocument)this.endOfData();
            }
        };
    }

    @Nonnull
    Iterator<NodeDocument> getPreviousDocLeaves() {
        if (this.getPreviousRanges().isEmpty()) {
            return Iterators.emptyIterator();
        }
        final TreeMap<Revision, Range> ranges = Maps.newTreeMap(this.getPreviousRanges());
        return new AbstractIterator<NodeDocument>(){

            @Override
            protected NodeDocument computeNext() {
                NodeDocument next;
                while (true) {
                    Map.Entry topEntry;
                    if ((topEntry = ranges.pollFirstEntry()) == null) {
                        next = (NodeDocument)this.endOfData();
                        break;
                    }
                    NodeDocument prev = NodeDocument.this.getPreviousDoc((Revision)topEntry.getKey(), (Range)topEntry.getValue());
                    if (prev == null) continue;
                    if (((Range)topEntry.getValue()).getHeight() == 0) {
                        next = prev;
                        break;
                    }
                    ranges.putAll(prev.getPreviousRanges());
                }
                return next;
            }
        };
    }

    @CheckForNull
    private NodeDocument getPreviousDoc(Revision rev, Range range) {
        int h = range.height;
        String prevId = Utils.getPreviousIdFor(this.getMainPath(), rev, h);
        NodeDocument prev = this.getPreviousDocument(prevId);
        if (prev != null) {
            return prev;
        }
        this.previousDocumentNotFound(prevId, rev);
        return null;
    }

    @Nullable
    NodeDocument findPrevReferencingDoc(Revision revision, int height) {
        for (Range range : this.getPreviousRanges().values()) {
            if (range.getHeight() == height && range.high.equals(revision)) {
                return this;
            }
            if (!range.includes(revision)) continue;
            String prevId = Utils.getPreviousIdFor(this.getMainPath(), range.high, range.height);
            NodeDocument prev = this.store.find(Collection.NODES, prevId);
            if (prev == null) {
                LOG.warn("Split document {} does not exist anymore. Main document is {}", (Object)prevId, (Object)Utils.getIdFromPath(this.getMainPath()));
                continue;
            }
            NodeDocument doc = prev.findPrevReferencingDoc(revision, height);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    Iterable<Revision> getAllChanges() {
        RevisionVector empty = new RevisionVector(new Revision[0]);
        return Iterables.mergeSorted(ImmutableList.of(this.getChanges(REVISIONS, empty), this.getChanges(COMMIT_ROOT, empty)), StableRevisionComparator.REVERSE);
    }

    @Nonnull
    Iterable<Revision> getChanges(@Nonnull String property, final @Nonnull RevisionVector min) {
        Predicate<Revision> p = new Predicate<Revision>(){

            @Override
            public boolean apply(Revision input) {
                return min.isRevisionNewer(input);
            }
        };
        ArrayList<Iterable<Revision>> changes = Lists.newArrayList();
        changes.add(Utils.abortingIterable(this.getLocalMap(property).keySet(), p));
        for (Map.Entry e : this.getPreviousRanges().entrySet()) {
            NodeDocument prev;
            if (!min.isRevisionNewer((Revision)e.getKey()) || (prev = this.getPreviousDoc((Revision)e.getKey(), (Range)e.getValue())) == null) continue;
            changes.add(Utils.abortingIterable(prev.getValueMap(property).keySet(), p));
        }
        if (changes.size() == 1) {
            return (Iterable)changes.get(0);
        }
        return Iterables.mergeSorted(changes, StableRevisionComparator.REVERSE);
    }

    @Nonnull
    Iterable<Map.Entry<Revision, String>> getVisibleChanges(final @Nonnull String property, final @Nonnull RevisionVector readRevision) {
        Predicate<Map.Entry<Revision, String>> p = new Predicate<Map.Entry<Revision, String>>(){

            @Override
            public boolean apply(Map.Entry<Revision, String> input) {
                return !readRevision.isRevisionNewer(input.getKey());
            }
        };
        ArrayList<Iterable<Map.Entry<Revision, String>>> changes = Lists.newArrayList();
        changes.add(Iterables.filter(this.getLocalMap(property).entrySet(), p));
        boolean overlapping = false;
        ArrayList<Range> ranges = Lists.newArrayList();
        long lowStamp = Long.MAX_VALUE;
        for (Map.Entry e : this.getPreviousRanges().entrySet()) {
            Range range = (Range)e.getValue();
            if (readRevision.isRevisionNewer(range.low)) continue;
            ranges.add(range);
            if (!overlapping) {
                overlapping = range.high.getTimestamp() >= lowStamp;
            }
            lowStamp = Math.min(lowStamp, range.low.getTimestamp());
        }
        if (!ranges.isEmpty()) {
            Iterable<Iterable<Map.Entry<Revision, String>>> revs = Iterables.transform(Iterables.filter(Iterables.transform(ranges, new Function<Range, NodeDocument>(){

                @Override
                public NodeDocument apply(Range input) {
                    return NodeDocument.this.getPreviousDoc(input.high, input);
                }
            }), Predicates.notNull()), new Function<NodeDocument, Iterable<Map.Entry<Revision, String>>>(){

                @Override
                public Iterable<Map.Entry<Revision, String>> apply(NodeDocument prev) {
                    return prev.getVisibleChanges(property, readRevision);
                }
            });
            if (overlapping) {
                changes.add(Iterables.mergeSorted(revs, ValueComparator.REVERSE));
            } else {
                changes.add(Iterables.concat(revs));
            }
        }
        if (changes.size() == 1) {
            return (Iterable)changes.get(0);
        }
        return Iterables.mergeSorted(changes, ValueComparator.REVERSE);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalMap(String key) {
        SortedMap<Revision, String> map = (SortedMap<Revision, String>)this.data.get(key);
        if (map == null) {
            map = ValueMap.EMPTY;
        }
        return map;
    }

    @Nonnull
    SortedMap<Revision, String> getLocalRevisions() {
        return this.getLocalMap(REVISIONS);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalCommitRoot() {
        return this.getLocalMap(COMMIT_ROOT);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalDeleted() {
        return this.getLocalMap(DELETED);
    }

    @Nonnull
    SortedMap<Revision, String> getStalePrev() {
        return this.getLocalMap(STALE_PREV);
    }

    public static void setChildrenFlag(@Nonnull UpdateOp op, boolean hasChildNode) {
        Preconditions.checkNotNull(op).set(CHILDREN_FLAG, hasChildNode);
    }

    public static void setModified(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).max(MODIFIED_IN_SECS, Long.valueOf(NodeDocument.getModifiedInSecs(Preconditions.checkNotNull(revision).getTimestamp())));
    }

    public static void setRevision(@Nonnull UpdateOp op, @Nonnull Revision revision, @Nonnull String commitValue) {
        Preconditions.checkNotNull(op).setMapEntry(REVISIONS, Preconditions.checkNotNull(revision), Preconditions.checkNotNull(commitValue));
    }

    public static void unsetRevision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).unsetMapEntry(REVISIONS, Preconditions.checkNotNull(revision));
    }

    public static boolean isRevisionsEntry(String name) {
        return REVISIONS.equals(name);
    }

    public static boolean isCommitRootEntry(String name) {
        return COMMIT_ROOT.equals(name);
    }

    public static boolean isDeletedEntry(String name) {
        return DELETED.equals(name);
    }

    public static void removeRevision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(REVISIONS, Preconditions.checkNotNull(revision));
    }

    public static void addCollision(@Nonnull UpdateOp op, @Nonnull Revision revision, @Nonnull Revision other) {
        Preconditions.checkNotNull(op).setMapEntry(COLLISIONS, Preconditions.checkNotNull(revision), other.toString());
    }

    public static void removeCollision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(COLLISIONS, Preconditions.checkNotNull(revision));
    }

    public static void setLastRev(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).setMapEntry(LAST_REV, new Revision(0L, 0, revision.getClusterId()), revision.toString());
    }

    public static void setCommitRoot(@Nonnull UpdateOp op, @Nonnull Revision revision, int commitRootDepth) {
        Preconditions.checkNotNull(op).setMapEntry(COMMIT_ROOT, Preconditions.checkNotNull(revision), String.valueOf(commitRootDepth));
    }

    public static void removeCommitRoot(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(COMMIT_ROOT, revision);
    }

    public static void setDeleted(@Nonnull UpdateOp op, @Nonnull Revision revision, boolean deleted) {
        if (deleted) {
            NodeDocument.setDeletedOnce(op);
        }
        Preconditions.checkNotNull(op).setMapEntry(DELETED, Preconditions.checkNotNull(revision), String.valueOf(deleted));
    }

    public static void setDeletedOnce(@Nonnull UpdateOp op) {
        Preconditions.checkNotNull(op).set(DELETED_ONCE, Boolean.TRUE);
    }

    public static void removeDeleted(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(DELETED, revision);
    }

    public static void setPrevious(@Nonnull UpdateOp op, @Nonnull Range range) {
        Preconditions.checkNotNull(op).setMapEntry(PREVIOUS, Preconditions.checkNotNull(range).high, range.getLowValue());
    }

    public static void removePrevious(@Nonnull UpdateOp op, @Nonnull Range range) {
        NodeDocument.removePrevious(op, Preconditions.checkNotNull(range).high);
    }

    public static void removePrevious(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(PREVIOUS, Preconditions.checkNotNull(revision));
    }

    public static void setStalePrevious(@Nonnull UpdateOp op, @Nonnull Revision revision, int height) {
        Preconditions.checkNotNull(op).setMapEntry(STALE_PREV, Preconditions.checkNotNull(revision), String.valueOf(height));
    }

    public static void removeStalePrevious(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(STALE_PREV, Preconditions.checkNotNull(revision));
    }

    public static void setHasBinary(@Nonnull UpdateOp op) {
        Preconditions.checkNotNull(op).set(HAS_BINARY_FLAG, 1L);
    }

    private void previousDocumentNotFound(String prevId, Revision rev) {
        LOG.warn("Document with previous revisions not found: " + prevId);
        String path = this.getMainPath();
        String id = Utils.getIdFromPath(path);
        NodeDocument doc = this.store.getIfCached(Collection.NODES, id);
        long now = Revision.getCurrentTimestamp();
        block0: while (doc != null && doc.getCreated() + TimeUnit.MINUTES.toMillis(1L) < now) {
            LOG.info("Invalidated cached document {}", (Object)id);
            this.store.invalidateCache(Collection.NODES, id);
            java.util.Collection ranges = doc.getPreviousRanges().values();
            doc = null;
            for (Range range : ranges) {
                if (!range.includes(rev)) continue;
                id = Utils.getPreviousIdFor(path, range.high, range.height);
                doc = this.store.getIfCached(Collection.NODES, id);
                continue block0;
            }
        }
    }

    private LastRevs createLastRevs(@Nonnull RevisionVector readRevision, @Nonnull Map<Revision, String> validRevisions, @Nullable Branch branch, @Nullable Revision pendingLastRev) {
        LastRevs lastRevs = new LastRevs(this.getLastRev(), readRevision, branch);
        lastRevs.update(pendingLastRev);
        TreeSet<Revision> mostRecentChanges = Sets.newTreeSet(StableRevisionComparator.REVERSE);
        mostRecentChanges.addAll(this.getLocalRevisions().keySet());
        mostRecentChanges.addAll(this.getLocalCommitRoot().keySet());
        HashSet<Integer> clusterIds = Sets.newHashSet();
        for (Revision r : this.getLocalRevisions().keySet()) {
            clusterIds.add(r.getClusterId());
        }
        for (Revision r : this.getLocalCommitRoot().keySet()) {
            clusterIds.add(r.getClusterId());
        }
        for (Revision r : mostRecentChanges) {
            Revision branchRev;
            if (!clusterIds.contains(r.getClusterId())) continue;
            String commitValue = validRevisions.get(r);
            if (commitValue == null) {
                commitValue = this.resolveCommitValue(r);
            }
            if (commitValue == null) continue;
            Revision commitRev = Utils.resolveCommitRevision(r, commitValue);
            if (Utils.isCommitted(commitValue)) {
                lastRevs.update(commitRev);
                clusterIds.remove(r.getClusterId());
                continue;
            }
            if (branch == null || !branch.containsCommit(branchRev = commitRev.asBranchRevision())) continue;
            lastRevs.updateBranch(branchRev);
            clusterIds.remove(r.getClusterId());
        }
        return lastRevs;
    }

    private String resolveCommitValue(Revision revision) {
        NodeDocument commitRoot = this.getCommitRoot(revision);
        if (commitRoot == null) {
            return null;
        }
        return commitRoot.getCommitValue(revision);
    }

    private boolean isMostRecentCommitted(SortedMap<Revision, String> valueMap, Revision revision) {
        if (valueMap.isEmpty()) {
            return true;
        }
        Revision first = valueMap.firstKey();
        if (first.compareRevisionTimeThenClusterId(revision) <= 0) {
            return true;
        }
        for (Revision r : valueMap.keySet()) {
            Revision c = this.getCommitRevision(r);
            if (c == null) continue;
            return c.compareRevisionTimeThenClusterId(revision) <= 0;
        }
        return true;
    }

    @CheckForNull
    private NodeDocument getCommitRoot(@Nonnull Revision rev) {
        String commitRootPath;
        if (this.getLocalRevisions().containsKey(rev)) {
            return this;
        }
        String depth = (String)this.getLocalCommitRoot().get(rev);
        if (depth != null) {
            commitRootPath = this.getPathAtDepth(depth);
        } else {
            if (this.containsRevision(rev)) {
                return this;
            }
            commitRootPath = this.getCommitRootPath(rev);
            if (commitRootPath == null) {
                return null;
            }
        }
        return this.store.find(Collection.NODES, Utils.getIdFromPath(commitRootPath));
    }

    @Nonnull
    private String getPathAtDepth(@Nonnull String depth) {
        if (Preconditions.checkNotNull(depth).equals("0")) {
            return "/";
        }
        String p = this.getPath();
        return PathUtils.getAncestorPath(p, PathUtils.getDepth(p) - Integer.parseInt(depth));
    }

    @CheckForNull
    private String getCommitRootDepth(@Nonnull Revision revision) {
        String depth;
        block1: {
            NodeDocument prev;
            SortedMap<Revision, String> local = this.getLocalCommitRoot();
            depth = (String)local.get(revision);
            if (depth != null) break block1;
            Iterator<NodeDocument> i$ = this.getPreviousDocs(COMMIT_ROOT, revision).iterator();
            while (i$.hasNext() && (depth = (prev = i$.next()).getCommitRootDepth(revision)) == null) {
            }
        }
        return depth;
    }

    private boolean isCommitted(@Nonnull RevisionContext context, @Nonnull Revision revision, @Nullable String commitValue, @Nonnull RevisionVector readRevision) {
        if (commitValue == null) {
            commitValue = this.getCommitValue(revision);
        }
        if (commitValue == null) {
            return false;
        }
        if (Utils.isCommitted(commitValue)) {
            if (context.getBranches().getBranch(readRevision) == null && !readRevision.isBranch()) {
                return !readRevision.isRevisionNewer(revision = Utils.resolveCommitRevision(revision, commitValue));
            }
            if (commitValue.equals(this.getCommitValue(readRevision.getBranchRevision().asTrunkRevision()))) {
                return !readRevision.isRevisionNewer(revision);
            }
        } else {
            RevisionVector branchCommit = RevisionVector.fromString(commitValue);
            if (branchCommit.getBranchRevision().getClusterId() != context.getClusterId()) {
                return false;
            }
        }
        return NodeDocument.includeRevision(context, Utils.resolveCommitRevision(revision, commitValue), readRevision);
    }

    @CheckForNull
    private String getCommitValue(Revision revision) {
        String value;
        block1: {
            NodeDocument prev;
            value = (String)this.getLocalRevisions().get(revision);
            if (value != null) break block1;
            Iterator<NodeDocument> i$ = this.getPreviousDocs(REVISIONS, revision).iterator();
            while (i$.hasNext() && (value = (prev = i$.next()).getCommitValue(revision)) == null) {
            }
        }
        return value;
    }

    private static boolean includeRevision(RevisionContext context, Revision x, RevisionVector readRevision) {
        Branch b = null;
        if (x.getClusterId() == context.getClusterId()) {
            RevisionVector branchRev = new RevisionVector(x).asBranchRevision(context.getClusterId());
            b = context.getBranches().getBranch(branchRev);
        }
        if (b != null) {
            if (readRevision.isBranch() && b.containsCommit(readRevision.getBranchRevision())) {
                return !readRevision.isRevisionNewer(x);
            }
            return false;
        }
        b = context.getBranches().getBranch(readRevision);
        if (b != null) {
            readRevision = b.getBase(readRevision.getBranchRevision());
        }
        return !readRevision.isRevisionNewer(x);
    }

    @CheckForNull
    private Value getLatestValue(@Nonnull RevisionContext context, @Nonnull Iterable<Map.Entry<Revision, String>> valueMap, @Nonnull RevisionVector readRevision, @Nonnull Map<Revision, String> validRevisions, @Nonnull LastRevs lastRevs) {
        for (Map.Entry<Revision, String> entry : valueMap) {
            Revision propRev = entry.getKey();
            String commitValue = validRevisions.get(propRev);
            if (commitValue == null) {
                commitValue = this.resolveCommitValue(propRev);
            }
            if (commitValue == null) continue;
            Revision commitRev = Utils.resolveCommitRevision(propRev, commitValue);
            if (Utils.isCommitted(commitValue)) {
                lastRevs.update(commitRev);
            } else {
                lastRevs.updateBranch(commitRev.asBranchRevision());
            }
            if (!this.isValidRevision(context, propRev, commitValue, readRevision, validRevisions)) continue;
            return new Value(commitRev, entry.getValue());
        }
        return null;
    }

    @Override
    public String getPath() {
        String p = (String)this.get(PATH);
        if (p != null) {
            return p;
        }
        return Utils.getPathFromId(this.getId());
    }

    @Nonnull
    Map<Revision, String> getDeleted() {
        return ValueMap.create(this, DELETED);
    }

    public String asString() {
        JsopBuilder json = new JsopBuilder();
        NodeDocument.toJson(json, this.data);
        return ((Object)json).toString();
    }

    private static void toJson(JsopWriter json, Map<?, Object> map) {
        for (Map.Entry<?, Object> e : map.entrySet()) {
            json.key(e.getKey().toString());
            Object value = e.getValue();
            if (value == null) {
                json.value(null);
                continue;
            }
            if (value instanceof Boolean) {
                json.value((Boolean)value);
                continue;
            }
            if (value instanceof Long) {
                json.value((Long)value);
                continue;
            }
            if (value instanceof Integer) {
                json.value(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Map) {
                json.object();
                NodeDocument.toJson(json, (Map)value);
                json.endObject();
                continue;
            }
            if (value instanceof Revision) {
                json.value(value.toString());
                continue;
            }
            json.value((String)value);
        }
    }

    public static NodeDocument fromString(DocumentStore store, String s) {
        JsopTokenizer json = new JsopTokenizer(s);
        NodeDocument doc = new NodeDocument(store);
        while (!json.matches(0)) {
            String k = json.readString();
            json.read(58);
            if (json.matches(0)) break;
            doc.put(k, NodeDocument.fromJson(json));
            json.matches(44);
        }
        doc.seal();
        return doc;
    }

    private static Object fromJson(JsopTokenizer json) {
        switch (json.read()) {
            case 5: {
                return null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 2: {
                return Long.parseLong(json.getToken());
            }
            case 1: {
                return json.getToken();
            }
            case 123: {
                TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
                while (!json.matches(125)) {
                    String k = json.readString();
                    json.read(58);
                    map.put(Revision.fromString(k), NodeDocument.fromJson(json));
                    json.matches(44);
                }
                return map;
            }
        }
        throw new IllegalArgumentException(json.readRawValue());
    }

    static {
        NULL.seal();
        LOG = LoggerFactory.getLogger(NodeDocument.class);
        EMPTY_RANGE_MAP = Maps.unmodifiableNavigableMap(new TreeMap());
    }

    private static final class ValueComparator
    implements Comparator<Map.Entry<Revision, String>> {
        static final Comparator<Map.Entry<Revision, String>> INSTANCE = new ValueComparator();
        static final Comparator<Map.Entry<Revision, String>> REVERSE = Collections.reverseOrder(INSTANCE);
        private static final Ordering<String> STRING_ORDERING = Ordering.natural().nullsFirst();

        private ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<Revision, String> o1, Map.Entry<Revision, String> o2) {
            int cmp = StableRevisionComparator.INSTANCE.compare(o1.getKey(), o2.getKey());
            if (cmp != 0) {
                return cmp;
            }
            return STRING_ORDERING.compare(o1.getValue(), o2.getValue());
        }
    }

    private static final class Value {
        final Revision revision;
        final String value;

        Value(@Nonnull Revision revision, @Nullable String value) {
            this.revision = Preconditions.checkNotNull(revision);
            this.value = value;
        }
    }

    public static final class Children
    implements CacheValue,
    Cloneable {
        ArrayList<String> childNames = new ArrayList();
        boolean isComplete;

        @Override
        public int getMemory() {
            int size = 114;
            for (String name : this.childNames) {
                size += name.length() * 2 + 56;
            }
            return size;
        }

        public Children clone() {
            try {
                Children clone = (Children)super.clone();
                clone.childNames = (ArrayList)this.childNames.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException();
            }
        }

        public String asString() {
            JsopBuilder json = new JsopBuilder();
            if (this.isComplete) {
                json.key("isComplete").value(true);
            }
            if (this.childNames.size() > 0) {
                json.key("children").array();
                for (String c : this.childNames) {
                    json.value(c);
                }
                json.endArray();
            }
            return ((Object)json).toString();
        }

        public static Children fromString(String s) {
            JsopTokenizer json = new JsopTokenizer(s);
            Children children = new Children();
            while (!json.matches(0)) {
                String k = json.readString();
                json.read(58);
                if ("isComplete".equals(k)) {
                    children.isComplete = json.read() == 3;
                } else if ("children".equals(k)) {
                    json.read(91);
                    while (!json.matches(93)) {
                        String value = json.readString();
                        children.childNames.add(value);
                        json.matches(44);
                    }
                }
                if (json.matches(0)) break;
                json.read(44);
            }
            return children;
        }
    }

    public static enum SplitDocType {
        NONE(-1),
        DEFAULT(10),
        DEFAULT_NO_CHILD(20),
        PROP_COMMIT_ONLY(30),
        INTERMEDIATE(40),
        DEFAULT_LEAF(50),
        COMMIT_ROOT_ONLY(60);

        final int type;

        private SplitDocType(int type) {
            this.type = type;
        }

        public int typeCode() {
            return this.type;
        }

        static SplitDocType valueOf(Integer type) {
            if (type == null) {
                return NONE;
            }
            for (SplitDocType docType : SplitDocType.values()) {
                if (docType.type != type) continue;
                return docType;
            }
            throw new IllegalArgumentException("Not a valid SplitDocType :" + type);
        }
    }
}

