/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingLastRevSeeker {
    private static final Logger LOG = LoggerFactory.getLogger(MissingLastRevSeeker.class);
    protected final String ROOT_PATH = "/";
    private final DocumentStore store;
    protected final Clock clock;
    private final Predicate<ClusterNodeInfoDocument> isRecoveryNeeded = new Predicate<ClusterNodeInfoDocument>(){

        @Override
        public boolean apply(ClusterNodeInfoDocument nodeInfo) {
            return MissingLastRevSeeker.this.isRecoveryNeeded(nodeInfo);
        }
    };

    public MissingLastRevSeeker(DocumentStore store, Clock clock) {
        this.store = store;
        this.clock = clock;
    }

    @Nonnull
    public Iterable<ClusterNodeInfoDocument> getAllClusters() {
        return ClusterNodeInfoDocument.all(this.store);
    }

    @CheckForNull
    public ClusterNodeInfoDocument getClusterNodeInfo(int clusterId) {
        return this.store.find(Collection.CLUSTER_NODES, String.valueOf(clusterId));
    }

    @Nonnull
    public Iterable<NodeDocument> getCandidates(final long startTime) {
        Iterable<NodeDocument> nodes = Utils.getSelectedDocuments(this.store, "_modified", NodeDocument.getModifiedInSecs(startTime));
        return Iterables.filter(nodes, new Predicate<NodeDocument>(){

            @Override
            public boolean apply(NodeDocument input) {
                Long modified = (Long)input.get("_modified");
                return modified != null && modified >= NodeDocument.getModifiedInSecs(startTime);
            }
        });
    }

    public boolean acquireRecoveryLock(int clusterId, int recoveredBy) {
        ClusterNodeInfoDocument doc = this.getClusterNodeInfo(clusterId);
        if (doc == null) {
            return false;
        }
        if (!this.isRecoveryNeeded(doc)) {
            return false;
        }
        boolean acquired = this.tryAcquireRecoveryLock(doc, recoveredBy);
        if (acquired) {
            return true;
        }
        return doc.isBeingRecoveredBy(recoveredBy) || this.tryBreakRecoveryLock(doc, recoveredBy);
    }

    public void releaseRecoveryLock(int clusterId, boolean success) {
        try {
            ClusterNodeInfoDocument old;
            UpdateOp update = new UpdateOp(Integer.toString(clusterId), false);
            update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.NONE.name());
            update.set("recoveryBy", null);
            if (success) {
                update.set("state", null);
            }
            if ((old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update)) == null) {
                throw new RuntimeException("ClusterNodeInfo document for " + clusterId + " missing.");
            }
            LOG.info("Released recovery lock for cluster id {} (recovery successful: {})", (Object)clusterId, (Object)success);
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to release the recovery lock for clusterNodeId " + clusterId, ex);
            throw ex;
        }
    }

    public NodeDocument getRoot() {
        return this.store.find(Collection.NODES, Utils.getIdFromPath("/"));
    }

    public boolean isRecoveryNeeded() {
        return Iterables.any(this.getAllClusters(), this.isRecoveryNeeded);
    }

    public boolean isRecoveryNeeded(@Nonnull ClusterNodeInfoDocument nodeInfo) {
        return nodeInfo.isActive() && this.clock.getTime() > nodeInfo.getLeaseEndTime();
    }

    private boolean tryAcquireRecoveryLock(ClusterNodeInfoDocument info, int recoveredBy) {
        int clusterId = info.getClusterId();
        try {
            ClusterNodeInfoDocument old;
            UpdateOp update = new UpdateOp(Integer.toString(clusterId), false);
            update.equals("state", ClusterNodeInfo.ClusterNodeState.ACTIVE.name());
            update.equals("leaseEnd", info.getLeaseEndTime());
            update.notEquals("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            if (recoveredBy != 0) {
                update.set("recoveryBy", recoveredBy);
            }
            if ((old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update)) != null) {
                LOG.info("Acquired recovery lock for cluster id {}", (Object)clusterId);
            }
            return old != null;
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to acquire the recovery lock for clusterNodeId " + clusterId, ex);
            throw ex;
        }
    }

    private boolean tryBreakRecoveryLock(ClusterNodeInfoDocument doc, int recoveredBy) {
        Long recoveryBy = doc.getRecoveryBy();
        if (recoveryBy == null) {
            return false;
        }
        ClusterNodeInfoDocument recovering = this.getClusterNodeInfo(recoveryBy.intValue());
        if (recovering == null) {
            return false;
        }
        if (recovering.isActive() && recovering.getLeaseEndTime() > this.clock.getTime()) {
            return false;
        }
        try {
            UpdateOp update = new UpdateOp(Integer.toString(doc.getClusterId()), false);
            update.equals("state", ClusterNodeInfo.ClusterNodeState.ACTIVE.name());
            update.equals("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            update.equals("recoveryBy", recoveryBy);
            update.set("recoveryBy", recoveredBy);
            ClusterNodeInfoDocument old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update);
            if (old != null) {
                LOG.info("Acquired (broke) recovery lock for cluster id {}. Previous lock owner: {}", (Object)doc.getClusterId(), (Object)recoveryBy);
            }
            return old != null;
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to break the recovery lock for clusterNodeId " + doc.getClusterId(), ex);
            throw ex;
        }
    }
}

