/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalGarbageCollector {
    private static final Logger log = LoggerFactory.getLogger(JournalGarbageCollector.class);
    private static final String JOURNAL_GC_ID = "journalGC";
    private static final String TAIL_TIMESTAMP = "tailTimestamp";
    private final DocumentNodeStore ns;
    private volatile long lastTailTimestampRefresh = Long.MIN_VALUE;
    private Revision tailRevision;

    public JournalGarbageCollector(DocumentNodeStore nodeStore) {
        this.ns = nodeStore;
        this.tailRevision = new Revision(0L, 0, this.ns.getClusterId());
    }

    public int gc(long maxRevisionAge, int batchSize, TimeUnit unit) {
        DocumentStore ds = this.ns.getDocumentStore();
        Revision keep = this.ns.getCheckpoints().getOldestRevisionToKeep();
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        long now = this.ns.getClock().getTime();
        long gcOlderThan = now - maxRevisionAgeInMillis;
        if (keep != null && keep.getTimestamp() < gcOlderThan) {
            gcOlderThan = keep.getTimestamp();
            log.debug("gc: Checkpoint {} is older than maxRevisionAge: {} min", (Object)keep, (Object)unit.toMinutes(maxRevisionAge));
        }
        if (log.isDebugEnabled()) {
            log.debug("gc: Journal garbage collection starts with maxAge: {} min., batch size: {}.", (Object)TimeUnit.MILLISECONDS.toMinutes(maxRevisionAgeInMillis), (Object)batchSize);
        }
        Stopwatch sw = Stopwatch.createStarted();
        this.updateTailTimestamp(gcOlderThan);
        List<ClusterNodeInfoDocument> clusterNodeInfos = ClusterNodeInfoDocument.all(ds);
        int numDeleted = 0;
        block0: for (ClusterNodeInfoDocument clusterNodeInfoDocument : clusterNodeInfos) {
            int clusterNodeId = clusterNodeInfoDocument.getClusterId();
            boolean branch = false;
            long startPointer = 0L;
            while (true) {
                String toKey;
                String fromKey;
                List<JournalEntry> deletionBatch;
                if ((deletionBatch = ds.query(Collection.JOURNAL, fromKey = JournalEntry.asId(new Revision(startPointer, 0, clusterNodeId, branch)), toKey = JournalEntry.asId(new Revision(gcOlderThan, 0, clusterNodeId, branch)), batchSize)).size() > 0) {
                    ds.remove(Collection.JOURNAL, this.asKeys(deletionBatch));
                    numDeleted += deletionBatch.size();
                }
                if (deletionBatch.size() < batchSize) {
                    if (branch) continue block0;
                    startPointer = 0L;
                    branch = true;
                    continue;
                }
                startPointer = deletionBatch.get(deletionBatch.size() - 1).getRevisionTimestamp();
            }
        }
        sw.stop();
        if (numDeleted > 0) {
            log.info("gc: Journal garbage collection took {}, deleted {} entries that were older than {} min.", sw, numDeleted, TimeUnit.MILLISECONDS.toMinutes(now - gcOlderThan));
        }
        return numDeleted;
    }

    private void updateTailTimestamp(long gcOlderThan) {
        UpdateOp op = new UpdateOp(JOURNAL_GC_ID, true);
        op.max(TAIL_TIMESTAMP, Long.valueOf(gcOlderThan));
        this.ns.getDocumentStore().createOrUpdate(Collection.SETTINGS, op);
    }

    public Revision getTailRevision() {
        this.refreshTailRevisionIfNecessary();
        return this.tailRevision;
    }

    private void refreshTailRevisionIfNecessary() {
        long now = this.ns.getClock().getTime();
        if (this.lastTailTimestampRefresh + TimeUnit.MINUTES.toMillis(1L) > now) {
            return;
        }
        this.lastTailTimestampRefresh = now;
        Document doc = this.ns.getDocumentStore().find(Collection.SETTINGS, JOURNAL_GC_ID);
        if (doc == null) {
            return;
        }
        Long ts = Utils.asLong((Number)doc.get(TAIL_TIMESTAMP));
        if (ts != null) {
            this.tailRevision = Utils.max(this.tailRevision, new Revision(ts, 0, this.ns.getClusterId()));
        }
    }

    private List<String> asKeys(List<JournalEntry> deletionBatch) {
        ArrayList<String> keys = new ArrayList<String>(deletionBatch.size());
        for (JournalEntry e : deletionBatch) {
            keys.add(e.getId());
        }
        return keys;
    }
}

