/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalEntry
extends Document {
    private static final Logger LOG = LoggerFactory.getLogger(JournalEntry.class);
    private static final String REVISION_FORMAT = "%d-%0" + Long.toHexString(Long.MAX_VALUE).length() + "x-%0" + Integer.toHexString(Integer.MAX_VALUE).length() + "x";
    private static final String CHANGES = "_c";
    private static final String BRANCH_COMMITS = "_bc";
    public static final String MODIFIED = "_modified";
    private static final int READ_CHUNK_SIZE = 100;
    private static final int STRING_SORT_OVERFLOW_TO_DISK_THRESHOLD = Integer.getInteger("oak.overflowToDiskThreshold", 2048);
    private final DocumentStore store;
    private volatile TreeNode changes = null;
    private boolean concurrent;

    JournalEntry(DocumentStore store) {
        this(store, false);
    }

    JournalEntry(DocumentStore store, boolean concurrent) {
        this.store = store;
        this.concurrent = concurrent;
    }

    static StringSort newSorter() {
        return new StringSort(STRING_SORT_OVERFLOW_TO_DISK_THRESHOLD, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareTo(arg1);
            }
        });
    }

    static void applyTo(@Nonnull StringSort externalSort, @Nonnull DiffCache diffCache, @Nonnull RevisionVector from, @Nonnull RevisionVector to) throws IOException {
        LOG.debug("applyTo: starting for {} to {}", (Object)from, (Object)to);
        LOG.debug("applyTo: sorting done.");
        DiffCache.Entry entry = Preconditions.checkNotNull(diffCache).newEntry(from, to, false);
        Iterator<String> it = externalSort.getIds();
        if (!it.hasNext()) {
            entry.append("/", "");
            entry.done();
            return;
        }
        String previousPath = it.next();
        TreeNode node = new TreeNode();
        node = node.getOrCreatePath(previousPath);
        int totalCnt = 0;
        int deDuplicatedCnt = 0;
        while (it.hasNext()) {
            ++totalCnt;
            String currentPath = it.next();
            if (previousPath.equals(currentPath)) continue;
            TreeNode currentNode = node.getOrCreatePath(currentPath);
            while (node != null && !node.isAncestorOf(currentNode)) {
                entry.append(node.getPath(), JournalEntry.getChanges(node));
                ++deDuplicatedCnt;
                node.children = TreeNode.NO_CHILDREN;
                node = node.parent;
            }
            if (node == null) {
                node = new TreeNode();
                node = node.getOrCreatePath(currentPath);
            } else {
                node = currentNode;
            }
            previousPath = currentPath;
        }
        while (node != null) {
            entry.append(node.getPath(), JournalEntry.getChanges(node));
            ++deDuplicatedCnt;
            node = node.parent;
        }
        entry.done();
        LOG.debug("applyTo: done. totalCnt: {}, deDuplicatedCnt: {}", (Object)totalCnt, (Object)deDuplicatedCnt);
    }

    static void fillExternalChanges(@Nonnull StringSort sorter, @Nonnull Revision from, @Nonnull Revision to, @Nonnull DocumentStore store) throws IOException {
        Preconditions.checkArgument(Preconditions.checkNotNull(from).getClusterId() == Preconditions.checkNotNull(to).getClusterId());
        if (from.compareRevisionTime(to) >= 0) {
            return;
        }
        String inclusiveToId = JournalEntry.asId(to);
        to = new Revision(to.getTimestamp(), to.getCounter() + 1, to.getClusterId(), to.isBranch());
        String toId = JournalEntry.asId(to);
        String fromId = JournalEntry.asId(from);
        int numEntries = 0;
        Document lastEntry = null;
        while (!fromId.equals(inclusiveToId)) {
            List<JournalEntry> partialResult = store.query(Collection.JOURNAL, fromId, toId, 100);
            numEntries += partialResult.size();
            if (!partialResult.isEmpty()) {
                lastEntry = partialResult.get(partialResult.size() - 1);
            }
            for (JournalEntry d : partialResult) {
                d.addTo(sorter);
            }
            if (partialResult.size() < 100) break;
            fromId = partialResult.get(partialResult.size() - 1).getId();
        }
        if (numEntries == 0 || lastEntry != null && !lastEntry.getId().equals(inclusiveToId)) {
            String maxId = JournalEntry.asId(new Revision(Long.MAX_VALUE, 0, to.getClusterId()));
            for (JournalEntry d : store.query(Collection.JOURNAL, inclusiveToId, maxId, 1)) {
                d.addTo(sorter);
            }
        }
    }

    long getRevisionTimestamp() {
        String[] parts = this.getId().split("-");
        return Long.parseLong(parts[1], 16);
    }

    void modified(String path) {
        TreeNode node = this.getChanges();
        for (String name : PathUtils.elements(path)) {
            node = node.getOrCreate(name);
        }
    }

    void modified(Iterable<String> paths) {
        for (String p : paths) {
            this.modified(p);
        }
    }

    void branchCommit(@Nonnull Iterable<Revision> revisions) {
        String branchCommits = (String)this.get(BRANCH_COMMITS);
        if (branchCommits == null) {
            branchCommits = "";
        }
        for (Revision r : revisions) {
            if (branchCommits.length() > 0) {
                branchCommits = branchCommits + ",";
            }
            branchCommits = branchCommits + JournalEntry.asId(r.asBranchRevision());
        }
        this.put(BRANCH_COMMITS, branchCommits);
    }

    String getChanges(String path) {
        TreeNode node = this.getNode(path);
        if (node == null) {
            return "";
        }
        return JournalEntry.getChanges(node);
    }

    UpdateOp asUpdateOp(@Nonnull Revision revision) {
        String id = JournalEntry.asId(revision);
        UpdateOp op = new UpdateOp(id, true);
        op.set("_id", id);
        op.set(CHANGES, this.getChanges().serialize());
        op.set(MODIFIED, revision.getTimestamp());
        String bc = (String)this.get(BRANCH_COMMITS);
        if (bc != null) {
            op.set(BRANCH_COMMITS, bc);
        }
        return op;
    }

    void addTo(final StringSort sort) throws IOException {
        TreeNode n = this.getChanges();
        TraversingVisitor v = new TraversingVisitor(){

            @Override
            public void node(TreeNode node, String path) throws IOException {
                sort.add(path);
            }
        };
        n.accept(v, "/");
        for (JournalEntry e : this.getBranchCommits()) {
            e.getChanges().accept(v, "/");
        }
    }

    @Nonnull
    Iterable<JournalEntry> getBranchCommits() {
        final ArrayList<String> ids = Lists.newArrayList();
        String bc = (String)this.get(BRANCH_COMMITS);
        if (bc != null) {
            for (String id : bc.split(",")) {
                ids.add(id);
            }
        }
        return new Iterable<JournalEntry>(){

            @Override
            public Iterator<JournalEntry> iterator() {
                return new AbstractIterator<JournalEntry>(){
                    private final Iterator<String> it;
                    {
                        this.it = ids.iterator();
                    }

                    @Override
                    protected JournalEntry computeNext() {
                        if (!this.it.hasNext()) {
                            return (JournalEntry)this.endOfData();
                        }
                        String id = this.it.next();
                        JournalEntry d = JournalEntry.this.store.find(Collection.JOURNAL, id);
                        if (d == null) {
                            throw new IllegalStateException("Missing external change for branch revision: " + id);
                        }
                        return d;
                    }
                };
            }
        };
    }

    private static String getChanges(TreeNode node) {
        JsopBuilder builder = new JsopBuilder();
        for (String name : node.keySet()) {
            builder.tag('^');
            builder.key(name);
            builder.object().endObject();
        }
        return builder.toString();
    }

    static String asId(@Nonnull Revision revision) {
        Preconditions.checkNotNull(revision);
        String s = String.format(REVISION_FORMAT, revision.getClusterId(), revision.getTimestamp(), revision.getCounter());
        if (revision.isBranch()) {
            s = "b" + s;
        }
        return s;
    }

    @CheckForNull
    private TreeNode getNode(String path) {
        TreeNode node = this.getChanges();
        for (String name : PathUtils.elements(path)) {
            if ((node = node.get(name)) != null) continue;
            return null;
        }
        return node;
    }

    @Nonnull
    private TreeNode getChanges() {
        if (this.changes == null) {
            TreeNode node = new TreeNode(this.concurrent);
            String c = (String)this.get(CHANGES);
            if (c != null) {
                node.parse(new JsopTokenizer(c));
            }
            this.changes = node;
        }
        return this.changes;
    }

    private static interface MapFactory {
        public static final MapFactory DEFAULT = new MapFactory(){

            @Override
            public Map<String, TreeNode> newMap() {
                return Maps.newHashMap();
            }
        };
        public static final MapFactory CONCURRENT = new MapFactory(){

            @Override
            public Map<String, TreeNode> newMap() {
                return Maps.newConcurrentMap();
            }
        };

        public Map<String, TreeNode> newMap();
    }

    private static interface TraversingVisitor {
        public void node(TreeNode var1, String var2) throws IOException;
    }

    private static final class TreeNode {
        private static final Map<String, TreeNode> NO_CHILDREN = Collections.emptyMap();
        private Map<String, TreeNode> children = NO_CHILDREN;
        private final MapFactory mapFactory;
        private final TreeNode parent;
        private final String name;

        TreeNode() {
            this(false);
        }

        TreeNode(boolean concurrent) {
            this(concurrent ? MapFactory.CONCURRENT : MapFactory.DEFAULT, null, "");
        }

        TreeNode(MapFactory mapFactory, TreeNode parent, String name) {
            Preconditions.checkArgument(!name.contains("/"), "name must not contain '/': {}", name);
            this.mapFactory = mapFactory;
            this.parent = parent;
            this.name = name;
        }

        TreeNode getOrCreatePath(String path) {
            TreeNode n = this.getRoot();
            for (String name : PathUtils.elements(path)) {
                n = n.getOrCreate(name);
            }
            return n;
        }

        boolean isAncestorOf(TreeNode other) {
            TreeNode n = other;
            while (n.parent != null) {
                if (this == n.parent) {
                    return true;
                }
                n = n.parent;
            }
            return false;
        }

        @Nonnull
        private TreeNode getRoot() {
            TreeNode n = this;
            while (n.parent != null) {
                n = n.parent;
            }
            return n;
        }

        private String getPath() {
            return this.buildPath(new StringBuilder()).toString();
        }

        private StringBuilder buildPath(StringBuilder sb) {
            if (this.parent != null) {
                this.parent.buildPath(sb);
                if (this.parent.parent != null) {
                    sb.append("/");
                }
            } else {
                sb.append("/");
            }
            sb.append(this.name);
            return sb;
        }

        void parse(JsopReader reader) {
            reader.read(123);
            if (!reader.matches(125)) {
                do {
                    String name = Utils.unescapePropertyName(reader.readString());
                    reader.read(58);
                    this.getOrCreate(name).parse(reader);
                } while (reader.matches(44));
                reader.read(125);
            }
        }

        String serialize() {
            JsopBuilder builder = new JsopBuilder();
            builder.object();
            this.toJson(builder);
            builder.endObject();
            return builder.toString();
        }

        @Nonnull
        Set<String> keySet() {
            return this.children.keySet();
        }

        @CheckForNull
        TreeNode get(String name) {
            return this.children.get(name);
        }

        void accept(TraversingVisitor visitor, String path) throws IOException {
            visitor.node(this, path);
            for (Map.Entry<String, TreeNode> entry : this.children.entrySet()) {
                entry.getValue().accept(visitor, PathUtils.concat(path, entry.getKey()));
            }
        }

        private void toJson(JsopBuilder builder) {
            for (Map.Entry<String, TreeNode> entry : this.children.entrySet()) {
                builder.key(Utils.escapePropertyName(entry.getKey()));
                builder.object();
                entry.getValue().toJson(builder);
                builder.endObject();
            }
        }

        @Nonnull
        private TreeNode getOrCreate(String name) {
            TreeNode c;
            if (this.children == NO_CHILDREN) {
                this.children = this.mapFactory.newMap();
            }
            if ((c = this.children.get(name)) == null) {
                c = new TreeNode(this.mapFactory, this, name);
                this.children.put(name, c);
            }
            return c;
        }
    }
}

