/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.IOException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalDiffLoader
implements DiffCache.Loader {
    private static final Logger LOG = LoggerFactory.getLogger(JournalDiffLoader.class);
    private final AbstractDocumentNodeState base;
    private final AbstractDocumentNodeState node;
    private final DocumentNodeStore ns;

    JournalDiffLoader(@Nonnull AbstractDocumentNodeState base, @Nonnull AbstractDocumentNodeState node, @Nonnull DocumentNodeStore ns) {
        this.base = base;
        this.node = node;
        this.ns = ns;
    }

    @Override
    public String call() {
        int clusterId;
        RevisionVector afterRev = this.node.getRootRevision();
        RevisionVector beforeRev = this.base.getRootRevision();
        JournalEntry localPending = this.ns.getCurrentJournalEntry();
        DocumentStore store = this.ns.getDocumentStore();
        NodeDocument root = Utils.getRootDocument(store);
        Map<Integer, Revision> lastRevs = root.getLastRev();
        Revision localLastRev = lastRevs.get(clusterId = this.ns.getClusterId());
        if (localLastRev == null) {
            throw new IllegalStateException("Root document does not have a lastRev entry for local clusterId " + clusterId);
        }
        StringSort changes = JournalEntry.newSorter();
        try {
            this.readTrunkChanges(beforeRev, afterRev, localPending, localLastRev, changes);
            this.readBranchChanges(beforeRev, changes);
            this.readBranchChanges(afterRev, changes);
            changes.sort();
            DiffCache df = this.ns.getDiffCache();
            WrappedDiffCache wrappedCache = new WrappedDiffCache(this.node.getPath(), df);
            JournalEntry.applyTo(changes, wrappedCache, beforeRev, afterRev);
            String string = wrappedCache.changes;
            return string;
        }
        catch (IOException e) {
            throw DocumentStoreException.convert(e);
        }
        finally {
            Utils.closeIfCloseable(changes);
        }
    }

    private void readBranchChanges(RevisionVector rv, StringSort changes) throws IOException {
        if (!rv.isBranch() || this.ns.isDisableBranches()) {
            return;
        }
        Branch b = this.ns.getBranches().getBranch(rv);
        if (b == null) {
            if (!this.ns.getBranches().isBranchBase(rv)) {
                JournalDiffLoader.missingBranch(rv);
            }
            return;
        }
        DocumentStore store = this.ns.getDocumentStore();
        for (Revision br : b.getCommits()) {
            Branch.BranchCommit bc = b.getCommit(br);
            if (bc.isRebase()) continue;
            JournalEntry entry = store.find(Collection.JOURNAL, JournalEntry.asId(br));
            if (entry != null) {
                entry.addTo(changes);
                continue;
            }
            LOG.warn("Missing journal entry for {}", (Object)JournalEntry.asId(br));
        }
    }

    private void readTrunkChanges(RevisionVector beforeRev, RevisionVector afterRev, JournalEntry localPending, Revision localLastRev, StringSort changes) throws IOException {
        if (this.ns.isDisableBranches()) {
            beforeRev = beforeRev.asTrunkRevision();
            afterRev = afterRev.asTrunkRevision();
        } else {
            beforeRev = this.getBaseRevision(beforeRev);
            afterRev = this.getBaseRevision(afterRev);
        }
        if (beforeRev.equals(afterRev)) {
            return;
        }
        int clusterId = this.ns.getClusterId();
        RevisionVector max = beforeRev.pmax(afterRev);
        RevisionVector min = beforeRev.pmin(afterRev);
        for (Revision to : max) {
            Revision from = min.getRevision(to.getClusterId());
            if (from == null) {
                from = new Revision(0L, 0, to.getClusterId());
            }
            JournalEntry.fillExternalChanges(changes, from, to, this.ns.getDocumentStore());
        }
        if (!max.isRevisionNewer(localLastRev) && !localLastRev.equals(max.getRevision(clusterId))) {
            localPending.addTo(changes);
        }
    }

    @Nonnull
    private RevisionVector getBaseRevision(RevisionVector rv) {
        if (!rv.isBranch()) {
            return rv;
        }
        Branch b = this.ns.getBranches().getBranch(rv);
        if (b != null) {
            rv = b.getBase(rv.getBranchRevision());
        } else if (this.ns.getBranches().isBranchBase(rv)) {
            rv = rv.asTrunkRevision();
        } else {
            JournalDiffLoader.missingBranch(rv);
        }
        return rv;
    }

    private static void missingBranch(RevisionVector rv) {
        throw new IllegalStateException("Missing branch for revision " + rv);
    }

    private static class WrappedDiffCache
    extends DiffCache {
        private final String path;
        private String changes = "";
        private final DiffCache cache;

        WrappedDiffCache(String path, DiffCache cache) {
            this.path = path;
            this.cache = cache;
        }

        @CheckForNull
        String getChanges() {
            return this.changes;
        }

        @Override
        String getChanges(@Nonnull RevisionVector from, @Nonnull RevisionVector to, @Nonnull String path, @Nullable DiffCache.Loader loader) {
            return this.cache.getChanges(from, to, path, loader);
        }

        @Override
        @Nonnull
        DiffCache.Entry newEntry(@Nonnull RevisionVector from, @Nonnull RevisionVector to, boolean local) {
            final DiffCache.Entry entry = this.cache.newEntry(from, to, local);
            return new DiffCache.Entry(){

                @Override
                public void append(@Nonnull String path, @Nonnull String changes) {
                    entry.append(path, changes);
                    if (path.equals(WrappedDiffCache.this.path)) {
                        WrappedDiffCache.this.changes = changes;
                    }
                }

                @Override
                public boolean done() {
                    return entry.done();
                }
            };
        }

        @Override
        @Nonnull
        Iterable<CacheStats> getStats() {
            return this.cache.getStats();
        }
    }
}

