/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.cache.StringCache;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.json.TypeCodes;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

final class DocumentPropertyState
implements PropertyState {
    private final DocumentNodeStore store;
    private final String name;
    private final String value;
    private PropertyState parsed;

    DocumentPropertyState(DocumentNodeStore store, String name, String value) {
        this.store = store;
        this.name = name;
        this.value = value;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isArray() {
        return this.parsed().isArray();
    }

    @Override
    public Type<?> getType() {
        return this.parsed().getType();
    }

    @Override
    @Nonnull
    public <T> T getValue(Type<T> type) {
        return this.parsed().getValue(type);
    }

    @Override
    @Nonnull
    public <T> T getValue(Type<T> type, int index) {
        return this.parsed().getValue(type, index);
    }

    @Override
    public long size() {
        return this.parsed().size();
    }

    @Override
    public long size(int index) {
        return this.parsed().size(index);
    }

    @Override
    public int count() {
        return this.parsed().count();
    }

    @Nonnull
    String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DocumentPropertyState) {
            DocumentPropertyState other = (DocumentPropertyState)object;
            return this.name.equals(other.name) && this.value.equals(other.value);
        }
        return object instanceof PropertyState && AbstractPropertyState.equal(this.parsed(), (PropertyState)object);
    }

    public int hashCode() {
        return AbstractPropertyState.hashCode(this);
    }

    public String toString() {
        return AbstractPropertyState.toString(this);
    }

    private PropertyState parsed() {
        if (this.parsed == null) {
            JsopTokenizer reader = new JsopTokenizer(this.value);
            this.parsed = reader.matches(91) ? this.readArrayProperty(this.name, reader) : this.readProperty(this.name, reader);
        }
        return this.parsed;
    }

    PropertyState readProperty(String name, JsopReader reader) {
        return DocumentPropertyState.readProperty(name, this.store, reader);
    }

    static PropertyState readProperty(String name, DocumentNodeStore store, JsopReader reader) {
        if (reader.matches(2)) {
            String number = reader.getToken();
            try {
                return new LongPropertyState(name, Long.parseLong(number));
            }
            catch (NumberFormatException e) {
                return new DoublePropertyState(name, Double.parseDouble(number));
            }
        }
        if (reader.matches(3)) {
            return BooleanPropertyState.booleanProperty(name, true);
        }
        if (reader.matches(4)) {
            return BooleanPropertyState.booleanProperty(name, false);
        }
        if (reader.matches(1)) {
            String jsonString = reader.getToken();
            if (jsonString.startsWith("[0]:")) {
                int type = PropertyType.valueFromName(jsonString.substring("[0]:".length()));
                return PropertyStates.createProperty(name, Collections.emptyList(), Type.fromTag(type, true));
            }
            int split = TypeCodes.split(jsonString);
            if (split != -1) {
                int type = TypeCodes.decodeType(split, jsonString);
                String value = TypeCodes.decodeName(split, jsonString);
                if (type == 2) {
                    return BinaryPropertyState.binaryProperty(name, store.getBlobFromBlobId(value));
                }
                return PropertyStates.createProperty(name, StringCache.get(value), type);
            }
            return StringPropertyState.stringProperty(name, StringCache.get(jsonString));
        }
        throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
    }

    PropertyState readArrayProperty(String name, JsopReader reader) {
        return DocumentPropertyState.readArrayProperty(name, this.store, reader);
    }

    static PropertyState readArrayProperty(String name, DocumentNodeStore store, JsopReader reader) {
        int type = 1;
        ArrayList<Object> values = Lists.newArrayList();
        while (!reader.matches(93)) {
            if (reader.matches(2)) {
                String number = reader.getToken();
                try {
                    type = 3;
                    values.add(Long.parseLong(number));
                }
                catch (NumberFormatException e) {
                    type = 4;
                    values.add(Double.parseDouble(number));
                }
            } else if (reader.matches(3)) {
                type = 6;
                values.add(true);
            } else if (reader.matches(4)) {
                type = 6;
                values.add(false);
            } else if (reader.matches(1)) {
                String jsonString = reader.getToken();
                int split = TypeCodes.split(jsonString);
                if (split != -1) {
                    type = TypeCodes.decodeType(split, jsonString);
                    String value = TypeCodes.decodeName(split, jsonString);
                    if (type == 2) {
                        values.add(store.getBlobFromBlobId(value));
                    } else if (type == 4) {
                        values.add(Conversions.convert(value).toDouble());
                    } else if (type == 12) {
                        values.add(Conversions.convert(value).toDecimal());
                    } else {
                        values.add(StringCache.get(value));
                    }
                } else {
                    type = 1;
                    values.add(StringCache.get(jsonString));
                }
            } else {
                throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
            }
            reader.matches(44);
        }
        return PropertyStates.createProperty(name, values, Type.fromTag(type, true));
    }
}

