/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.BackgroundReadStats;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.BatchCommitQueue;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.ClusterStateChangeListener;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitQueue;
import org.apache.jackrabbit.oak.plugins.document.ConflictException;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.document.DocumentBroadcastConfig;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStateCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.JournalDiffLoader;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.JournalGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.JsopNodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.LastRevRecoveryAgent;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.MergeCommit;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.PrefetchDispatcher;
import org.apache.jackrabbit.oak.plugins.document.ResetDiff;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UnmergedBranches;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.util.LeaseCheckDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.LoggingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.ReadOnlyDocumentStoreWrapperFactory;
import org.apache.jackrabbit.oak.plugins.document.util.TimingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentNodeStore
implements NodeStore,
RevisionContext,
Observable,
Clusterable,
NodeStateDiffer {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStore.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger(DocumentNodeStore.class.getName() + ".perf"));
    static final int NUM_CHILDREN_CACHE_LIMIT = Integer.getInteger("oak.documentMK.childrenCacheLimit", 16384);
    private boolean enableConcurrentAddRemove = Boolean.getBoolean("oak.enableConcurrentAddRemove");
    private boolean fairBackgroundOperationLock = Boolean.parseBoolean(System.getProperty("oak.fairBackgroundOperationLock", "true"));
    private long recoveryWaitTimeoutMS = Long.getLong("oak.recoveryWaitTimeoutMS", 60000L);
    private boolean disableJournalDiff = Boolean.getBoolean("oak.disableJournalDiff");
    protected final DocumentStore store;
    protected final DocumentNodeState missing;
    protected final CommitQueue commitQueue;
    protected final BatchCommitQueue batchCommitQueue;
    protected final ChangeDispatcher dispatcher;
    protected int asyncDelay = 1000;
    protected int maxBackOffMillis = Integer.getInteger("oak.maxBackOffMS", this.asyncDelay * 2);
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    @Nonnull
    private final ClusterNodeInfo clusterNodeInfo;
    private final int clusterId;
    private final ConcurrentMap<Integer, ClusterNodeInfoDocument> clusterNodes = Maps.newConcurrentMap();
    private final UnmergedBranches branches;
    private final UnsavedModifications unsavedLastRevisions = new UnsavedModifications();
    private final Map<String, String> splitCandidates = Maps.newConcurrentMap();
    private JournalEntry changes;
    private volatile DocumentNodeState root;
    private Thread backgroundReadThread;
    private final Object backgroundReadMonitor = new Object();
    private Thread backgroundUpdateThread;
    private final Object backgroundWriteMonitor = new Object();
    @Nonnull
    private Thread leaseUpdateThread;
    private final ReadWriteLock backgroundOperationLock = new ReentrantReadWriteLock(this.fairBackgroundOperationLock);
    private final ReadWriteLock mergeLock = new ReentrantReadWriteLock();
    private AtomicInteger simpleRevisionCounter;
    private final Cache<PathRev, DocumentNodeState> nodeCache;
    private final CacheStats nodeCacheStats;
    private final Cache<PathRev, DocumentNodeState.Children> nodeChildrenCache;
    private final CacheStats nodeChildrenCacheStats;
    private final DiffCache diffCache;
    private final BlobStore blobStore;
    private ClusterStateChangeListener clusterStateChangeListener;
    private final BlobSerializer blobSerializer = new BlobSerializer(){

        @Override
        public String serialize(Blob blob) {
            String id;
            BlobStoreBlob bsb;
            BlobStore bsbBlobStore;
            if (blob instanceof BlobStoreBlob && (bsbBlobStore = (bsb = (BlobStoreBlob)blob).getBlobStore()) != null && bsbBlobStore.equals(DocumentNodeStore.this.blobStore)) {
                return bsb.getBlobId();
            }
            String reference = blob.getReference();
            if (reference != null && (id = DocumentNodeStore.this.blobStore.getBlobId(reference)) != null) {
                return id;
            }
            try {
                id = DocumentNodeStore.this.createBlob(blob.getNewStream()).getBlobId();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return id;
        }
    };
    private final Predicate<String> isBinary = new Predicate<String>(){

        @Override
        public boolean apply(@Nullable String input) {
            if (input == null) {
                return false;
            }
            return new DocumentPropertyState(DocumentNodeStore.this, "p", input).getType().tag() == 2;
        }
    };
    private final Clock clock;
    private final Checkpoints checkpoints;
    private final VersionGarbageCollector versionGarbageCollector;
    private final JournalGarbageCollector journalGarbageCollector;
    private final Iterable<ReferencedBlob> referencedBlobs;
    private final Executor executor;
    private final LastRevRecoveryAgent lastRevRecoveryAgent;
    private final boolean disableBranches;
    private PersistentCache persistentCache;
    private PersistentCache journalCache;
    private final DocumentNodeStoreMBean mbean;
    private final boolean readOnlyMode;
    private DocumentNodeStateCache nodeStateCache = DocumentNodeStateCache.NOOP;
    private final DocumentNodeStoreStatsCollector nodeStoreStatsCollector;
    private final StatisticsProvider statisticsProvider;

    public DocumentNodeStore(DocumentMK.Builder builder) {
        this.blobStore = builder.getBlobStore();
        this.statisticsProvider = builder.getStatisticsProvider();
        this.nodeStoreStatsCollector = builder.getNodeStoreStatsCollector();
        if (builder.isUseSimpleRevision()) {
            this.simpleRevisionCounter = new AtomicInteger(0);
        }
        DocumentStore s = builder.getDocumentStore();
        if (builder.getTiming()) {
            s = new TimingDocumentStoreWrapper(s);
        }
        if (builder.getLogging()) {
            s = new LoggingDocumentStoreWrapper(s);
        }
        if (builder.getReadOnlyMode()) {
            s = ReadOnlyDocumentStoreWrapperFactory.getInstance(s);
            this.readOnlyMode = true;
        } else {
            this.readOnlyMode = false;
        }
        this.executor = builder.getExecutor();
        this.clock = builder.getClock();
        int cid = builder.getClusterId();
        cid = Integer.getInteger("oak.documentMK.clusterId", cid);
        this.clusterNodeInfo = this.readOnlyMode ? ClusterNodeInfo.getReadOnlyInstance(s) : ClusterNodeInfo.getInstance(s, cid);
        cid = this.clusterNodeInfo.getId();
        if (builder.getLeaseCheck()) {
            s = new LeaseCheckDocumentStoreWrapper(s, this.clusterNodeInfo);
            this.clusterNodeInfo.setLeaseFailureHandler(builder.getLeaseFailureHandler());
        } else {
            this.clusterNodeInfo.setLeaseCheckDisabled(true);
        }
        this.store = s;
        this.changes = this.newJournalEntry();
        this.clusterId = cid;
        this.branches = new UnmergedBranches();
        this.asyncDelay = builder.getAsyncDelay();
        this.versionGarbageCollector = new VersionGarbageCollector(this, builder.createVersionGCSupport());
        this.journalGarbageCollector = new JournalGarbageCollector(this);
        this.referencedBlobs = builder.createReferencedBlobs(this);
        this.lastRevRecoveryAgent = new LastRevRecoveryAgent(this, builder.createMissingLastRevSeeker());
        this.disableBranches = builder.isDisableBranches();
        this.missing = new DocumentNodeState(this, "MISSING", new RevisionVector(new Revision(0L, 0, 0))){

            @Override
            public int getMemory() {
                return 8;
            }
        };
        this.nodeCache = builder.buildNodeCache(this);
        this.nodeCacheStats = new CacheStats(this.nodeCache, "Document-NodeState", builder.getWeigher(), builder.getNodeCacheSize());
        this.nodeChildrenCache = builder.buildChildrenCache();
        this.nodeChildrenCacheStats = new CacheStats(this.nodeChildrenCache, "Document-NodeChildren", builder.getWeigher(), builder.getChildrenCacheSize());
        this.diffCache = builder.getDiffCache();
        this.checkpoints = new Checkpoints(this);
        NodeDocument rootDoc = this.store.find(Collection.NODES, Utils.getIdFromPath("/"));
        if (rootDoc == null) {
            Revision commitRev = this.newRevision();
            Commit commit = new Commit(this, commitRev, null);
            RevisionVector head = new RevisionVector(commitRev);
            DocumentNodeState n = new DocumentNodeState(this, "/", head);
            commit.addNode(n);
            commit.applyToDocumentStore();
            this.unsavedLastRevisions.put("/", commitRev);
            this.setRoot(head);
            this.backgroundWrite();
            rootDoc = this.store.find(Collection.NODES, Utils.getIdFromPath("/"));
            if (rootDoc == null) {
                throw new IllegalStateException("Root document does not exist");
            }
        } else {
            if (!this.readOnlyMode) {
                this.checkLastRevRecovery();
            }
            this.initializeRootState(rootDoc);
            if (!rootDoc.getLastRev().containsKey(this.clusterId)) {
                this.unsavedLastRevisions.put("/", this.getRoot().getRootRevision().getRevision(this.clusterId));
                if (!this.readOnlyMode) {
                    this.backgroundWrite();
                }
            }
        }
        this.renewClusterIdLease();
        this.branches.init(this.store, this);
        this.dispatcher = builder.isPrefetchExternalChanges() ? new PrefetchDispatcher(this.getRoot(), this.executor) : new ChangeDispatcher(this.getRoot());
        this.commitQueue = new CommitQueue(this);
        String threadNamePostfix = "(" + this.clusterId + ")";
        this.batchCommitQueue = new BatchCommitQueue(this.store);
        this.backgroundReadThread = new Thread((Runnable)new BackgroundReadOperation(this, this.isDisposed), "DocumentNodeStore background read thread " + threadNamePostfix);
        this.backgroundReadThread.setDaemon(true);
        this.backgroundUpdateThread = new Thread((Runnable)new BackgroundOperation(this, this.isDisposed), "DocumentNodeStore background update thread " + threadNamePostfix);
        this.backgroundUpdateThread.setDaemon(true);
        this.backgroundReadThread.start();
        if (!this.readOnlyMode) {
            this.backgroundUpdateThread.start();
        }
        this.leaseUpdateThread = new Thread((Runnable)new BackgroundLeaseUpdate(this, this.isDisposed), "DocumentNodeStore lease update thread " + threadNamePostfix);
        this.leaseUpdateThread.setDaemon(true);
        this.leaseUpdateThread.setPriority(10);
        if (!this.readOnlyMode) {
            this.leaseUpdateThread.start();
        }
        this.persistentCache = builder.getPersistentCache();
        if (!this.readOnlyMode && this.persistentCache != null) {
            DocumentBroadcastConfig broadcastConfig = new DocumentBroadcastConfig(this);
            this.persistentCache.setBroadcastConfig(broadcastConfig);
        }
        this.journalCache = builder.getJournalCache();
        this.mbean = this.createMBean();
        LOG.info("Initialized DocumentNodeStore with clusterNodeId: {} ({})", (Object)this.clusterId, (Object)this.getClusterNodeInfoDisplayString());
    }

    private void checkLastRevRecovery() throws DocumentStoreException {
        long timeout = this.clock.getTime() + this.recoveryWaitTimeoutMS;
        int numRecovered = this.lastRevRecoveryAgent.recover(this.clusterId, timeout);
        if (numRecovered == -1) {
            ClusterNodeInfoDocument doc = this.store.find(Collection.CLUSTER_NODES, String.valueOf(this.clusterId));
            String otherId = "n/a";
            if (doc != null) {
                otherId = String.valueOf(doc.get("recoveryBy"));
            }
            String msg = "This cluster node (" + this.clusterId + ") requires " + "_lastRev recovery which is currently performed by " + "another cluster node (" + otherId + "). Recovery is " + "still ongoing after " + this.recoveryWaitTimeoutMS + " ms. " + "Failing startup of this DocumentNodeStore now!";
            throw new DocumentStoreException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LOG.info("Starting disposal of DocumentNodeStore with clusterNodeId: {} ({})", (Object)this.clusterId, (Object)this.getClusterNodeInfoDisplayString());
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isDisposed;
        synchronized (atomicBoolean) {
            this.isDisposed.notifyAll();
        }
        try {
            this.backgroundReadThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.backgroundUpdateThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!this.readOnlyMode) {
            try {
                this.internalRunBackgroundUpdateOperations();
            }
            catch (AssertionError ae) {
                LOG.error("dispose: an AssertionError happened during dispose's last background ops: " + ae, (Throwable)((Object)ae));
            }
        }
        try {
            this.leaseUpdateThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.clusterNodeInfo.dispose();
        this.store.dispose();
        if (this.blobStore instanceof Closeable) {
            try {
                ((Closeable)((Object)this.blobStore)).close();
            }
            catch (IOException ex) {
                LOG.debug("Error closing blob store " + this.blobStore, ex);
            }
        }
        if (this.persistentCache != null) {
            this.persistentCache.close();
        }
        if (this.journalCache != null) {
            this.journalCache.close();
        }
        LOG.info("Disposed DocumentNodeStore with clusterNodeId: {}", (Object)this.clusterId);
    }

    private String getClusterNodeInfoDisplayString() {
        return (this.readOnlyMode ? "readOnly:true, " : "") + this.clusterNodeInfo.toString().replaceAll("[\r\n\t]", " ").trim();
    }

    void setRoot(@Nonnull RevisionVector newHead) {
        Preconditions.checkArgument(!newHead.isBranch());
        this.root = this.getRoot(newHead);
    }

    @Nonnull
    public DocumentStore getDocumentStore() {
        return this.store;
    }

    @Nonnull
    Commit newCommit(@Nullable RevisionVector base, @Nullable DocumentNodeStoreBranch branch) {
        if (base == null) {
            base = this.getHeadRevision();
        }
        if (base.isBranch()) {
            return this.newBranchCommit(base, branch);
        }
        return this.newTrunkCommit(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    MergeCommit newMergeCommit(@Nullable RevisionVector base, int numBranchCommits) {
        MergeCommit c;
        if (base == null) {
            base = this.getHeadRevision();
        }
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            this.checkOpen();
            c = new MergeCommit(this, base, this.commitQueue.createRevisions(numBranchCommits));
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RevisionVector done(final @Nonnull Commit c, boolean isBranch, final @Nullable CommitInfo info) {
        if (this.commitQueue.contains(c.getRevision())) {
            try {
                final RevisionVector[] newHead = new RevisionVector[1];
                this.commitQueue.done(c.getRevision(), new CommitQueue.Callback(){

                    @Override
                    public void headOfQueue(@Nonnull Revision revision) {
                        RevisionVector before = DocumentNodeStore.this.getHeadRevision();
                        c.applyToCache(before, false);
                        DocumentNodeStore.this.changes.modified(c.getModifiedPaths());
                        newHead[0] = before.update(c.getRevision());
                        DocumentNodeStore.this.setRoot(newHead[0]);
                        DocumentNodeStore.this.commitQueue.headRevisionChanged();
                        DocumentNodeStore.this.dispatcher.contentChanged(DocumentNodeStore.this.getRoot(), info);
                    }
                });
                RevisionVector revisionVector = newHead[0];
                return revisionVector;
            }
            finally {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        c.applyToCache(c.getBaseRevision(), isBranch);
        return c.getBaseRevision().update(c.getRevision().asBranchRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void canceled(Commit c) {
        if (this.commitQueue.contains(c.getRevision())) {
            try {
                this.commitQueue.canceled(c.getRevision());
            }
            finally {
                this.backgroundOperationLock.readLock().unlock();
            }
        } else {
            Branch b = this.branches.getBranch(c.getBaseRevision());
            if (b != null) {
                b.removeCommit(c.getRevision().asBranchRevision());
            }
        }
    }

    public void setAsyncDelay(int delay) {
        this.asyncDelay = delay;
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    public void setMaxBackOffMillis(int time) {
        this.maxBackOffMillis = time;
    }

    public int getMaxBackOffMillis() {
        return this.maxBackOffMillis;
    }

    void setEnableConcurrentAddRemove(boolean b) {
        this.enableConcurrentAddRemove = b;
    }

    boolean getEnableConcurrentAddRemove() {
        return this.enableConcurrentAddRemove;
    }

    @Nonnull
    public ClusterNodeInfo getClusterInfo() {
        return this.clusterNodeInfo;
    }

    public CacheStats getNodeCacheStats() {
        return this.nodeCacheStats;
    }

    public CacheStats getNodeChildrenCacheStats() {
        return this.nodeChildrenCacheStats;
    }

    @Nonnull
    public Iterable<CacheStats> getDiffCacheStats() {
        return this.diffCache.getStats();
    }

    JournalEntry getCurrentJournalEntry() {
        return this.changes;
    }

    void invalidateNodeChildrenCache() {
        this.nodeChildrenCache.invalidateAll();
    }

    void invalidateNodeCache(String path, RevisionVector revision) {
        this.nodeCache.invalidate(new PathRev(path, revision));
    }

    public int getPendingWriteCount() {
        return this.unsavedLastRevisions.getPaths().size();
    }

    public boolean isDisableBranches() {
        return this.disableBranches;
    }

    void addSplitCandidate(String id) {
        this.splitCandidates.put(id, id);
    }

    @CheckForNull
    AbstractDocumentNodeState getSecondaryNodeState(@Nonnull String path, @Nonnull RevisionVector rootRevision, @Nonnull RevisionVector rev) {
        return this.nodeStateCache.getDocumentNodeState(path, rootRevision, rev);
    }

    PropertyState createPropertyState(String name, String value) {
        return new DocumentPropertyState(this, name, Preconditions.checkNotNull(value));
    }

    @CheckForNull
    DocumentNodeState getNode(final @Nonnull String path, final @Nonnull RevisionVector rev) {
        Preconditions.checkNotNull(rev);
        Preconditions.checkNotNull(path);
        long start = PERFLOG.start();
        try {
            PathRev key = new PathRev(path, rev);
            DocumentNodeState node = this.nodeCache.get(key, new Callable<DocumentNodeState>(){

                @Override
                public DocumentNodeState call() throws Exception {
                    boolean nodeDoesNotExist = DocumentNodeStore.this.checkNodeNotExistsFromChildrenCache(path, rev);
                    if (nodeDoesNotExist) {
                        return DocumentNodeStore.this.missing;
                    }
                    DocumentNodeState n = DocumentNodeStore.this.readNode(path, rev);
                    if (n == null) {
                        n = DocumentNodeStore.this.missing;
                    }
                    return n;
                }
            });
            DocumentNodeState result = node == this.missing || node.equals(this.missing) ? null : node;
            PERFLOG.end(start, 1L, "getNode: path={}, rev={}", (Object)path, (Object)rev);
            return result;
        }
        catch (UncheckedExecutionException e) {
            throw DocumentStoreException.convert(e.getCause());
        }
        catch (ExecutionException e) {
            throw DocumentStoreException.convert(e.getCause());
        }
    }

    @Nonnull
    DocumentNodeState.Children getChildren(final @Nonnull AbstractDocumentNodeState parent, final @Nullable String name, final int limit) throws DocumentStoreException {
        if (Preconditions.checkNotNull(parent).hasNoChildren()) {
            return DocumentNodeState.NO_CHILDREN;
        }
        String path = Preconditions.checkNotNull(parent).getPath();
        RevisionVector readRevision = parent.getLastRevision();
        try {
            PathRev key = DocumentNodeStore.childNodeCacheKey(path, readRevision, name);
            DocumentNodeState.Children children = this.nodeChildrenCache.get(key, new Callable<DocumentNodeState.Children>(){

                @Override
                public DocumentNodeState.Children call() throws Exception {
                    return DocumentNodeStore.this.readChildren(parent, name, limit);
                }
            });
            if (children.children.size() < limit && children.hasMore) {
                children = this.readChildren(parent, name, limit);
                this.nodeChildrenCache.put(key, children);
            }
            return children;
        }
        catch (UncheckedExecutionException e) {
            throw DocumentStoreException.convert(e.getCause(), "Error occurred while fetching children for path " + path);
        }
        catch (ExecutionException e) {
            throw DocumentStoreException.convert(e.getCause(), "Error occurred while fetching children for path " + path);
        }
    }

    DocumentNodeState.Children readChildren(AbstractDocumentNodeState parent, String name, int limit) {
        int numReturned;
        String queriedName = name;
        String path = parent.getPath();
        RevisionVector rev = parent.getLastRevision();
        LOG.trace("Reading children for [{}] at rev [{}]", (Object)path, (Object)rev);
        DocumentNodeState.Children c = new DocumentNodeState.Children();
        int rawLimit = (int)Math.min(Integer.MAX_VALUE, (long)limit + 1L);
        do {
            Iterable<NodeDocument> docs = this.readChildDocs(path, name, rawLimit);
            numReturned = 0;
            for (NodeDocument doc : docs) {
                ++numReturned;
                String p = doc.getPath();
                name = PathUtils.getName(p);
                DocumentNodeState child = this.getNode(p, rev);
                if (child == null) continue;
                if (c.children.size() < limit) {
                    c.children.add(Utils.unshareString(PathUtils.getName(p)));
                    continue;
                }
                c.hasMore = true;
                return c;
            }
        } while (numReturned >= rawLimit);
        c.hasMore = false;
        if (queriedName == null) {
            Collections.sort(c.children);
        }
        return c;
    }

    @Nonnull
    private Iterable<NodeDocument> readChildDocs(@Nonnull String path, @Nullable String name, int limit) {
        String to = Utils.getKeyUpperLimit(Preconditions.checkNotNull(path));
        String from = name != null ? Utils.getIdFromPath(PathUtils.concat(path, name)) : Utils.getKeyLowerLimit(path);
        return this.store.query(Collection.NODES, from, to, limit);
    }

    @Nonnull
    Iterable<DocumentNodeState> getChildNodes(final @Nonnull DocumentNodeState parent, @Nullable String name, int limit) {
        if (Preconditions.checkNotNull(parent).hasNoChildren()) {
            return Collections.emptyList();
        }
        final RevisionVector readRevision = parent.getLastRevision();
        return Iterables.transform(this.getChildren((AbstractDocumentNodeState)parent, (String)name, (int)limit).children, new Function<String, DocumentNodeState>(){

            @Override
            public DocumentNodeState apply(String input) {
                String p = PathUtils.concat(parent.getPath(), input);
                DocumentNodeState result = DocumentNodeStore.this.getNode(p, readRevision);
                if (result == null) {
                    String uncachedDocStr;
                    String cachedDocStr;
                    String id = Utils.getIdFromPath(p);
                    try {
                        cachedDocStr = DocumentNodeStore.this.store.find(Collection.NODES, id).asString();
                    }
                    catch (DocumentStoreException dse) {
                        cachedDocStr = dse.toString();
                    }
                    try {
                        uncachedDocStr = DocumentNodeStore.this.store.find(Collection.NODES, id, 0).asString();
                    }
                    catch (DocumentStoreException dse) {
                        uncachedDocStr = dse.toString();
                    }
                    String exceptionMsg = String.format("Aborting getChildNodes() - DocumentNodeState is null for %s at %s {\"cachedDoc\":{%s}, \"uncachedDoc\":{%s}}", readRevision, p, cachedDocStr, uncachedDocStr);
                    throw new DocumentStoreException(exceptionMsg);
                }
                return result;
            }
        });
    }

    @CheckForNull
    DocumentNodeState readNode(String path, RevisionVector readRevision) {
        long start = PERFLOG.start();
        String id = Utils.getIdFromPath(path);
        Revision lastRevision = this.getPendingModifications().get(path);
        NodeDocument doc = this.store.find(Collection.NODES, id);
        if (doc == null) {
            PERFLOG.end(start, 1L, "readNode: (document not found) path={}, readRevision={}", (Object)path, (Object)readRevision);
            return null;
        }
        DocumentNodeState result = doc.getNodeAtRevision(this, readRevision, lastRevision);
        PERFLOG.end(start, 1L, "readNode: path={}, readRevision={}", (Object)path, (Object)readRevision);
        return result;
    }

    void applyChanges(RevisionVector before, RevisionVector after, Revision rev, String path, boolean isNew, List<String> added, List<String> removed, List<String> changed, DiffCache.Entry cacheEntry) {
        PathRev key;
        if (isNew) {
            NodeDocument doc = this.store.getIfCached(Collection.NODES, Utils.getIdFromPath(path));
            RevisionVector afterLastRev = after;
            if (doc != null) {
                afterLastRev = new RevisionVector(doc.getLastRev().values());
                afterLastRev = afterLastRev.update(rev);
            }
            if (added.isEmpty()) {
                if (doc != null && doc.hasChildren()) {
                    PathRev key2 = DocumentNodeStore.childNodeCacheKey(path, afterLastRev, null);
                    LOG.debug("nodeChildrenCache.put({},{})", (Object)key2, (Object)"NO_CHILDREN");
                    this.nodeChildrenCache.put(key2, DocumentNodeState.NO_CHILDREN);
                }
            } else {
                DocumentNodeState.Children c = new DocumentNodeState.Children();
                TreeSet<String> set = Sets.newTreeSet();
                for (String p : added) {
                    set.add(Utils.unshareString(PathUtils.getName(p)));
                }
                c.children.addAll(set);
                key = DocumentNodeStore.childNodeCacheKey(path, afterLastRev, null);
                LOG.debug("nodeChildrenCache.put({},{})", (Object)key, (Object)c);
                this.nodeChildrenCache.put(key, c);
            }
        } else {
            DocumentNodeState beforeState = this.getRoot(before);
            int depth = PathUtils.getDepth(path);
            for (int i = 1; i <= depth && beforeState != null; ++i) {
                String p = PathUtils.getAncestorPath(path, depth - i);
                key = new PathRev(p, beforeState.getLastRevision());
                beforeState = this.nodeCache.getIfPresent(key);
            }
            DocumentNodeState.Children children = null;
            if (beforeState != null) {
                if (beforeState.hasNoChildren()) {
                    children = DocumentNodeState.NO_CHILDREN;
                } else {
                    PathRev key3 = DocumentNodeStore.childNodeCacheKey(path, beforeState.getLastRevision(), null);
                    children = this.nodeChildrenCache.getIfPresent(key3);
                }
            }
            if (children != null) {
                DocumentNodeState.Children c;
                AbstractSet afterChildren;
                PathRev afterKey = new PathRev(path, beforeState.getLastRevision().update(rev));
                if (added.isEmpty() && removed.isEmpty()) {
                    LOG.debug("nodeChildrenCache.put({},{})", (Object)afterKey, (Object)children);
                    this.nodeChildrenCache.put(afterKey, children);
                } else if (!children.hasMore) {
                    afterChildren = Sets.newTreeSet(children.children);
                    for (String p : added) {
                        afterChildren.add((String)Utils.unshareString(PathUtils.getName(p)));
                    }
                    for (String p : removed) {
                        afterChildren.remove(PathUtils.getName(p));
                    }
                    c = new DocumentNodeState.Children();
                    c.children.addAll(afterChildren);
                    if (c.children.size() <= 1600) {
                        LOG.debug("nodeChildrenCache.put({},{})", (Object)afterKey, (Object)c);
                        this.nodeChildrenCache.put(afterKey, c);
                    } else {
                        LOG.info("not caching more than {} child names for {}", (Object)1600, (Object)path);
                    }
                } else if (added.isEmpty()) {
                    afterChildren = Sets.newLinkedHashSet(children.children);
                    for (String p : removed) {
                        afterChildren.remove(PathUtils.getName(p));
                    }
                    c = new DocumentNodeState.Children();
                    c.children.addAll(afterChildren);
                    c.hasMore = true;
                    LOG.debug("nodeChildrenCache.put({},{})", (Object)afterKey, (Object)c);
                    this.nodeChildrenCache.put(afterKey, c);
                }
            }
        }
        JsopStream w = new JsopStream();
        for (String p : added) {
            w.tag('+').key(PathUtils.getName(p)).object().endObject();
        }
        for (String p : removed) {
            w.tag('-').value(PathUtils.getName(p));
        }
        for (String p : changed) {
            w.tag('^').key(PathUtils.getName(p)).object().endObject();
        }
        cacheEntry.append(path, ((Object)w).toString());
    }

    void revisionsMerged(@Nonnull Iterable<Revision> revisions) {
        this.changes.branchCommit(revisions);
    }

    @CheckForNull
    NodeDocument updateCommitRoot(UpdateOp commit, Revision commitRev) throws DocumentStoreException {
        boolean batch = true;
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> op : commit.getChanges().entrySet()) {
            String name = op.getKey().getName();
            if (NodeDocument.isRevisionsEntry(name) || "_modified".equals(name)) continue;
            batch = false;
            break;
        }
        try {
            if (batch) {
                return this.batchUpdateCommitRoot(commit);
            }
            return this.store.findAndUpdate(Collection.NODES, commit);
        }
        catch (DocumentStoreException e) {
            return this.verifyCommitRootUpdateApplied(commit, commitRev, e);
        }
    }

    private NodeDocument verifyCommitRootUpdateApplied(UpdateOp commit, Revision commitRev, DocumentStoreException e) throws DocumentStoreException {
        LOG.info("Update of commit root failed with exception", e);
        int numRetries = 10;
        for (int i = 0; i < numRetries; ++i) {
            NodeDocument commitRootDoc;
            LOG.info("Checking if change made it to the DocumentStore anyway {}/{} ...", (Object)(i + 1), (Object)numRetries);
            try {
                commitRootDoc = this.store.find(Collection.NODES, commit.getId(), 0);
            }
            catch (Exception ex) {
                LOG.info("Failed to read commit root document", ex);
                continue;
            }
            if (commitRootDoc == null) {
                LOG.info("Commit root document missing for {}", (Object)commit.getId());
                break;
            }
            if (!commitRootDoc.getLocalRevisions().containsKey(commitRev)) break;
            LOG.info("Update made it to the store even though the call failed with an exception. Previous exception will be suppressed. {}", (Object)commit);
            NodeDocument before = Collection.NODES.newDocument(this.store);
            commitRootDoc.deepCopy(before);
            UpdateUtils.applyChanges(before, commit.getReverseOperation());
            return before;
        }
        LOG.info("Update didn't make it to the store. Re-throwing the exception");
        throw e;
    }

    private NodeDocument batchUpdateCommitRoot(UpdateOp commit) throws DocumentStoreException {
        try {
            return this.batchCommitQueue.updateDocument(commit).call();
        }
        catch (InterruptedException e) {
            throw DocumentStoreException.convert(e, "Interrupted while updating commit root document");
        }
        catch (Exception e) {
            throw DocumentStoreException.convert(e, "Update of commit root document failed");
        }
    }

    @Nonnull
    DocumentNodeState getRoot(@Nonnull RevisionVector revision) {
        DocumentNodeState root = this.getNode("/", revision);
        if (root == null) {
            throw new IllegalStateException("root node does not exist at revision " + revision);
        }
        return root;
    }

    @Nonnull
    DocumentNodeStoreBranch createBranch(DocumentNodeState base) {
        DocumentNodeStoreBranch b = DocumentNodeStoreBranch.getCurrentBranch();
        if (b != null) {
            return b;
        }
        return new DocumentNodeStoreBranch(this, base, this.mergeLock);
    }

    @Nonnull
    RevisionVector rebase(@Nonnull RevisionVector branchHead, @Nonnull RevisionVector base) {
        Preconditions.checkNotNull(branchHead);
        Preconditions.checkNotNull(base);
        if (this.disableBranches) {
            return branchHead;
        }
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            return base.asBranchRevision(this.getClusterId());
        }
        if (b.getBase(branchHead.getBranchRevision()).equals(base)) {
            return branchHead;
        }
        Revision head = this.newRevision().asBranchRevision();
        b.rebase(head, base);
        return base.update(head);
    }

    @Nonnull
    RevisionVector reset(@Nonnull RevisionVector branchHead, @Nonnull RevisionVector ancestor) {
        Preconditions.checkNotNull(branchHead);
        Preconditions.checkNotNull(ancestor);
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            throw new DocumentStoreException("Empty branch cannot be reset");
        }
        if (!b.getCommits().last().equals(branchHead.getRevision(this.getClusterId()))) {
            throw new DocumentStoreException(branchHead + " is not the head " + "of a branch");
        }
        if (!b.containsCommit(ancestor.getBranchRevision()) && !b.getBase().asBranchRevision(this.getClusterId()).equals(ancestor)) {
            throw new DocumentStoreException(ancestor + " is not " + "an ancestor revision of " + branchHead);
        }
        Revision ancestorRev = ancestor.getBranchRevision();
        ancestorRev = new Revision(ancestorRev.getTimestamp(), ancestorRev.getCounter() + 1, ancestorRev.getClusterId(), true);
        ArrayList<Revision> revs = Lists.newArrayList(b.getCommits().tailSet(ancestorRev));
        if (revs.isEmpty()) {
            return branchHead;
        }
        UpdateOp rootOp = new UpdateOp(Utils.getIdFromPath("/"), false);
        HashMap<String, UpdateOp> operations = Maps.newHashMap();
        for (Revision r : Lists.reverse(revs)) {
            NodeDocument.removeCollision(rootOp, r.asTrunkRevision());
            NodeDocument.removeRevision(rootOp, r.asTrunkRevision());
            operations.clear();
            Branch.BranchCommit bc = b.getCommit(r);
            if (bc.isRebase()) continue;
            this.getRoot(bc.getBase().update(r)).compareAgainstBaseState(this.getRoot(bc.getBase()), new ResetDiff(r.asTrunkRevision(), operations));
            for (UpdateOp op : operations.values()) {
                this.store.findAndUpdate(Collection.NODES, op);
            }
        }
        this.store.findAndUpdate(Collection.NODES, rootOp);
        for (Revision r : revs) {
            b.removeCommit(r);
        }
        return ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    RevisionVector merge(@Nonnull RevisionVector branchHead, @Nullable CommitInfo info) throws CommitFailedException {
        RevisionVector newHead;
        Branch b = this.getBranches().getBranch(branchHead);
        RevisionVector base = branchHead;
        if (b != null) {
            base = b.getBase(branchHead.getBranchRevision());
        }
        int numBranchCommits = b != null ? b.getCommits().size() : 1;
        boolean success = false;
        MergeCommit commit = this.newMergeCommit(base, numBranchCommits);
        try {
            UpdateOp op = new UpdateOp(Utils.getIdFromPath("/"), false);
            NodeDocument.setModified(op, commit.getRevision());
            if (b != null) {
                commit.addBranchCommits(b);
                Iterator mergeCommits = commit.getMergeRevisions().iterator();
                for (Revision rev : b.getCommits()) {
                    rev = rev.asTrunkRevision();
                    String commitTag = "c-" + mergeCommits.next();
                    NodeDocument.setRevision(op, rev, commitTag);
                    op.containsMapEntry("_collisions", rev, false);
                }
                if (this.store.findAndUpdate(Collection.NODES, op) != null) {
                    b.applyTo(this.getPendingModifications(), commit.getRevision());
                    this.getBranches().remove(b);
                } else {
                    NodeDocument root = Utils.getRootDocument(this.store);
                    Set<Revision> conflictRevs = root.getConflictsFor(b.getCommits());
                    String msg = "Conflicting concurrent change. Update operation failed: " + op;
                    throw new ConflictException(msg, conflictRevs).asCommitFailedException();
                }
            }
            newHead = this.done(commit, false, info);
            success = true;
        }
        finally {
            if (!success) {
                this.canceled(commit);
            }
        }
        return newHead;
    }

    @Override
    public boolean compare(final @Nonnull AbstractDocumentNodeState node, final @Nonnull AbstractDocumentNodeState base, @Nonnull NodeStateDiff diff) {
        if (!AbstractNodeState.comparePropertiesAgainstBaseState(node, base, diff)) {
            return false;
        }
        if (node.hasNoChildren() && base.hasNoChildren()) {
            return true;
        }
        return new JsopNodeStateDiffer(this.diffCache.getChanges(base.getRootRevision(), node.getRootRevision(), node.getPath(), new DiffCache.Loader(){

            @Override
            public String call() {
                return DocumentNodeStore.this.diffImpl(base, node);
            }
        })).withoutPropertyChanges().compare(node, base, diff);
    }

    LastRevTracker createTracker(final @Nonnull Revision r, boolean isBranchCommit) {
        if (isBranchCommit && !this.disableBranches) {
            Revision branchRev = r.asBranchRevision();
            return this.branches.getBranchCommit(branchRev);
        }
        return new LastRevTracker(){

            @Override
            public void track(String path) {
                DocumentNodeStore.this.unsavedLastRevisions.put(path, r);
            }
        };
    }

    void suspendUntilAll(@Nonnull Set<Revision> conflictRevisions) {
        if (this.getAsyncDelay() == 0) {
            HashSet<Revision> onlyLocal = new HashSet<Revision>(conflictRevisions.size());
            for (Revision r : conflictRevisions) {
                if (r.getClusterId() != this.getClusterId()) continue;
                onlyLocal.add(r);
            }
            this.commitQueue.suspendUntilAll(onlyLocal);
        } else {
            this.commitQueue.suspendUntilAll(conflictRevisions);
        }
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.dispatcher.addObserver(observer);
    }

    @Override
    @Nonnull
    public DocumentNodeState getRoot() {
        return this.root;
    }

    @Override
    @Nonnull
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        return DocumentNodeStore.asDocumentRootBuilder(builder).merge(commitHook, info);
    }

    @Override
    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).rebase();
    }

    @Override
    public NodeState reset(@Nonnull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).reset();
    }

    @Override
    @Nonnull
    public BlobStoreBlob createBlob(InputStream inputStream) throws IOException {
        return new BlobStoreBlob(this.blobStore, this.blobStore.writeBlob(inputStream));
    }

    @Override
    public Blob getBlob(@Nonnull String reference) {
        String blobId = this.blobStore.getBlobId(reference);
        if (blobId != null) {
            return new BlobStoreBlob(this.blobStore, blobId);
        }
        LOG.debug("No blobId found matching reference [{}]", (Object)reference);
        return null;
    }

    public Blob getBlobFromBlobId(String blobId) {
        return new BlobStoreBlob(this.blobStore, blobId);
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        return this.checkpoints.create(lifetime, properties).toString();
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime) {
        Map<String, String> empty = Collections.emptyMap();
        return this.checkpoint(lifetime, empty);
    }

    @Override
    @Nonnull
    public Map<String, String> checkpointInfo(@Nonnull String checkpoint) {
        Revision r = Revision.fromString(checkpoint);
        Checkpoints.Info info = (Checkpoints.Info)this.checkpoints.getCheckpoints().get(r);
        if (info == null) {
            return Collections.emptyMap();
        }
        return info.get();
    }

    @Override
    @Nonnull
    public Iterable<String> checkpoints() {
        final long now = this.clock.getTime();
        return Iterables.transform(Iterables.filter(this.checkpoints.getCheckpoints().entrySet(), new Predicate<Map.Entry<Revision, Checkpoints.Info>>(){

            @Override
            public boolean apply(Map.Entry<Revision, Checkpoints.Info> cp) {
                return cp.getValue().getExpiryTime() > now;
            }
        }), new Function<Map.Entry<Revision, Checkpoints.Info>, String>(){

            @Override
            public String apply(Map.Entry<Revision, Checkpoints.Info> cp) {
                return cp.getKey().toString();
            }
        });
    }

    @Override
    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        RevisionVector rv = this.getCheckpoints().retrieve(checkpoint);
        if (rv == null) {
            return null;
        }
        this.suspendUntilAll(Sets.newHashSet(rv));
        return this.getRoot(rv);
    }

    @Override
    public boolean release(@Nonnull String checkpoint) {
        this.checkpoints.release(checkpoint);
        return true;
    }

    @Override
    public UnmergedBranches getBranches() {
        return this.branches;
    }

    @Override
    public UnsavedModifications getPendingModifications() {
        return this.unsavedLastRevisions;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    @Nonnull
    public RevisionVector getHeadRevision() {
        return this.root.getRootRevision();
    }

    @Override
    @Nonnull
    public Revision newRevision() {
        if (this.simpleRevisionCounter != null) {
            return new Revision(this.simpleRevisionCounter.getAndIncrement(), 0, this.clusterId);
        }
        return Revision.newRevision(this.clusterId);
    }

    public void runBackgroundOperations() {
        this.runBackgroundUpdateOperations();
        this.runBackgroundReadOperations();
    }

    void runBackgroundUpdateOperations() {
        if (this.readOnlyMode || this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundUpdateOperations();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                LOG.warn("Background update operation failed (will be retried with next run): " + e.toString(), e);
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunBackgroundUpdateOperations() {
        BackgroundWriteStats stats = null;
        Object object = this.backgroundWriteMonitor;
        synchronized (object) {
            long start;
            long time = start = this.clock.getTime();
            this.cleanOrphanedBranches();
            this.cleanCollisions();
            long cleanTime = this.clock.getTime() - time;
            time = this.clock.getTime();
            this.backgroundSplit();
            long splitTime = this.clock.getTime() - time;
            stats = this.backgroundWrite();
            stats.split = splitTime;
            stats.clean = cleanTime;
            stats.totalWriteTime = this.clock.getTime() - start;
            String msg = "Background operations stats ({})";
            if (stats.totalWriteTime > TimeUnit.SECONDS.toMillis(10L)) {
                LOG.info(msg, (Object)stats);
            } else {
                LOG.debug(msg, (Object)stats);
            }
        }
        this.nodeStoreStatsCollector.doneBackgroundUpdate(stats);
    }

    void runBackgroundReadOperations() {
        if (this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundReadOperations();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                LOG.warn("Background read operation failed: " + e.toString(), e);
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunBackgroundReadOperations() {
        BackgroundReadStats readStats = null;
        Object object = this.backgroundReadMonitor;
        synchronized (object) {
            long start = this.clock.getTime();
            readStats = this.backgroundRead();
            readStats.totalReadTime = this.clock.getTime() - start;
            String msg = "Background read operations stats (read:{} {})";
            if (this.clock.getTime() - start > TimeUnit.SECONDS.toMillis(10L)) {
                LOG.info(msg, (Object)readStats.totalReadTime, (Object)readStats);
            } else {
                LOG.debug(msg, (Object)readStats.totalReadTime, (Object)readStats);
            }
        }
        this.nodeStoreStatsCollector.doneBackgroundRead(readStats);
    }

    boolean renewClusterIdLease() {
        return this.clusterNodeInfo.renewLease();
    }

    boolean updateClusterState() {
        boolean hasChanged = false;
        HashSet<Integer> clusterIds = Sets.newHashSet();
        for (ClusterNodeInfoDocument doc : ClusterNodeInfoDocument.all(this.store)) {
            int cId = doc.getClusterId();
            clusterIds.add(cId);
            ClusterNodeInfoDocument old = (ClusterNodeInfoDocument)this.clusterNodes.get(cId);
            if (old != null && !old.isActive() && !doc.isActive()) continue;
            this.clusterNodes.put(cId, doc);
            if (old != null && old.isActive() == doc.isActive()) continue;
            hasChanged = true;
        }
        return hasChanged |= this.clusterNodes.keySet().retainAll(clusterIds);
    }

    @Nonnull
    RevisionVector getMinExternalRevisions() {
        return new RevisionVector(Iterables.transform(Iterables.filter(this.clusterNodes.values(), new Predicate<ClusterNodeInfoDocument>(){

            @Override
            public boolean apply(ClusterNodeInfoDocument input) {
                return input.getClusterId() != DocumentNodeStore.this.getClusterId();
            }
        }), new Function<ClusterNodeInfoDocument, Revision>(){

            @Override
            public Revision apply(ClusterNodeInfoDocument input) {
                return new Revision(input.getStartTime(), 0, input.getClusterId());
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundReadStats backgroundRead() {
        BackgroundReadStats stats;
        block19: {
            stats = new BackgroundReadStats();
            long time = this.clock.getTime();
            String id = Utils.getIdFromPath("/");
            NodeDocument doc = this.store.find(Collection.NODES, id, this.asyncDelay);
            if (doc == null) {
                return stats;
            }
            this.alignWithExternalRevisions(doc);
            StringSort externalSort = JournalEntry.newSorter();
            Map<Integer, Revision> lastRevMap = doc.getLastRev();
            try {
                RevisionVector headRevision = this.getHeadRevision();
                HashSet<Revision> externalChanges = Sets.newHashSet();
                for (Map.Entry<Integer, Revision> e : lastRevMap.entrySet()) {
                    int machineId = e.getKey();
                    if (machineId == this.clusterId) continue;
                    Revision r = e.getValue();
                    Revision last = headRevision.getRevision(machineId);
                    if (last == null) {
                        last = new Revision(0L, 0, machineId);
                    }
                    if (r.compareRevisionTime(last) <= 0) continue;
                    externalChanges.add(r);
                    if (externalSort == null) continue;
                    try {
                        JournalEntry.fillExternalChanges(externalSort, last, r, this.store);
                    }
                    catch (IOException e1) {
                        LOG.error("backgroundRead: Exception while reading external changes from journal: " + e1, e1);
                        IOUtils.closeQuietly(externalSort);
                        externalSort = null;
                    }
                }
                stats.readHead = this.clock.getTime() - time;
                time = this.clock.getTime();
                if (externalChanges.isEmpty()) break block19;
                if (externalSort == null) {
                    stats.cacheStats = this.store.invalidateCache();
                } else {
                    try {
                        externalSort.sort();
                        stats.numExternalChanges = externalSort.getSize();
                        stats.cacheStats = this.store.invalidateCache(Utils.pathToId(externalSort));
                    }
                    catch (Exception ioe) {
                        LOG.error("backgroundRead: got IOException during external sorting/cache invalidation (as a result, invalidating entire cache): " + ioe, ioe);
                        stats.cacheStats = this.store.invalidateCache();
                    }
                }
                stats.cacheInvalidationTime = this.clock.getTime() - time;
                time = this.clock.getTime();
                this.backgroundOperationLock.writeLock().lock();
                try {
                    RevisionVector oldHead;
                    stats.lock = this.clock.getTime() - time;
                    RevisionVector newHead = oldHead = this.getHeadRevision();
                    for (Revision r : externalChanges) {
                        newHead = newHead.update(r);
                    }
                    this.setRoot(newHead);
                    this.commitQueue.headRevisionChanged();
                    time = this.clock.getTime();
                    if (externalSort != null) {
                        try {
                            JournalEntry.applyTo(externalSort, this.diffCache, oldHead, newHead);
                        }
                        catch (Exception e1) {
                            LOG.error("backgroundRead: Exception while processing external changes from journal: {}", (Object)e1, (Object)e1);
                        }
                    }
                    stats.populateDiffCache = this.clock.getTime() - time;
                    time = this.clock.getTime();
                    this.dispatcher.contentChanged(this.getRoot().fromExternalChange(), null);
                }
                finally {
                    this.backgroundOperationLock.writeLock().unlock();
                }
                stats.dispatchChanges = this.clock.getTime() - time;
            }
            finally {
                IOUtils.closeQuietly(externalSort);
            }
        }
        return stats;
    }

    private void cleanOrphanedBranches() {
        Branch b;
        while ((b = this.branches.pollOrphanedBranch()) != null) {
            LOG.debug("Cleaning up orphaned branch with base revision: {}, commits: {}", (Object)b.getBase(), (Object)b.getCommits());
            UpdateOp op = new UpdateOp(Utils.getIdFromPath("/"), false);
            for (Revision r : b.getCommits()) {
                r = r.asTrunkRevision();
                NodeDocument.removeRevision(op, r);
            }
            this.store.findAndUpdate(Collection.NODES, op);
        }
    }

    private void cleanCollisions() {
        String id = Utils.getIdFromPath("/");
        NodeDocument root = this.store.find(Collection.NODES, id);
        if (root == null) {
            return;
        }
        RevisionVector head = this.getHeadRevision();
        SortedMap<Revision, String> map = root.getLocalMap("_collisions");
        UpdateOp op = new UpdateOp(id, false);
        for (Revision r : map.keySet()) {
            if (r.getClusterId() != this.clusterId || this.branches.getBranchCommit(r) != null || head.isRevisionNewer(r)) continue;
            NodeDocument.removeCollision(op, r);
        }
        if (op.hasChanges()) {
            LOG.debug("Removing collisions {}", (Object)op.getChanges().keySet());
            this.store.findAndUpdate(Collection.NODES, op);
        }
    }

    private void backgroundSplit() {
        RevisionVector head = this.getHeadRevision();
        Iterator<String> it = this.splitCandidates.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            NodeDocument doc = this.store.find(Collection.NODES, id);
            if (doc == null) continue;
            for (UpdateOp op : doc.split(this, head, this.isBinary)) {
                NodeDocument before = null;
                if (!op.isNew() || !this.store.create(Collection.NODES, Collections.singletonList(op))) {
                    before = this.store.createOrUpdate(Collection.NODES, op);
                }
                if (before != null) {
                    NodeDocument after;
                    if (!LOG.isDebugEnabled() || (after = this.store.find(Collection.NODES, op.getId())) == null) continue;
                    LOG.debug("Split operation on {}. Size before: {}, after: {}", id, before.getMemory(), after.getMemory());
                    continue;
                }
                LOG.debug("Split operation created {}", (Object)op.getId());
            }
            it.remove();
        }
    }

    @Nonnull
    Set<String> getSplitCandidates() {
        return Collections.unmodifiableSet(this.splitCandidates.keySet());
    }

    BackgroundWriteStats backgroundWrite() {
        return this.unsavedLastRevisions.persist(this, new UnsavedModifications.Snapshot(){

            @Override
            public void acquiring(Revision mostRecent) {
                if (DocumentNodeStore.this.store.create(Collection.JOURNAL, Collections.singletonList(DocumentNodeStore.this.changes.asUpdateOp(mostRecent)))) {
                    DocumentNodeStore.this.changes = DocumentNodeStore.this.newJournalEntry();
                } else {
                    LOG.error("Failed to write to journal, accumulating changes for future write (~" + DocumentNodeStore.this.changes.getMemory() + " bytes).");
                }
            }
        }, this.backgroundOperationLock.writeLock());
    }

    private JournalEntry newJournalEntry() {
        return new JournalEntry(this.store, true);
    }

    private void initializeRootState(NodeDocument rootDoc) {
        Preconditions.checkState(this.root == null);
        this.alignWithExternalRevisions(rootDoc);
        RevisionVector headRevision = new RevisionVector(rootDoc.getLastRev().values()).update(this.newRevision());
        this.setRoot(headRevision);
    }

    private void alignWithExternalRevisions(@Nonnull NodeDocument rootDoc) {
        Map<Integer, Revision> lastRevMap = Preconditions.checkNotNull(rootDoc).getLastRev();
        try {
            long externalTime = Utils.getMaxExternalTimestamp(lastRevMap.values(), this.clusterId);
            long localTime = this.clock.getTime();
            if (localTime < externalTime) {
                LOG.warn("Detected clock differences. Local time is '{}', while most recent external time is '{}'. Current _lastRev entries: {}", new Date(localTime), new Date(externalTime), lastRevMap.values());
                double delay = ((double)externalTime - (double)localTime) / 1000.0;
                String msg = String.format("Background read will be delayed by %.1f seconds. Please check system time on cluster nodes.", delay);
                LOG.warn(msg);
                this.clock.waitUntil(externalTime + 1L);
            } else if (localTime == externalTime) {
                LOG.debug("Local and external time are equal. Waiting until localtime is more recent than external reported time.");
                this.clock.waitUntil(externalTime + 1L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Background read interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Commit newTrunkCommit(@Nonnull RevisionVector base) {
        Commit c;
        Preconditions.checkArgument(!Preconditions.checkNotNull(base).isBranch(), "base must not be a branch revision: " + base);
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            this.checkOpen();
            c = new Commit(this, this.commitQueue.createRevision(), base);
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    @Nonnull
    private Commit newBranchCommit(@Nonnull RevisionVector base, @Nullable DocumentNodeStoreBranch branch) {
        Preconditions.checkArgument(Preconditions.checkNotNull(base).isBranch(), "base must be a branch revision: " + base);
        this.checkOpen();
        Commit c = new Commit(this, this.newRevision(), base);
        if (!this.isDisableBranches()) {
            Revision rev = c.getRevision().asBranchRevision();
            Branch b = this.getBranches().getBranch(base);
            if (b == null) {
                this.getBranches().create(base.asTrunkRevision(), rev, branch);
                LOG.debug("Branch created with base revision {}", (Object)base);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Branch created", new Exception());
                }
            } else {
                b.addCommit(rev);
            }
        }
        return c;
    }

    private void checkOpen() throws IllegalStateException {
        if (this.isDisposed.get()) {
            throw new IllegalStateException("This DocumentNodeStore is disposed");
        }
    }

    private boolean checkNodeNotExistsFromChildrenCache(String path, RevisionVector rev) {
        if (PathUtils.denotesRoot(path)) {
            return false;
        }
        String parentPath = PathUtils.getParentPath(path);
        PathRev key = DocumentNodeStore.childNodeCacheKey(parentPath, rev, null);
        DocumentNodeState.Children children = this.nodeChildrenCache.getIfPresent(key);
        String lookupChildName = PathUtils.getName(path);
        if (children == null) {
            return false;
        }
        if (children.hasMore) {
            return false;
        }
        int childPosition = Collections.binarySearch(children.children, lookupChildName);
        if (childPosition < 0) {
            LOG.trace("Child node as per path {} does not exist at revision {}", (Object)path, (Object)rev);
            return true;
        }
        return false;
    }

    private String diffImpl(AbstractDocumentNodeState from, AbstractDocumentNodeState to) throws DocumentStoreException {
        String diff;
        String diffAlgo;
        long start;
        int max = DocumentMK.MANY_CHILDREN_THRESHOLD;
        boolean debug = LOG.isDebugEnabled();
        long getChildrenDoneIn = start = debug ? DocumentNodeStore.now() : 0L;
        RevisionVector fromRev = from.getLastRevision();
        RevisionVector toRev = to.getLastRevision();
        long minTimestamp = Utils.getMinTimestampForDiff(fromRev, toRev, this.getMinExternalRevisions());
        Revision tailRev = this.journalGarbageCollector.getTailRevision();
        if (!this.disableJournalDiff && tailRev.getTimestamp() < minTimestamp) {
            diffAlgo = "diffJournalChildren";
            diff = new JournalDiffLoader(from, to, this).call();
        } else {
            DocumentNodeState.Children fromChildren = this.getChildren(from, null, max);
            DocumentNodeState.Children toChildren = this.getChildren(to, null, max);
            getChildrenDoneIn = debug ? DocumentNodeStore.now() : 0L;
            JsopStream w = new JsopStream();
            if (!fromChildren.hasMore && !toChildren.hasMore) {
                diffAlgo = "diffFewChildren";
                this.diffFewChildren(w, from.getPath(), fromChildren, fromRev, toChildren, toRev);
            } else if (DocumentMK.FAST_DIFF) {
                diffAlgo = "diffManyChildren";
                fromRev = from.getRootRevision();
                toRev = to.getRootRevision();
                this.diffManyChildren(w, from.getPath(), fromRev, toRev);
            } else {
                diffAlgo = "diffAllChildren";
                max = Integer.MAX_VALUE;
                fromChildren = this.getChildren(from, null, max);
                toChildren = this.getChildren(to, null, max);
                this.diffFewChildren(w, from.getPath(), fromChildren, fromRev, toChildren, toRev);
            }
            diff = ((Object)w).toString();
        }
        if (debug) {
            long end = DocumentNodeStore.now();
            LOG.debug("Diff performed via '{}' at [{}] between revisions [{}] => [{}] took {} ms ({} ms), diff '{}', external '{}", diffAlgo, from.getPath(), fromRev, toRev, end - start, getChildrenDoneIn - start, diff, to.isFromExternalChange());
        }
        return diff;
    }

    private void diffManyChildren(JsopWriter w, String path, RevisionVector fromRev, RevisionVector toRev) {
        long minTimestamp = Utils.getMinTimestampForDiff(fromRev, toRev, this.getMinExternalRevisions());
        long minValue = NodeDocument.getModifiedInSecs(minTimestamp);
        String fromKey = Utils.getKeyLowerLimit(path);
        String toKey = Utils.getKeyUpperLimit(path);
        HashSet<String> paths = Sets.newHashSet();
        LOG.debug("diffManyChildren: path: {}, fromRev: {}, toRev: {}", path, fromRev, toRev);
        for (NodeDocument doc : this.store.query(Collection.NODES, fromKey, toKey, "_modified", minValue, Integer.MAX_VALUE)) {
            paths.add(doc.getPath());
        }
        LOG.debug("diffManyChildren: Affected paths: {}", (Object)paths.size());
        Revision minRev = new Revision(minTimestamp, 0, this.getClusterId());
        DocumentNodeStore.addPathsForDiff(path, paths, this.getPendingModifications().getPaths(minRev));
        for (RevisionVector rv : new RevisionVector[]{fromRev, toRev}) {
            if (!rv.isBranch()) continue;
            Revision r = rv.getBranchRevision();
            Branch b = this.branches.getBranch(rv);
            if (b == null) continue;
            DocumentNodeStore.addPathsForDiff(path, paths, b.getModifiedPathsUntil(r));
        }
        for (String p : paths) {
            DocumentNodeState fromNode = this.getNode(p, fromRev);
            DocumentNodeState toNode = this.getNode(p, toRev);
            String name = PathUtils.getName(p);
            LOG.trace("diffManyChildren: Changed Path {}", (Object)path);
            if (fromNode != null) {
                if (toNode != null) {
                    RevisionVector a = fromNode.getLastRevision();
                    RevisionVector b = toNode.getLastRevision();
                    if (a == null && b == null || a != null && b != null && a.equals(b)) continue;
                    w.tag('^').key(name).object().endObject();
                    continue;
                }
                w.tag('-').value(name);
                continue;
            }
            if (toNode == null) continue;
            w.tag('+').key(name).object().endObject();
        }
    }

    private static void addPathsForDiff(String path, Set<String> paths, Iterable<String> modified) {
        for (String p : modified) {
            String parent;
            if (PathUtils.denotesRoot(p) || !path.equals(parent = PathUtils.getParentPath(p))) continue;
            paths.add(p);
        }
    }

    private void diffFewChildren(JsopWriter w, String parentPath, DocumentNodeState.Children fromChildren, RevisionVector fromRev, DocumentNodeState.Children toChildren, RevisionVector toRev) {
        HashSet<String> childrenSet = Sets.newHashSet(toChildren.children);
        for (String n : fromChildren.children) {
            if (!childrenSet.contains(n)) {
                w.tag('-').value(n);
                continue;
            }
            String path = PathUtils.concat(parentPath, n);
            DocumentNodeState n1 = this.getNode(path, fromRev);
            DocumentNodeState n2 = this.getNode(path, toRev);
            Preconditions.checkNotNull(n1, "Node at [%s] not found for fromRev [%s]", path, fromRev);
            Preconditions.checkNotNull(n2, "Node at [%s] not found for toRev [%s]", path, toRev);
            if (n1.getLastRevision().equals(n2.getLastRevision())) continue;
            w.tag('^').key(n).object().endObject();
        }
        childrenSet = Sets.newHashSet(fromChildren.children);
        for (String n : toChildren.children) {
            if (childrenSet.contains(n)) continue;
            w.tag('+').key(n).object().endObject();
        }
    }

    private static PathRev childNodeCacheKey(@Nonnull String path, @Nonnull RevisionVector readRevision, @Nullable String name) {
        String p = (name == null ? "" : name) + path;
        return new PathRev(p, readRevision);
    }

    private static DocumentRootBuilder asDocumentRootBuilder(NodeBuilder builder) throws IllegalArgumentException {
        if (!(builder instanceof DocumentRootBuilder)) {
            throw new IllegalArgumentException("builder must be a " + DocumentRootBuilder.class.getName());
        }
        return (DocumentRootBuilder)builder;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    @CheckForNull
    public MarkSweepGarbageCollector createBlobGarbageCollector(long blobGcMaxAgeInSecs, String repositoryId) {
        MarkSweepGarbageCollector blobGC = null;
        if (this.blobStore instanceof GarbageCollectableBlobStore) {
            try {
                blobGC = new MarkSweepGarbageCollector(new DocumentBlobReferenceRetriever(this), (GarbageCollectableBlobStore)this.blobStore, this.executor, TimeUnit.SECONDS.toMillis(blobGcMaxAgeInSecs), repositoryId);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while initializing the MarkSweepGarbageCollector", e);
            }
        }
        return blobGC;
    }

    void setClusterStateChangeListener(ClusterStateChangeListener clusterStateChangeListener) {
        this.clusterStateChangeListener = clusterStateChangeListener;
    }

    void signalClusterStateChange() {
        if (this.clusterStateChangeListener != null) {
            this.clusterStateChangeListener.handleClusterStateChange();
        }
    }

    public DocumentNodeStoreMBean getMBean() {
        return this.mbean;
    }

    private DocumentNodeStoreMBean createMBean() {
        try {
            return new MBeanImpl();
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalStateException(e);
        }
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    BlobSerializer getBlobSerializer() {
        return this.blobSerializer;
    }

    public Iterator<ReferencedBlob> getReferencedBlobsIterator() {
        return this.referencedBlobs.iterator();
    }

    public DiffCache getDiffCache() {
        return this.diffCache;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Checkpoints getCheckpoints() {
        return this.checkpoints;
    }

    @Nonnull
    public VersionGarbageCollector getVersionGarbageCollector() {
        return this.versionGarbageCollector;
    }

    @Nonnull
    public JournalGarbageCollector getJournalGarbageCollector() {
        return this.journalGarbageCollector;
    }

    @Nonnull
    public LastRevRecoveryAgent getLastRevRecoveryAgent() {
        return this.lastRevRecoveryAgent;
    }

    @Override
    public String getInstanceId() {
        return String.valueOf(this.getClusterId());
    }

    public DocumentNodeStoreStatsCollector getStatsCollector() {
        return this.nodeStoreStatsCollector;
    }

    public void setNodeStateCache(DocumentNodeStateCache nodeStateCache) {
        this.nodeStateCache = nodeStateCache;
    }

    static class BackgroundLeaseUpdate
    extends NodeStoreTask {
        BackgroundLeaseUpdate(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed, Suppliers.ofInstance(1000));
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.renewClusterIdLease();
            if (nodeStore.updateClusterState()) {
                nodeStore.signalClusterStateChange();
            }
        }
    }

    static class BackgroundReadOperation
    extends NodeStoreTask {
        BackgroundReadOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundReadOperations();
        }
    }

    static class BackgroundOperation
    extends NodeStoreTask {
        BackgroundOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundUpdateOperations();
        }
    }

    static abstract class NodeStoreTask
    implements Runnable {
        final WeakReference<DocumentNodeStore> ref;
        private final AtomicBoolean isDisposed;
        private final Supplier<Integer> delaySupplier;
        private boolean failing;

        NodeStoreTask(DocumentNodeStore nodeStore, AtomicBoolean isDisposed, Supplier<Integer> delay) {
            this.ref = new WeakReference<DocumentNodeStore>(nodeStore);
            this.isDisposed = isDisposed;
            if (delay == null) {
                delay = new Supplier<Integer>(){

                    @Override
                    public Integer get() {
                        DocumentNodeStore ns = (DocumentNodeStore)NodeStoreTask.this.ref.get();
                        return ns != null ? ns.getAsyncDelay() : 0;
                    }
                };
            }
            this.delaySupplier = delay;
        }

        NodeStoreTask(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            this(nodeStore, isDisposed, null);
        }

        protected abstract void execute(@Nonnull DocumentNodeStore var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int delay = this.delaySupplier.get();
            while (delay != 0 && !this.isDisposed.get()) {
                AtomicBoolean atomicBoolean = this.isDisposed;
                synchronized (atomicBoolean) {
                    try {
                        this.isDisposed.wait(delay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                DocumentNodeStore nodeStore = (DocumentNodeStore)this.ref.get();
                if (nodeStore == null) break;
                try {
                    this.execute(nodeStore);
                    if (this.failing) {
                        LOG.info("Background operation {} successful again", (Object)this.getClass().getSimpleName());
                        this.failing = false;
                    }
                }
                catch (Throwable t) {
                    this.failing = true;
                    LOG.warn("Background operation failed: " + t.toString(), t);
                }
                delay = this.delaySupplier.get();
            }
        }
    }

    private class MBeanImpl
    extends AnnotatedStandardMBean
    implements DocumentNodeStoreMBean {
        private final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
        private final TimeZone TZ_UTC;

        protected MBeanImpl() throws NotCompliantMBeanException {
            super(DocumentNodeStoreMBean.class);
            this.ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
            this.TZ_UTC = TimeZone.getTimeZone("UTC");
        }

        @Override
        public String getRevisionComparatorState() {
            return "";
        }

        @Override
        public String getHead() {
            return DocumentNodeStore.this.getRoot().getRootRevision().toString();
        }

        @Override
        public int getClusterId() {
            return DocumentNodeStore.this.clusterId;
        }

        @Override
        public int getUnmergedBranchCount() {
            return DocumentNodeStore.this.branches.size();
        }

        @Override
        public String[] getInactiveClusterNodes() {
            return Iterables.toArray(Iterables.transform(Iterables.filter(DocumentNodeStore.this.clusterNodes.values(), new Predicate<ClusterNodeInfoDocument>(){

                @Override
                public boolean apply(ClusterNodeInfoDocument input) {
                    return !input.isActive();
                }
            }), new Function<ClusterNodeInfoDocument, String>(){

                @Override
                public String apply(ClusterNodeInfoDocument input) {
                    return input.getClusterId() + "=" + input.getCreated();
                }
            }), String.class);
        }

        @Override
        public String[] getActiveClusterNodes() {
            return Iterables.toArray(Iterables.transform(Iterables.filter(DocumentNodeStore.this.clusterNodes.values(), new Predicate<ClusterNodeInfoDocument>(){

                @Override
                public boolean apply(ClusterNodeInfoDocument input) {
                    return input.isActive();
                }
            }), new Function<ClusterNodeInfoDocument, String>(){

                @Override
                public String apply(ClusterNodeInfoDocument input) {
                    return input.getClusterId() + "=" + input.getLeaseEndTime();
                }
            }), String.class);
        }

        @Override
        public String[] getLastKnownRevisions() {
            return Iterables.toArray(Iterables.transform(Iterables.filter(DocumentNodeStore.this.getHeadRevision(), new Predicate<Revision>(){

                @Override
                public boolean apply(Revision input) {
                    return input.getClusterId() != MBeanImpl.this.getClusterId();
                }
            }), new Function<Revision, String>(){

                @Override
                public String apply(Revision input) {
                    return input.getClusterId() + "=" + input.toString();
                }
            }), String.class);
        }

        @Override
        public String formatRevision(String rev, boolean utc) {
            Revision r = Revision.fromString(rev);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            if (utc) {
                sdf.setTimeZone(this.TZ_UTC);
            }
            return sdf.format(r.getTimestamp());
        }

        @Override
        public long determineServerTimeDifferenceMillis() {
            return DocumentNodeStore.this.store.determineServerTimeDifferenceMillis();
        }

        @Override
        public CompositeData getMergeSuccessHistory() {
            return this.getTimeSeriesData("DOCUMENT_NS_MERGE_SUCCESS_COUNT", "Merge Success Count");
        }

        @Override
        public CompositeData getMergeFailureHistory() {
            return this.getTimeSeriesData("DOCUMENT_NS_MERGE_FAILED_EXCLUSIVE", "Merge failure count");
        }

        @Override
        public CompositeData getExternalChangeCountHistory() {
            return this.getTimeSeriesData("DOCUMENT_NS_BGR_NUM_CHANGES_RATE", "Count of nodes modified by other cluster nodes since last background read");
        }

        @Override
        public CompositeData getBackgroundUpdateCountHistory() {
            return this.getTimeSeriesData("DOCUMENT_NS_BGW_NUM_WRITE_RATE", "Count of nodes updated as part of background update");
        }

        private CompositeData getTimeSeriesData(String name, String desc) {
            return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(name), desc);
        }

        private TimeSeries getTimeSeries(String name) {
            return DocumentNodeStore.this.statisticsProvider.getStats().getTimeSeries(name, true);
        }
    }
}

