/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.util.AbstractCheckpointMBean;

public class DocumentCheckpointMBean
extends AbstractCheckpointMBean {
    private final DocumentNodeStore store;

    public DocumentCheckpointMBean(DocumentNodeStore store) {
        this.store = store;
    }

    @Override
    protected void collectCheckpoints(TabularDataSupport tab) throws OpenDataException {
        SortedMap<Revision, Checkpoints.Info> checkpoints = this.store.getCheckpoints().getCheckpoints();
        for (Map.Entry checkpoint : checkpoints.entrySet()) {
            String id = ((Revision)checkpoint.getKey()).toString();
            Checkpoints.Info info = (Checkpoints.Info)checkpoint.getValue();
            Date created = new Date(((Revision)checkpoint.getKey()).getTimestamp());
            Date expires = new Date(info.getExpiryTime());
            tab.put(id, this.toCompositeData(id, created.toString(), expires.toString(), info.get()));
        }
    }

    @Override
    public String createCheckpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }

    @Override
    public boolean releaseCheckpoint(String checkpoint) {
        return this.store.release(checkpoint);
    }
}

