/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;

class Branch {
    private final ConcurrentSkipListMap<Revision, BranchCommit> commits;
    private final RevisionVector base;
    private final BranchReference ref;

    Branch(@Nonnull SortedSet<Revision> commits, @Nonnull RevisionVector base, @Nonnull ReferenceQueue<Object> queue, @Nullable Object guard) {
        Preconditions.checkArgument(!Preconditions.checkNotNull(base).isBranch(), "base is not a trunk revision: %s", base);
        this.base = base;
        this.commits = new ConcurrentSkipListMap(commits.comparator());
        for (Revision r : commits) {
            this.commits.put(r.asBranchRevision(), new BranchCommitImpl(base, r.asBranchRevision()));
        }
        this.ref = guard != null ? new BranchReference(queue, this, guard) : null;
    }

    @Nonnull
    RevisionVector getBase() {
        return this.base;
    }

    @Nonnull
    RevisionVector getBase(@Nonnull Revision r) {
        BranchCommit c = this.commits.get(Preconditions.checkNotNull(r).asBranchRevision());
        if (c == null) {
            throw new IllegalArgumentException("Revision " + r + " is not a commit in this branch");
        }
        return c.getBase();
    }

    void rebase(@Nonnull Revision head, @Nonnull RevisionVector base) {
        Preconditions.checkArgument(Preconditions.checkNotNull(head).isBranch(), "Not a branch revision: %s", head);
        Preconditions.checkArgument(!Preconditions.checkNotNull(base).isBranch(), "Not a trunk revision: %s", base);
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument(head.compareRevisionTime(last) > 0);
        this.commits.put(head, new RebaseCommit(base, head, this.commits));
    }

    void addCommit(@Nonnull Revision r) {
        Preconditions.checkArgument(Preconditions.checkNotNull(r).isBranch(), "Not a branch revision: %s", r);
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument(this.commits.comparator().compare(r, last) > 0);
        this.commits.put(r, new BranchCommitImpl(this.commits.get(last).getBase(), r));
    }

    SortedSet<Revision> getCommits() {
        return this.commits.keySet();
    }

    boolean hasCommits() {
        return !this.commits.isEmpty();
    }

    boolean containsCommit(@Nonnull Revision r) {
        return this.commits.containsKey(Preconditions.checkNotNull(r).asBranchRevision());
    }

    @CheckForNull
    BranchCommit getCommit(@Nonnull Revision r) {
        return this.commits.get(Preconditions.checkNotNull(r).asBranchRevision());
    }

    @CheckForNull
    BranchReference getRef() {
        return this.ref;
    }

    public void removeCommit(@Nonnull Revision r) {
        Preconditions.checkArgument(Preconditions.checkNotNull(r).isBranch(), "Not a branch revision: %s", r);
        this.commits.remove(r);
    }

    public void applyTo(@Nonnull UnsavedModifications trunk, @Nonnull Revision mergeCommit) {
        Preconditions.checkNotNull(trunk);
        for (BranchCommit c : this.commits.values()) {
            c.applyTo(trunk, mergeCommit);
        }
    }

    @CheckForNull
    public Revision getUnsavedLastRevision(String path, Revision readRevision) {
        readRevision = readRevision.asBranchRevision();
        for (Revision r : this.commits.descendingKeySet()) {
            BranchCommit c;
            if (readRevision.compareRevisionTime(r) < 0 || !(c = this.commits.get(r)).isModified(path)) continue;
            return r;
        }
        return null;
    }

    public boolean isHead(@Nonnull Revision rev) {
        Preconditions.checkArgument(Preconditions.checkNotNull(rev).isBranch(), "Not a branch revision: %s", rev);
        return Preconditions.checkNotNull(rev).equals(this.commits.lastKey());
    }

    Iterable<String> getModifiedPathsUntil(final @Nonnull Revision r) {
        Preconditions.checkArgument(Preconditions.checkNotNull(r).isBranch(), "Not a branch revision: %s", r);
        if (!this.commits.containsKey(r)) {
            return Collections.emptyList();
        }
        Iterable<Iterable<String>> paths = Iterables.transform(Iterables.filter(this.commits.entrySet(), new Predicate<Map.Entry<Revision, BranchCommit>>(){

            @Override
            public boolean apply(Map.Entry<Revision, BranchCommit> input) {
                return !input.getValue().isRebase() && input.getKey().compareRevisionTime(r) <= 0;
            }
        }), new Function<Map.Entry<Revision, BranchCommit>, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Map.Entry<Revision, BranchCommit> input) {
                return input.getValue().getModifiedPaths();
            }
        });
        return Iterables.concat(paths);
    }

    static final class BranchReference
    extends WeakReference<Object> {
        private final Branch branch;

        private BranchReference(@Nonnull ReferenceQueue<Object> queue, @Nonnull Branch branch, @Nonnull Object referent) {
            super(Preconditions.checkNotNull(referent), queue);
            this.branch = Preconditions.checkNotNull(branch);
        }

        Branch getBranch() {
            return this.branch;
        }
    }

    private static class RebaseCommit
    extends BranchCommit {
        private final NavigableMap<Revision, BranchCommit> previous;

        RebaseCommit(RevisionVector base, Revision commit, NavigableMap<Revision, BranchCommit> previous) {
            super(base, commit);
            this.previous = RebaseCommit.squash(previous);
        }

        @Override
        void applyTo(UnsavedModifications trunk, Revision commit) {
            for (BranchCommit c : this.previous.values()) {
                c.applyTo(trunk, commit);
            }
        }

        @Override
        boolean isModified(String path) {
            for (BranchCommit c : this.previous.values()) {
                if (!c.isModified(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isRebase() {
            return true;
        }

        @Override
        Iterable<String> getModifiedPaths() {
            Iterable<Iterable<String>> paths = Iterables.transform(this.previous.values(), new Function<BranchCommit, Iterable<String>>(){

                @Override
                public Iterable<String> apply(BranchCommit branchCommit) {
                    return branchCommit.getModifiedPaths();
                }
            });
            return Iterables.concat(paths);
        }

        private static NavigableMap<Revision, BranchCommit> squash(NavigableMap<Revision, BranchCommit> previous) {
            TreeMap<Revision, BranchCommit> result = new TreeMap<Revision, BranchCommit>(previous.comparator());
            for (Map.Entry e : previous.entrySet()) {
                if (((BranchCommit)e.getValue()).isRebase()) continue;
                result.put((Revision)e.getKey(), (BranchCommit)e.getValue());
            }
            return result;
        }

        @Override
        public void track(String path) {
            throw new UnsupportedOperationException("RebaseCommit is read-only");
        }

        public String toString() {
            return "R (" + this.previous.size() + ")";
        }
    }

    private static class BranchCommitImpl
    extends BranchCommit {
        private final Set<String> modifications = Sets.newHashSet();

        BranchCommitImpl(RevisionVector base, Revision commit) {
            super(base, commit);
        }

        @Override
        void applyTo(UnsavedModifications trunk, Revision commit) {
            for (String p : this.modifications) {
                trunk.put(p, commit);
            }
        }

        @Override
        boolean isModified(String path) {
            return this.modifications.contains(path);
        }

        @Override
        Iterable<String> getModifiedPaths() {
            return this.modifications;
        }

        @Override
        protected boolean isRebase() {
            return false;
        }

        @Override
        public void track(String path) {
            this.modifications.add(path);
        }

        public String toString() {
            return "B (" + this.modifications.size() + ")";
        }
    }

    static abstract class BranchCommit
    implements LastRevTracker {
        protected final RevisionVector base;
        protected final Revision commit;

        BranchCommit(RevisionVector base, Revision commit) {
            this.base = base;
            this.commit = commit;
        }

        RevisionVector getBase() {
            return this.base;
        }

        abstract void applyTo(UnsavedModifications var1, Revision var2);

        abstract boolean isModified(String var1);

        abstract Iterable<String> getModifiedPaths();

        protected abstract boolean isRebase();
    }
}

