/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collection;
import java.util.SortedMap;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class BlobCollector {
    private final DocumentNodeStore nodeStore;

    public BlobCollector(DocumentNodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    public void collect(NodeDocument doc, Collection<ReferencedBlob> blobs) {
        for (String key : doc.keySet()) {
            if (!Utils.isPropertyName(key)) continue;
            SortedMap<Revision, String> valueMap = doc.getLocalMap(key);
            for (String v : valueMap.values()) {
                if (v == null) continue;
                this.loadValue(v, blobs, doc.getPath());
            }
        }
    }

    private void loadValue(String v, Collection<ReferencedBlob> blobs, String nodeId) {
        JsopTokenizer reader = new JsopTokenizer(v);
        if (reader.matches(91)) {
            PropertyState p = DocumentPropertyState.readArrayProperty("x", this.nodeStore, reader);
            if (p.getType() == Type.BINARIES) {
                for (int i = 0; i < p.count(); ++i) {
                    Blob b = p.getValue(Type.BINARY, i);
                    blobs.add(new ReferencedBlob(b, nodeId));
                }
            }
        } else {
            PropertyState p = DocumentPropertyState.readProperty("x", this.nodeStore, reader);
            if (p.getType() == Type.BINARY) {
                Blob b = p.getValue(Type.BINARY);
                blobs.add(new ReferencedBlob(b, nodeId));
            }
        }
    }
}

