/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentNodeState
extends AbstractNodeState {
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger(AbstractDocumentNodeState.class.getName() + ".perf"));

    public abstract String getPath();

    public abstract RevisionVector getLastRevision();

    public abstract RevisionVector getRootRevision();

    public abstract boolean isFromExternalChange();

    public abstract AbstractDocumentNodeState withRootRevision(@Nonnull RevisionVector var1, boolean var2);

    public abstract boolean hasNoChildren();

    protected abstract NodeStateDiffer getNodeStateDiffer();

    @Override
    public boolean equals(Object that) {
        ModifiedNodeState modified;
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState other = (AbstractDocumentNodeState)that;
            if (!this.getPath().equals(other.getPath())) {
                return false;
            }
            if (this.revisionEquals(other)) {
                return true;
            }
        } else if (that instanceof ModifiedNodeState && (modified = (ModifiedNodeState)that).getBaseState() == this) {
            return EqualsDiff.equals(this, modified);
        }
        if (that instanceof NodeState) {
            return AbstractNodeState.equals(this, (NodeState)that);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (this == base) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState(this, diff);
        }
        if (base instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState mBase = (AbstractDocumentNodeState)base;
            if (this.getPath().equals(mBase.getPath())) {
                boolean bl;
                block8: {
                    if (this.revisionEquals(mBase)) {
                        return true;
                    }
                    long start = perfLogger.start();
                    try {
                        bl = this.getNodeStateDiffer().compare(this, mBase, diff);
                        if (start <= 0L) break block8;
                    }
                    catch (Throwable throwable) {
                        if (start > 0L) {
                            perfLogger.end(start, 1L, "compareAgainstBaseState, path={}, lastRevision={}, base.path={}, base.lastRevision={}", this.getPath(), this.getLastRevision(), mBase.getPath(), mBase.getLastRevision());
                        }
                        throw throwable;
                    }
                    perfLogger.end(start, 1L, "compareAgainstBaseState, path={}, lastRevision={}, base.path={}, base.lastRevision={}", this.getPath(), this.getLastRevision(), mBase.getPath(), mBase.getLastRevision());
                }
                return bl;
            }
        }
        return super.compareAgainstBaseState(base, diff);
    }

    private boolean revisionEquals(AbstractDocumentNodeState other) {
        return this.getLastRevision() != null && this.getLastRevision().equals(other.getLastRevision());
    }
}

