/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

abstract class AbstractDocumentNodeBuilder
extends MemoryNodeBuilder {
    public AbstractDocumentNodeBuilder(@Nonnull NodeState base) {
        super(base);
    }

    protected AbstractDocumentNodeBuilder(MemoryNodeBuilder parent, String name) {
        super(parent, name);
    }

    @Override
    @Nonnull
    public NodeBuilder setChildNode(@Nonnull String name, @Nonnull NodeState state) {
        NodeBuilder builder = super.setChildNode(name, EmptyNodeState.EMPTY_NODE);
        for (PropertyState propertyState : state.getProperties()) {
            builder.setProperty(propertyState);
        }
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            builder.setChildNode(childNodeEntry.getName(), childNodeEntry.getNodeState());
        }
        return builder;
    }

    @Override
    protected abstract DocumentNodeBuilder createChildBuilder(String var1);

    @Override
    @Nonnull
    public DocumentNodeBuilder getChildNode(@Nonnull String name) {
        AbstractNodeState.checkValidName(name);
        return this.createChildBuilder(name);
    }
}

