/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MergingNodeStateDiff
extends DefaultNodeStateDiff {
    private static final Logger LOG = LoggerFactory.getLogger(MergingNodeStateDiff.class);
    private final NodeState parent;
    private final NodeBuilder target;
    private final ConflictHandler conflictHandler;
    private final Map<ConflictType, PropertyConflictHandler> propertyConflictHandlers = ImmutableMap.of(ConflictType.ADD_EXISTING_PROPERTY, new PropertyConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.addExistingProperty(MergingNodeStateDiff.this.target, ours, theirs);
        }

        public String toString() {
            return "PropertyConflictHandler<ADD_EXISTING_PROPERTY>";
        }
    }, ConflictType.CHANGE_DELETED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.changeDeletedProperty(MergingNodeStateDiff.this.target, ours);
        }

        public String toString() {
            return "PropertyConflictHandler<CHANGE_DELETED_PROPERTY>";
        }
    }, ConflictType.CHANGE_CHANGED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.changeChangedProperty(MergingNodeStateDiff.this.target, ours, theirs);
        }

        public String toString() {
            return "PropertyConflictHandler<CHANGE_CHANGED_PROPERTY>";
        }
    }, ConflictType.DELETE_DELETED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.deleteDeletedProperty(MergingNodeStateDiff.this.target, ours);
        }

        public String toString() {
            return "PropertyConflictHandler<DELETE_DELETED_PROPERTY>";
        }
    }, ConflictType.DELETE_CHANGED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.deleteChangedProperty(MergingNodeStateDiff.this.target, theirs);
        }

        public String toString() {
            return "PropertyConflictHandler<DELETE_CHANGED_PROPERTY>";
        }
    });
    private final Map<ConflictType, NodeConflictHandler> nodeConflictHandlers = ImmutableMap.of(ConflictType.ADD_EXISTING_NODE, new NodeConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.addExistingNode(MergingNodeStateDiff.this.target, name, ours, theirs);
        }

        public String toString() {
            return "NodeConflictHandler<ADD_EXISTING_NODE>";
        }
    }, ConflictType.CHANGE_DELETED_NODE, new NodeConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.changeDeletedNode(MergingNodeStateDiff.this.target, name, ours);
        }

        public String toString() {
            return "NodeConflictHandler<CHANGE_DELETED_NODE>";
        }
    }, ConflictType.DELETE_CHANGED_NODE, new NodeConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.deleteChangedNode(MergingNodeStateDiff.this.target, name, theirs);
        }

        public String toString() {
            return "NodeConflictHandler<DELETE_CHANGED_NODE>";
        }
    }, ConflictType.DELETE_DELETED_NODE, new NodeConflictHandler(){

        @Override
        public PartialConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs) {
            return MergingNodeStateDiff.this.conflictHandler.deleteDeletedNode(MergingNodeStateDiff.this.target, name);
        }

        public String toString() {
            return "NodeConflictHandler<DELETE_DELETED_NODE>";
        }
    });

    private MergingNodeStateDiff(NodeState parent, NodeBuilder target, ConflictHandler conflictHandler) {
        this.parent = parent;
        this.target = target;
        this.conflictHandler = conflictHandler;
    }

    static NodeState merge(NodeState fromState, NodeState toState, ConflictHandler conflictHandler) {
        return MergingNodeStateDiff.merge(fromState, toState, toState.builder(), conflictHandler).getNodeState();
    }

    private static NodeBuilder merge(NodeState fromState, NodeState toState, NodeBuilder target, ConflictHandler conflictHandler) {
        toState.compareAgainstBaseState(fromState, new MergingNodeStateDiff(toState, target, conflictHandler));
        return target;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        if (":conflict".equals(name)) {
            for (ChildNodeEntry childNodeEntry : after.getChildNodeEntries()) {
                this.resolveConflict(ConflictType.fromName(childNodeEntry.getName()), childNodeEntry.getNodeState());
            }
            this.target.getChildNode(":conflict").remove();
        }
        return true;
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        MergingNodeStateDiff.merge(before, after, this.target.child(name), this.conflictHandler);
        return true;
    }

    private void resolveConflict(ConflictType conflictType, NodeState conflictInfo) {
        PropertyConflictHandler propertyConflictHandler = this.propertyConflictHandlers.get((Object)conflictType);
        if (propertyConflictHandler != null) {
            for (PropertyState propertyState : conflictInfo.getProperties()) {
                PropertyState propertyState2 = this.parent.getProperty(propertyState.getName());
                PartialConflictHandler.Resolution resolution = propertyConflictHandler.resolve(propertyState, propertyState2);
                this.applyResolution(resolution, conflictType, propertyState);
            }
        } else {
            NodeConflictHandler nodeConflictHandler = this.nodeConflictHandlers.get((Object)conflictType);
            if (nodeConflictHandler != null) {
                for (ChildNodeEntry childNodeEntry : conflictInfo.getChildNodeEntries()) {
                    String name = childNodeEntry.getName();
                    NodeState ours = childNodeEntry.getNodeState();
                    NodeState theirs = this.parent.getChildNode(name);
                    PartialConflictHandler.Resolution resolution = nodeConflictHandler.resolve(name, ours, theirs);
                    this.applyResolution(resolution, conflictType, name, ours);
                    if (!LOG.isDebugEnabled()) continue;
                    String diff = JsopDiff.diffToJsop(ours, theirs);
                    LOG.debug("{} resolved conflict of type {} with resolution {} on node {}, conflict trace {}", new Object[]{nodeConflictHandler, conflictType, resolution, name, diff});
                }
            } else {
                LOG.warn("Ignoring unknown conflict '" + (Object)((Object)conflictType) + '\'');
            }
        }
        NodeBuilder conflictMarker = this.getConflictMarker(conflictType);
        if (conflictMarker != null) assert (conflictMarker.getChildNodeCount(1L) == 0L);
    }

    private void applyResolution(PartialConflictHandler.Resolution resolution, ConflictType conflictType, PropertyState ours) {
        String name = ours.getName();
        NodeBuilder conflictMarker = this.getConflictMarker(conflictType);
        if (resolution == PartialConflictHandler.Resolution.OURS) {
            if (ConflictType.DELETE_CHANGED_PROPERTY == conflictType) {
                this.target.removeProperty(name);
            } else {
                this.target.setProperty(ours);
            }
        }
        conflictMarker.removeProperty(name);
    }

    private void applyResolution(PartialConflictHandler.Resolution resolution, ConflictType conflictType, String name, NodeState ours) {
        NodeBuilder conflictMarker = this.getConflictMarker(conflictType);
        if (resolution == PartialConflictHandler.Resolution.OURS) {
            if (ConflictType.DELETE_CHANGED_NODE == conflictType) {
                MergingNodeStateDiff.removeChild(this.target, name);
            } else {
                MergingNodeStateDiff.addChild(this.target, name, ours);
            }
        }
        conflictMarker.getChildNode(name).remove();
    }

    private NodeBuilder getConflictMarker(ConflictType conflictType) {
        NodeBuilder conflict;
        String conflictName = conflictType.getName();
        if (this.target.hasChildNode(":conflict") && (conflict = this.target.child(":conflict")).hasChildNode(conflictName)) {
            return conflict.child(conflictName);
        }
        return null;
    }

    private static void addChild(NodeBuilder target, String name, NodeState state) {
        target.setChildNode(name, state);
        PropertyState childOrder = target.getProperty(":childOrder");
        if (childOrder != null) {
            PropertyBuilder<String> builder = PropertyBuilder.copy(Type.NAME, childOrder);
            builder.addValue(name);
            target.setProperty(builder.getPropertyState());
        }
    }

    private static void removeChild(NodeBuilder target, String name) {
        target.getChildNode(name).remove();
        PropertyState childOrder = target.getProperty(":childOrder");
        if (childOrder != null) {
            PropertyBuilder<String> builder = PropertyBuilder.copy(Type.NAME, childOrder);
            builder.removeValue(name);
            target.setProperty(builder.getPropertyState());
        }
    }

    private static interface NodeConflictHandler {
        public PartialConflictHandler.Resolution resolve(String var1, NodeState var2, NodeState var3);
    }

    private static interface PropertyConflictHandler {
        public PartialConflictHandler.Resolution resolve(PropertyState var1, PropertyState var2);
    }
}

