/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.apache.jackrabbit.oak.spi.blob.stats.StatsCollectingStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreBlobStore
implements DataStore,
BlobStore,
GarbageCollectableBlobStore,
BlobTrackingStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final DataStore delegate;
    protected BlobStatsCollector stats = BlobStatsCollector.NOOP;
    private BlobTracker tracker;
    private final boolean encodeLengthInId;
    protected final LoadingCache<String, byte[]> cache;
    public static final int DEFAULT_CACHE_SIZE = 16;
    private int maxCachedBinarySize = 0x100000;
    private final Weigher<String, byte[]> weigher = new Weigher<String, byte[]>(){

        @Override
        public int weigh(@Nonnull String key, @Nonnull byte[] value) {
            return StringUtils.estimateMemoryUsage(key) + value.length;
        }
    };
    private final CacheStats cacheStats;
    public static final String MEM_CACHE_NAME = "BlobStore-MemCache";

    public DataStoreBlobStore(DataStore delegate) {
        this(delegate, true, 16);
    }

    public DataStoreBlobStore(DataStore delegate, boolean encodeLengthInId) {
        this(delegate, encodeLengthInId, 16);
    }

    public DataStoreBlobStore(DataStore delegate, boolean encodeLengthInId, int cacheSizeInMB) {
        this.delegate = delegate;
        this.encodeLengthInId = encodeLengthInId;
        long cacheSize = (long)cacheSizeInMB * 0x100000L;
        this.cache = CacheLIRS.newBuilder().module(MEM_CACHE_NAME).recordStats().maximumWeight(cacheSize).weigher(this.weigher).build();
        this.cacheStats = new CacheStats(this.cache, MEM_CACHE_NAME, this.weigher, cacheSize);
    }

    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        if (DataStoreBlobStore.isInMemoryRecord(identifier)) {
            return this.getDataRecord(identifier.toString());
        }
        return this.delegate.getRecordIfStored(identifier);
    }

    @Override
    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        if (DataStoreBlobStore.isInMemoryRecord(identifier)) {
            return this.getDataRecord(identifier.toString());
        }
        return this.delegate.getRecord(identifier);
    }

    @Override
    public DataRecord getRecordFromReference(String reference) throws DataStoreException {
        return this.delegate.getRecordFromReference(reference);
    }

    @Override
    public DataRecord addRecord(InputStream stream) throws DataStoreException {
        try {
            return this.writeStream(stream);
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        this.delegate.updateModifiedDateOnAccess(before);
    }

    @Override
    public int deleteAllOlderThan(long min) throws DataStoreException {
        return this.delegate.deleteAllOlderThan(min);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return this.delegate.getAllIdentifiers();
    }

    @Override
    public void init(String homeDir) throws RepositoryException {
        throw new UnsupportedOperationException("DataStore cannot be initialized again");
    }

    @Override
    public int getMinRecordLength() {
        return this.delegate.getMinRecordLength();
    }

    @Override
    public void close() throws DataStoreException {
        this.delegate.close();
        this.cache.invalidateAll();
        IOUtils.closeQuietly(this.tracker);
    }

    @Override
    public String writeBlob(InputStream stream) throws IOException {
        boolean threw = true;
        try {
            long start = System.nanoTime();
            Preconditions.checkNotNull(stream);
            DataRecord dr = this.writeStream(stream);
            String id = this.getBlobId(dr);
            if (this.tracker != null && !InMemoryDataRecord.isInstance(id)) {
                try {
                    this.tracker.add(id);
                    this.log.trace("Tracked Id {}", (Object)id);
                }
                catch (Exception e) {
                    this.log.warn("Could not add track id", e);
                }
            }
            threw = false;
            this.stats.uploaded(System.nanoTime() - start, TimeUnit.NANOSECONDS, dr.getLength());
            this.stats.uploadCompleted(id);
            String string = id;
            return string;
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
        finally {
            Closeables.close(stream, threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBlob(String encodedBlobId, long pos, byte[] buff, int off, int length) throws IOException {
        InputStream stream = this.getInputStream(encodedBlobId);
        boolean threw = true;
        try {
            ByteStreams.skipFully(stream, pos);
            int readCount = stream.read(buff, off, length);
            threw = false;
            int n = readCount;
            return n;
        }
        finally {
            Closeables.close(stream, threw);
        }
    }

    @Override
    public long getBlobLength(String encodedBlobId) throws IOException {
        try {
            Preconditions.checkNotNull(encodedBlobId, "BlobId must be specified");
            BlobId id = BlobId.of(encodedBlobId);
            if (this.encodeLengthInId && id.hasLengthInfo()) {
                return id.length;
            }
            return this.getDataRecord(id.blobId).getLength();
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getBlobId(@Nonnull String reference) {
        Preconditions.checkNotNull(reference);
        try {
            DataRecord record = this.delegate.getRecordFromReference(reference);
            if (record != null) {
                return this.getBlobId(record);
            }
        }
        catch (DataStoreException e) {
            this.log.warn("Unable to access the blobId for  [{}]", (Object)reference, (Object)e);
        }
        return null;
    }

    @Override
    public String getReference(@Nonnull String encodedBlobId) {
        Preconditions.checkNotNull(encodedBlobId);
        String blobId = this.extractBlobId(encodedBlobId);
        if (InMemoryDataRecord.isInstance(blobId)) {
            return null;
        }
        try {
            DataRecord record = this.delegate.getRecord(new DataIdentifier(blobId));
            if (record != null) {
                return record.getReference();
            }
            this.log.debug("No blob found for id [{}]", (Object)blobId);
        }
        catch (DataStoreException e) {
            this.log.warn("Unable to access the blobId for  [{}]", (Object)blobId, (Object)e);
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String encodedBlobId) throws IOException {
        final BlobId blobId = BlobId.of(encodedBlobId);
        if (this.encodeLengthInId && blobId.hasLengthInfo() && blobId.length <= (long)this.maxCachedBinarySize) {
            try {
                byte[] content = this.cache.get(blobId.blobId, new Callable<byte[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public byte[] call() throws Exception {
                        boolean threw = true;
                        InputStream stream = DataStoreBlobStore.this.getStream(blobId.blobId);
                        try {
                            byte[] result = IOUtils.toByteArray(stream);
                            threw = false;
                            byte[] byArray = result;
                            return byArray;
                        }
                        finally {
                            Closeables.close(stream, threw);
                        }
                    }
                });
                return new ByteArrayInputStream(content);
            }
            catch (ExecutionException e) {
                this.log.warn("Error occurred while loading bytes from steam while fetching for id {}", (Object)encodedBlobId, (Object)e);
            }
        }
        return this.getStream(blobId.blobId);
    }

    @Override
    public void setBlockSize(int x) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeBlob(String tempFileName) throws IOException {
        String string;
        File file = new File(tempFileName);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = this.writeBlob(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            FileUtils.forceDelete(file);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        FileUtils.forceDelete(file);
        return string;
    }

    @Override
    public int sweep() throws IOException {
        return 0;
    }

    @Override
    public void startMark() throws IOException {
    }

    @Override
    public void clearInUse() {
        this.delegate.clearInUse();
    }

    @Override
    public void clearCache() {
    }

    @Override
    public long getBlockSizeMin() {
        return 0L;
    }

    @Override
    public Iterator<String> getAllChunkIds(final long maxLastModifiedTime) throws Exception {
        return Iterators.transform(Iterators.filter(this.getAllRecords(), new Predicate<DataRecord>(){

            @Override
            public boolean apply(@Nullable DataRecord input) {
                return input != null && (maxLastModifiedTime <= 0L || input.getLastModified() < maxLastModifiedTime);
            }
        }), new Function<DataRecord, String>(){

            @Override
            public String apply(DataRecord input) {
                if (DataStoreBlobStore.this.encodeLengthInId) {
                    return BlobId.of(input).encodedValue();
                }
                return input.getIdentifier().toString();
            }
        });
    }

    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        return (long)chunkIds.size() == this.countDeleteChunks(chunkIds, maxLastModifiedTime);
    }

    @Override
    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        int count = 0;
        if (this.delegate instanceof MultiDataStoreAware) {
            for (String chunkId : chunkIds) {
                String blobId = this.extractBlobId(chunkId);
                DataIdentifier identifier = new DataIdentifier(blobId);
                DataRecord dataRecord = this.getRecordForId(identifier);
                boolean success = maxLastModifiedTime <= 0L || dataRecord.getLastModified() <= maxLastModifiedTime;
                this.log.trace("Deleting blob [{}] with last modified date [{}] : [{}]", blobId, dataRecord.getLastModified(), success);
                if (!success) continue;
                ((MultiDataStoreAware)((Object)this.delegate)).deleteRecord(identifier);
                this.log.info("Deleted blob [{}]", (Object)blobId);
                ++count;
            }
        }
        return count;
    }

    @Override
    public Iterator<String> resolveChunks(String blobId) throws IOException {
        if (!InMemoryDataRecord.isInstance(blobId)) {
            return Iterators.singletonIterator(blobId);
        }
        return Iterators.emptyIterator();
    }

    @Override
    public void addMetadataRecord(InputStream stream, String name) throws DataStoreException {
        if (this.delegate instanceof SharedDataStore) {
            ((SharedDataStore)((Object)this.delegate)).addMetadataRecord(stream, name);
        }
    }

    @Override
    public void addMetadataRecord(File f, String name) throws DataStoreException {
        if (this.delegate instanceof SharedDataStore) {
            ((SharedDataStore)((Object)this.delegate)).addMetadataRecord(f, name);
        }
    }

    @Override
    public DataRecord getMetadataRecord(String name) {
        if (this.delegate instanceof SharedDataStore) {
            return ((SharedDataStore)((Object)this.delegate)).getMetadataRecord(name);
        }
        return null;
    }

    @Override
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        if (this.delegate instanceof SharedDataStore) {
            return ((SharedDataStore)((Object)this.delegate)).getAllMetadataRecords(prefix);
        }
        return null;
    }

    @Override
    public boolean deleteMetadataRecord(String name) {
        return this.delegate instanceof SharedDataStore && ((SharedDataStore)((Object)this.delegate)).deleteMetadataRecord(name);
    }

    @Override
    public void deleteAllMetadataRecords(String prefix) {
        if (this.delegate instanceof SharedDataStore) {
            ((SharedDataStore)((Object)this.delegate)).deleteAllMetadataRecords(prefix);
        }
    }

    @Override
    public Iterator<DataRecord> getAllRecords() throws DataStoreException {
        if (this.delegate instanceof SharedDataStore) {
            return ((SharedDataStore)((Object)this.delegate)).getAllRecords();
        }
        return Iterators.transform(this.delegate.getAllIdentifiers(), new Function<DataIdentifier, DataRecord>(){

            @Override
            @Nullable
            public DataRecord apply(@Nullable DataIdentifier input) {
                try {
                    return DataStoreBlobStore.this.delegate.getRecord(input);
                }
                catch (DataStoreException e) {
                    DataStoreBlobStore.this.log.warn("Error occurred while fetching DataRecord for identifier {}", (Object)input, (Object)e);
                    return null;
                }
            }
        });
    }

    @Override
    public DataRecord getRecordForId(DataIdentifier identifier) throws DataStoreException {
        if (this.delegate instanceof SharedDataStore) {
            return ((SharedDataStore)((Object)this.delegate)).getRecordForId(identifier);
        }
        return this.delegate.getRecord(identifier);
    }

    @Override
    public SharedDataStore.Type getType() {
        if (this.delegate instanceof SharedDataStore) {
            return SharedDataStore.Type.SHARED;
        }
        return SharedDataStore.Type.DEFAULT;
    }

    public String toString() {
        return String.format("DataStore backed BlobStore [%s]", this.delegate.getClass().getName());
    }

    public DataStore getDataStore() {
        return this.delegate;
    }

    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    public void setMaxCachedBinarySize(int maxCachedBinarySize) {
        this.maxCachedBinarySize = maxCachedBinarySize;
    }

    public void setBlobStatsCollector(BlobStatsCollector stats) {
        this.stats = stats;
    }

    @Override
    public void addTracker(BlobTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    @Nullable
    public BlobTracker getTracker() {
        return this.tracker;
    }

    protected InputStream getStream(String blobId) throws IOException {
        try {
            InputStream in = this.getDataRecord(blobId).getStream();
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            return StatsCollectingStreams.wrap(this.stats, blobId, in);
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
    }

    protected DataRecord getDataRecord(String blobId) throws DataStoreException {
        DataRecord id = InMemoryDataRecord.isInstance(blobId) ? InMemoryDataRecord.getInstance(blobId) : this.delegate.getRecord(new DataIdentifier(blobId));
        Preconditions.checkNotNull(id, "No DataRecord found for blobId [%s]", blobId);
        return id;
    }

    private static boolean isInMemoryRecord(DataIdentifier identifier) {
        return InMemoryDataRecord.isInstance(identifier.toString());
    }

    private DataRecord writeStream(InputStream in) throws IOException, DataStoreException {
        DataRecord record;
        int l;
        int maxMemorySize = Math.max(0, this.delegate.getMinRecordLength() + 1);
        byte[] buffer = new byte[maxMemorySize];
        int pos = 0;
        int len = maxMemorySize;
        while (pos < maxMemorySize && (l = in.read(buffer, pos, len)) >= 0) {
            pos += l;
            len -= l;
        }
        if (pos < maxMemorySize) {
            byte[] data = new byte[pos];
            System.arraycopy(buffer, 0, data, 0, pos);
            record = InMemoryDataRecord.getInstance(data);
        } else {
            in = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, pos), in);
            record = this.delegate.addRecord(in);
        }
        return record;
    }

    private String getBlobId(DataRecord dr) {
        if (this.encodeLengthInId) {
            return BlobId.of(dr).encodedValue();
        }
        return dr.getIdentifier().toString();
    }

    protected String extractBlobId(String encodedBlobId) {
        if (this.encodeLengthInId) {
            return BlobId.of((String)encodedBlobId).blobId;
        }
        return encodedBlobId;
    }

    public static class BlobId {
        static final String SEP = "#";
        final String blobId;
        final long length;

        public String getBlobId() {
            return this.blobId;
        }

        BlobId(String blobId, long length) {
            this.blobId = blobId;
            this.length = length;
        }

        BlobId(DataRecord dr) {
            long len;
            this.blobId = dr.getIdentifier().toString();
            try {
                len = dr.getLength();
            }
            catch (DataStoreException e) {
                len = -1L;
            }
            this.length = len;
        }

        BlobId(String encodedBlobId) {
            int indexOfSep = encodedBlobId.lastIndexOf(SEP);
            if (indexOfSep != -1) {
                this.blobId = encodedBlobId.substring(0, indexOfSep);
                this.length = Long.valueOf(encodedBlobId.substring(indexOfSep + SEP.length()));
            } else {
                this.blobId = encodedBlobId;
                this.length = -1L;
            }
        }

        String encodedValue() {
            if (this.hasLengthInfo()) {
                return this.blobId + SEP + String.valueOf(this.length);
            }
            return this.blobId;
        }

        boolean hasLengthInfo() {
            return this.length != -1L;
        }

        static boolean isEncoded(String encodedBlobId) {
            return encodedBlobId.contains(SEP);
        }

        public static BlobId of(String encodedValue) {
            return new BlobId(encodedValue);
        }

        static BlobId of(DataRecord dr) {
            return new BlobId(dr);
        }
    }
}

