/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class GarbageCollectorFileState
implements Closeable {
    private final File home;
    private final File markedRefs;
    private final File availableRefs;
    private final File gcCandidates;
    private final File garbage;

    public GarbageCollectorFileState(String root) throws IOException {
        long startTime = System.currentTimeMillis();
        this.home = new File(root, "gcworkdir-" + startTime);
        this.markedRefs = new File(this.home, "marked-" + startTime);
        this.availableRefs = new File(this.home, "avail-" + startTime);
        this.gcCandidates = new File(this.home, "gccand-" + startTime);
        this.garbage = new File(this.home, "gc-" + startTime);
        FileUtils.forceMkdir(this.home);
    }

    public File getMarkedRefs() {
        return this.markedRefs;
    }

    public File getAvailableRefs() {
        return this.availableRefs;
    }

    public File getGcCandidates() {
        return this.gcCandidates;
    }

    public File getGarbage() {
        return this.garbage;
    }

    @Override
    public void close() throws IOException {
        if (!this.getGarbage().exists() || FileUtils.sizeOf(this.getGarbage()) == 0L) {
            FileUtils.deleteDirectory(this.home);
        }
    }
}

