/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.cache.Weigher;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;

public abstract class CachingBlobStore
extends AbstractBlobStore {
    protected static final long DEFAULT_CACHE_SIZE = 0x1000000L;
    protected final CacheLIRS<String, byte[]> cache;
    protected final long blobCacheSize;
    private final Weigher<String, byte[]> weigher = new Weigher<String, byte[]>(){

        @Override
        public int weigh(@Nonnull String key, @Nonnull byte[] value) {
            return StringUtils.estimateMemoryUsage(key) + value.length;
        }
    };
    private final CacheStats cacheStats;
    public static final String MEM_CACHE_NAME = "BlobStore-MemCache";

    public CachingBlobStore(long cacheSize) {
        this.blobCacheSize = cacheSize;
        this.cache = CacheLIRS.newBuilder().recordStats().module(MEM_CACHE_NAME).maximumWeight(cacheSize).averageWeight(this.getBlockSize() / 2).weigher(this.weigher).build();
        this.cacheStats = new CacheStats(this.cache, MEM_CACHE_NAME, this.weigher, cacheSize);
    }

    public CachingBlobStore() {
        this(0x1000000L);
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
    }

    public long getBlobCacheSize() {
        return this.blobCacheSize;
    }

    public CacheStats getCacheStats() {
        return this.cacheStats;
    }
}

