/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.core.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public enum ResetCommitAttributeHook implements CommitHook
{
    INSTANCE;


    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        ResetCommitAttributeHook.resetAttributes(info);
        return after;
    }

    private static void resetAttributes(CommitInfo info) {
        SimpleCommitContext attrs = (SimpleCommitContext)info.getInfo().get("oak.commitAttributes");
        Preconditions.checkNotNull(attrs, "No commit attribute instance found in info map").clear();
    }
}

