/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.oak.commons.sort.EscapeUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileIOUtils {
    public static final Comparator<String> lexComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };

    private FileIOUtils() {
    }

    public static void sort(File file) throws IOException {
        File sorted = File.createTempFile("fleioutilssort", null);
        FileIOUtils.merge(ExternalSort.sortInBatch(file, lexComparator, true), sorted);
        Files.move(sorted, file);
    }

    public static void sort(File file, Comparator<String> comparator) throws IOException {
        File sorted = File.createTempFile("fleioutilssort", null);
        FileIOUtils.merge(ExternalSort.sortInBatch(file, comparator, true), sorted);
        Files.move(sorted, file);
    }

    public static void merge(List<File> files, File output) throws IOException {
        ExternalSort.mergeSortedFiles(files, output, lexComparator, true);
    }

    public static File copy(InputStream stream) throws IOException {
        File file = File.createTempFile("fleioutilscopy", null);
        FileUtils.copyInputStreamToFile(stream, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(List<File> files, File appendTo, boolean delete) throws IOException {
        OutputStream appendStream = null;
        boolean threw = true;
        try {
            appendStream = Files.asByteSink(appendTo, FileWriteMode.APPEND).openBufferedStream();
            for (File f : files) {
                FileInputStream iStream = new FileInputStream(f);
                try {
                    IOUtils.copyLarge(iStream, appendStream);
                }
                finally {
                    IOUtils.closeQuietly(iStream);
                }
            }
            if (delete) {
                for (File f : files) {
                    f.delete();
                }
            }
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(appendStream, threw);
            throw throwable;
        }
        Closeables.close(appendStream, threw);
    }

    public static void writeAsLine(BufferedWriter writer, String str, boolean escape) throws IOException {
        if (escape) {
            writer.write(EscapeUtils.escapeLineBreak(str));
        } else {
            writer.write(str);
        }
        writer.newLine();
    }

    public static int writeStrings(Iterator<String> iterator, File f, boolean escape) throws IOException {
        return FileIOUtils.writeStrings(iterator, f, escape, null, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeStrings(Iterator<String> iterator, File f, boolean escape, @Nullable Logger logger, @Nullable String message) throws IOException {
        BufferedWriter writer = Files.newWriter(f, Charsets.UTF_8);
        boolean threw = true;
        int count = 0;
        try {
            while (iterator.hasNext()) {
                FileIOUtils.writeAsLine(writer, iterator.next(), escape);
                if (logger == null || ++count % 1000 != 0) continue;
                logger.info(Strings.nullToEmpty(message) + count);
            }
            threw = false;
        }
        finally {
            Closeables.close(writer, threw);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readStringsAsSet(InputStream stream, boolean unescape) throws IOException {
        BufferedReader reader = null;
        HashSet<String> set = Sets.newHashSet();
        boolean threw = true;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (unescape) {
                    set.add(EscapeUtils.unescapeLineBreaks(line));
                    continue;
                }
                set.add(line);
            }
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(reader, threw);
            throw throwable;
        }
        Closeables.close(reader, threw);
        return set;
    }

    public static Comparator<String> lineBreakAwareComparator(Comparator<String> delegate) {
        return new TransformingComparator(delegate, new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String input) {
                return EscapeUtils.unescapeLineBreaks(input);
            }
        });
    }

    public static class BurnOnCloseFileIterator<T>
    extends AbstractIterator<T>
    implements Closeable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final LineIterator iterator;
        private final Function<String, T> transformer;
        private File backingFile;

        public BurnOnCloseFileIterator(LineIterator iterator, Function<String, T> transformer) {
            this.iterator = iterator;
            this.transformer = transformer;
        }

        public BurnOnCloseFileIterator(LineIterator iterator, File backingFile, Function<String, T> transformer) {
            this.iterator = iterator;
            this.transformer = transformer;
            this.backingFile = backingFile;
        }

        @Override
        protected T computeNext() {
            if (this.iterator.hasNext()) {
                return this.transformer.apply(this.iterator.next());
            }
            try {
                this.close();
            }
            catch (IOException e) {
                this.log.warn("Error closing iterator", e);
            }
            return this.endOfData();
        }

        @Override
        public void close() throws IOException {
            LineIterator.closeQuietly(this.iterator);
            if (this.backingFile != null && this.backingFile.exists()) {
                FileUtils.forceDelete(this.backingFile);
            }
        }

        public static BurnOnCloseFileIterator<String> wrap(LineIterator iter) {
            return new BurnOnCloseFileIterator<String>(iter, new Function<String, String>(){

                @Override
                public String apply(String s) {
                    return s;
                }
            });
        }

        public static BurnOnCloseFileIterator<String> wrap(LineIterator iter, File backingFile) {
            return new BurnOnCloseFileIterator<String>(iter, backingFile, new Function<String, String>(){

                @Override
                public String apply(String s) {
                    return s;
                }
            });
        }
    }

    public static class FileLineDifferenceIterator
    extends AbstractIterator<String>
    implements Closeable {
        private final PeekingIterator<String> peekMarked;
        private final LineIterator marked;
        private final LineIterator all;
        private Function<String, String> transformer = new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input;
            }
        };

        public FileLineDifferenceIterator(LineIterator marked, LineIterator available) throws IOException {
            this(marked, available, null);
        }

        public FileLineDifferenceIterator(File marked, File available, @Nullable Function<String, String> transformer) throws IOException {
            this(FileUtils.lineIterator(marked, Charsets.UTF_8.toString()), FileUtils.lineIterator(available, Charsets.UTF_8.toString()), transformer);
        }

        public FileLineDifferenceIterator(LineIterator marked, LineIterator available, @Nullable Function<String, String> transformer) throws IOException {
            this.marked = marked;
            this.peekMarked = Iterators.peekingIterator(marked);
            this.all = available;
            if (transformer != null) {
                this.transformer = transformer;
            }
        }

        @Override
        protected String computeNext() {
            String diff = this.computeNextDiff();
            if (diff == null) {
                this.close();
                return (String)this.endOfData();
            }
            return diff;
        }

        @Override
        public void close() {
            LineIterator.closeQuietly(this.marked);
            LineIterator.closeQuietly(this.all);
        }

        private String computeNextDiff() {
            if (!this.all.hasNext()) {
                return null;
            }
            if (!this.peekMarked.hasNext()) {
                return this.all.next();
            }
            String diff = null;
            block0: while (this.all.hasNext() && diff == null) {
                diff = this.all.next();
                while (this.peekMarked.hasNext()) {
                    String marked = this.peekMarked.peek();
                    int comparisonResult = this.transformer.apply(diff).compareTo(this.transformer.apply(marked));
                    if (comparisonResult > 0) {
                        this.peekMarked.next();
                        continue;
                    }
                    if (comparisonResult == 0) {
                        this.peekMarked.next();
                        diff = null;
                        continue block0;
                    }
                    return diff;
                }
            }
            return diff;
        }
    }

    public static class TransformingComparator
    implements Comparator<String> {
        private Comparator delegate;
        private Function<String, String> func;

        public TransformingComparator(Comparator delegate, Function<String, String> func) {
            this.delegate = delegate;
            this.func = func;
        }

        @Override
        public int compare(String s1, String s2) {
            return this.delegate.compare(this.func.apply(s1), this.func.apply(s2));
        }
    }
}

