/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.ConsolidatedCacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.PersistentCacheStatsMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;

@Component
public class ConsolidatedCacheStats
implements ConsolidatedCacheStatsMBean {
    private Tracker<CacheStatsMBean> cacheStats;
    private Tracker<PersistentCacheStatsMBean> persistentCacheStats;
    private Registration mbeanReg;

    @Override
    public TabularData getCacheStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(CacheStatsData.class.getName(), "Consolidated Cache Stats", CacheStatsData.TYPE, new String[]{"name"});
            tds = new TabularDataSupport(tt);
            for (CacheStatsMBean cacheStatsMBean : this.cacheStats.getServices()) {
                tds.put(new CacheStatsData(cacheStatsMBean).toCompositeData());
            }
            for (CacheStatsMBean cacheStatsMBean : this.persistentCacheStats.getServices()) {
                tds.put(new CacheStatsData(cacheStatsMBean).toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Activate
    private void activate(BundleContext context) {
        OsgiWhiteboard wb = new OsgiWhiteboard(context);
        this.cacheStats = wb.track(CacheStatsMBean.class);
        this.persistentCacheStats = wb.track(PersistentCacheStatsMBean.class);
        this.mbeanReg = WhiteboardUtils.registerMBean(wb, ConsolidatedCacheStatsMBean.class, this, "ConsolidatedCacheStats", "Consolidated Cache statistics");
    }

    @Deactivate
    private void deactivate() {
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
        }
        if (this.cacheStats != null) {
            this.cacheStats.stop();
        }
        if (this.persistentCacheStats != null) {
            this.persistentCacheStats.stop();
        }
    }

    private static class CacheStatsData {
        static final String[] FIELD_NAMES = new String[]{"name", "requestCount", "hitCount", "hitRate", "missCount", "missRate", "loadCount", "loadSuccessCount", "loadExceptionCount", "totalLoadTime", "averageLoadPenalty", "evictionCount", "elementCount", "totalWeight", "maxWeight"};
        static final String[] FIELD_DESCRIPTIONS = FIELD_NAMES;
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.BIGDECIMAL, SimpleType.LONG, SimpleType.BIGDECIMAL, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = CacheStatsData.createCompositeType();
        private final CacheStatsMBean stats;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(CacheStatsData.class.getName(), "Composite data type for Cache statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public CacheStatsData(CacheStatsMBean stats) {
            this.stats = stats;
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.stats.getName(), this.stats.getRequestCount(), this.stats.getHitCount(), new BigDecimal(this.stats.getHitRate(), new MathContext(2)), this.stats.getMissCount(), new BigDecimal(this.stats.getMissRate(), new MathContext(2)), this.stats.getLoadCount(), this.stats.getLoadSuccessCount(), this.stats.getLoadExceptionCount(), CacheStats.timeInWords(this.stats.getTotalLoadTime()), TimeUnit.NANOSECONDS.toMillis((long)this.stats.getAverageLoadPenalty()) + "ms", this.stats.getEvictionCount(), this.stats.getElementCount(), IOUtils.humanReadableByteCount(this.stats.estimateCurrentWeight()), IOUtils.humanReadableByteCount(this.stats.getMaxTotalWeight())};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

