/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.backup.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.backup.FileStoreRestore;
import org.apache.jackrabbit.oak.backup.impl.FileStoreBackupImpl;
import org.apache.jackrabbit.oak.backup.impl.FileStoreRestoreImpl;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentReader;

public class FileStoreBackupRestoreImpl
implements FileStoreBackupRestoreMBean {
    private static final String BACKUP_OP_NAME = "Backup";
    private static final String RESTORE_OP_NAME = "Restore";
    private final SegmentNodeStore store;
    private final Revisions revisions;
    private final SegmentReader reader;
    private final File file;
    private final Executor executor;
    private ManagementOperation<String> backupOp = ManagementOperation.done("Backup", "");
    private ManagementOperation<String> restoreOp = ManagementOperation.done("Restore", "");
    private final FileStoreBackup fileStoreBackup;
    private final FileStoreRestore fileStoreRestore;

    public FileStoreBackupRestoreImpl(@Nonnull SegmentNodeStore store, @Nonnull Revisions revisions, @Nonnull SegmentReader reader, @Nonnull File file, @Nonnull Executor executor) {
        this.store = Preconditions.checkNotNull(store);
        this.revisions = Preconditions.checkNotNull(revisions);
        this.reader = Preconditions.checkNotNull(reader);
        this.file = Preconditions.checkNotNull(file);
        this.executor = Preconditions.checkNotNull(executor);
        this.fileStoreBackup = new FileStoreBackupImpl();
        this.fileStoreRestore = new FileStoreRestoreImpl();
    }

    @Override
    @Nonnull
    public synchronized CompositeData startBackup() {
        if (this.backupOp.isDone()) {
            this.backupOp = ManagementOperation.newManagementOperation(BACKUP_OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreBackupRestoreImpl.this.fileStoreBackup.backup(FileStoreBackupRestoreImpl.this.reader, FileStoreBackupRestoreImpl.this.revisions, FileStoreBackupRestoreImpl.this.file);
                    return "Backup completed in " + ManagementOperation.Status.formatTime(System.nanoTime() - t0);
                }
            });
            this.executor.execute(this.backupOp);
        }
        return this.getBackupStatus();
    }

    @Override
    @Nonnull
    public synchronized CompositeData getBackupStatus() {
        return this.backupOp.getStatus().toCompositeData();
    }

    @Override
    @Nonnull
    public synchronized CompositeData startRestore() {
        if (this.restoreOp.isDone()) {
            this.restoreOp = ManagementOperation.newManagementOperation(RESTORE_OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreBackupRestoreImpl.this.fileStoreRestore.restore(FileStoreBackupRestoreImpl.this.file);
                    return "Restore completed in " + ManagementOperation.Status.formatTime(System.nanoTime() - t0);
                }
            });
            this.executor.execute(this.restoreOp);
        }
        return this.getRestoreStatus();
    }

    @Override
    @Nonnull
    public synchronized CompositeData getRestoreStatus() {
        return this.restoreOp.getStatus().toCompositeData();
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }
}

