/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.jcr.NoSuchWorkspaceException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.core.ContentRepositoryImpl;
import org.apache.jackrabbit.oak.management.RepositoryManager;
import org.apache.jackrabbit.oak.plugins.atomic.AtomicCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.CompositeIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterMBean;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindex;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.OakInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.DefaultWhiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.util.AggregatingDescriptors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oak {
    private static final Logger LOG = LoggerFactory.getLogger(Oak.class);
    public static final String DEFAULT_WORKSPACE_NAME = "default";
    private final NodeStore store;
    private final List<RepositoryInitializer> initializers = Lists.newArrayList();
    private QueryEngineSettings queryEngineSettings = new QueryEngineSettings();
    private final List<QueryIndexProvider> queryIndexProviders = Lists.newArrayList();
    private final List<IndexEditorProvider> indexEditorProviders = Lists.newArrayList();
    private final List<CommitHook> commitHooks = Lists.newArrayList();
    private final List<Observer> observers = Lists.newArrayList();
    private List<EditorProvider> editorProviders = Lists.newArrayList();
    private SecurityProvider securityProvider;
    private ScheduledExecutorService scheduledExecutor;
    private Executor executor;
    private final Closer closer = Closer.create();
    private ContentRepository contentRepository;
    private Clusterable clusterable;
    private MBeanServer mbeanServer;
    private String defaultWorkspaceName = "default";
    private Whiteboard whiteboard = new DefaultWhiteboard(){

        @Override
        public <T> Registration register(final Class<T> type, T service, Map<?, ?> properties) {
            final Registration registration = super.register(type, service, properties);
            final Closer observerSubscription = Closer.create();
            ScheduledFuture<?> future = null;
            if (type == Runnable.class) {
                Runnable runnable = (Runnable)service;
                Long period = (Long)Oak.getValue(properties, "scheduler.period", Long.class);
                if (period != null) {
                    Boolean concurrent = (Boolean)Oak.getValue(properties, "scheduler.concurrent", Boolean.class, Boolean.FALSE);
                    future = concurrent.booleanValue() ? Oak.this.getScheduledExecutor().scheduleAtFixedRate(runnable, period, period, TimeUnit.SECONDS) : Oak.this.getScheduledExecutor().scheduleWithFixedDelay(runnable, period, period, TimeUnit.SECONDS);
                }
            } else if (type == Observer.class && Oak.this.store instanceof Observable) {
                observerSubscription.register(((Observable)((Object)Oak.this.store)).addObserver((Observer)service));
            }
            ObjectName objectName = null;
            Object name = properties.get("jmx.objectname");
            if (Oak.this.mbeanServer != null && name != null) {
                try {
                    objectName = name instanceof ObjectName ? (ObjectName)name : new ObjectName(String.valueOf(name));
                    if (type.getName().equals(service.getClass().getName().concat("MBean")) || service instanceof StandardMBean) {
                        Oak.this.mbeanServer.registerMBean(service, objectName);
                    } else {
                        Oak.this.mbeanServer.registerMBean(new StandardMBean(service, type), objectName);
                    }
                }
                catch (JMException e) {
                    LOG.warn("Unexpected exception while registering MBean of type [{}] against name [{}]", type, objectName, e);
                }
            }
            final ScheduledFuture<?> f = future;
            final ObjectName on = objectName;
            return new Registration(){

                @Override
                public void unregister() {
                    if (f != null) {
                        f.cancel(false);
                    }
                    if (on != null) {
                        try {
                            Oak.this.mbeanServer.unregisterMBean(on);
                        }
                        catch (JMException e) {
                            LOG.warn("Unexpected exception while unregistering MBean of type {} against name {} ", type, on, e);
                        }
                    }
                    try {
                        observerSubscription.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected IOException while unsubscribing observer", e);
                    }
                    registration.unregister();
                }
            };
        }
    };
    private Map<String, Long> asyncTasks;
    private boolean failOnMissingIndexProvider;

    public static ScheduledExecutorService defaultScheduledExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(32, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                return thread;
            }

            private String createName() {
                return "oak-scheduled-executor-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService defaultExecutorService() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                return thread;
            }

            private String createName() {
                return "oak-executor-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private synchronized ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Oak.defaultScheduledExecutor();
            this.closer.register(new ExecutorCloser(this.scheduledExecutor));
        }
        return this.scheduledExecutor;
    }

    private synchronized Executor getExecutor() {
        if (this.executor == null) {
            ExecutorService executorService = Oak.defaultExecutorService();
            this.executor = executorService;
            this.closer.register(new ExecutorCloser(executorService));
        }
        return this.executor;
    }

    private static <T> T getValue(Map<?, ?> properties, String name, Class<T> type, T def) {
        Object value = properties.get(name);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return def;
    }

    private static <T> T getValue(Map<?, ?> properties, String name, Class<T> type) {
        return Oak.getValue(properties, name, type, null);
    }

    public Oak(NodeStore store) {
        this.store = Preconditions.checkNotNull(store);
    }

    public Oak() {
        this(new MemoryNodeStore());
    }

    @Nonnull
    public Oak with(@Nonnull Clusterable c) {
        this.clusterable = Preconditions.checkNotNull(c);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull String defaultWorkspaceName) {
        this.defaultWorkspaceName = Preconditions.checkNotNull(defaultWorkspaceName);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull RepositoryInitializer initializer) {
        this.initializers.add(Preconditions.checkNotNull(initializer));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull QueryEngineSettings queryEngineSettings) {
        this.queryEngineSettings = queryEngineSettings;
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull QueryIndexProvider provider) {
        this.queryIndexProviders.add(Preconditions.checkNotNull(provider));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull IndexEditorProvider provider) {
        this.indexEditorProviders.add(Preconditions.checkNotNull(provider));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull CommitHook hook) {
        Preconditions.checkNotNull(hook);
        this.withEditorHook();
        this.commitHooks.add(hook);
        return this;
    }

    private void withEditorHook() {
        if (!this.editorProviders.isEmpty()) {
            this.commitHooks.add(new EditorHook(CompositeEditorProvider.compose(this.editorProviders)));
            this.editorProviders = Lists.newArrayList();
        }
    }

    @Nonnull
    public Oak with(@Nonnull EditorProvider provider) {
        this.editorProviders.add(Preconditions.checkNotNull(provider));
        return this;
    }

    @Nonnull
    public Oak with(final @Nonnull Editor editor) {
        Preconditions.checkNotNull(editor);
        return this.with(new EditorProvider(){

            @Override
            @Nonnull
            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
                return editor;
            }
        });
    }

    @Nonnull
    public Oak with(@Nonnull SecurityProvider securityProvider) {
        this.securityProvider = Preconditions.checkNotNull(securityProvider);
        if (securityProvider instanceof WhiteboardAware) {
            ((WhiteboardAware)((Object)securityProvider)).setWhiteboard(this.whiteboard);
        }
        for (SecurityConfiguration securityConfiguration : securityProvider.getConfigurations()) {
            RepositoryInitializer ri = securityConfiguration.getRepositoryInitializer();
            if (ri == RepositoryInitializer.DEFAULT) continue;
            this.initializers.add(ri);
        }
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull ConflictHandler conflictHandler) {
        Preconditions.checkNotNull(conflictHandler);
        this.withEditorHook();
        this.commitHooks.add(new ConflictHook(conflictHandler));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = Preconditions.checkNotNull(scheduledExecutor);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull Executor executor) {
        this.executor = Preconditions.checkNotNull(executor);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull MBeanServer mbeanServer) {
        this.mbeanServer = Preconditions.checkNotNull(mbeanServer);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull Whiteboard whiteboard) {
        QueryEngineSettings queryEngineSettings;
        this.whiteboard = Preconditions.checkNotNull(whiteboard);
        if (this.securityProvider instanceof WhiteboardAware) {
            ((WhiteboardAware)((Object)this.securityProvider)).setWhiteboard(whiteboard);
        }
        if ((queryEngineSettings = WhiteboardUtils.getService(whiteboard, QueryEngineSettings.class)) != null) {
            this.queryEngineSettings = queryEngineSettings;
        }
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull Observer observer) {
        this.observers.add(Preconditions.checkNotNull(observer));
        return this;
    }

    @Deprecated
    public Oak withAsyncIndexing() {
        return this.withAsyncIndexing("async", 5L);
    }

    public Oak withFailOnMissingIndexProvider() {
        this.failOnMissingIndexProvider = true;
        return this;
    }

    public Oak withAtomicCounter() {
        return this.with(new AtomicCounterEditorProvider(new Supplier<Clusterable>(){

            @Override
            public Clusterable get() {
                return Oak.this.clusterable;
            }
        }, new Supplier<ScheduledExecutorService>(){

            @Override
            public ScheduledExecutorService get() {
                return Oak.this.scheduledExecutor;
            }
        }, new Supplier<NodeStore>(){

            @Override
            public NodeStore get() {
                return Oak.this.store;
            }
        }, new Supplier<Whiteboard>(){

            @Override
            public Whiteboard get() {
                return Oak.this.whiteboard;
            }
        }));
    }

    public Oak withAsyncIndexing(@Nonnull String name, long delayInSeconds) {
        if (this.asyncTasks == null) {
            this.asyncTasks = new HashMap<String, Long>();
        }
        Preconditions.checkState(delayInSeconds > 0L, "delayInSeconds value must be > 0");
        this.asyncTasks.put(Preconditions.checkNotNull(name), delayInSeconds);
        return this;
    }

    @Nonnull
    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    public ContentRepository createContentRepository() {
        if (this.contentRepository == null) {
            this.contentRepository = this.createNewContentRepository();
        }
        return this.contentRepository;
    }

    private ContentRepository createNewContentRepository() {
        final RepoStateCheckHook repoStateCheckHook = new RepoStateCheckHook();
        final ArrayList<Registration> regs = Lists.newArrayList();
        regs.add(this.whiteboard.register(Executor.class, this.getExecutor(), Collections.emptyMap()));
        IndexEditorProvider indexEditors = CompositeIndexEditorProvider.compose(this.indexEditorProviders);
        OakInitializer.initialize(this.store, new CompositeInitializer(this.initializers), indexEditors);
        QueryIndexProvider indexProvider = CompositeQueryIndexProvider.compose(this.queryIndexProviders);
        this.commitHooks.add(repoStateCheckHook);
        ArrayList<CommitHook> initHooks = new ArrayList<CommitHook>(this.commitHooks);
        initHooks.add(new EditorHook(CompositeEditorProvider.compose(this.editorProviders)));
        if (this.asyncTasks != null) {
            IndexMBeanRegistration indexRegistration = new IndexMBeanRegistration(this.whiteboard);
            regs.add(indexRegistration);
            for (Map.Entry<String, Long> t : this.asyncTasks.entrySet()) {
                AsyncIndexUpdate task = new AsyncIndexUpdate(t.getKey(), this.store, indexEditors);
                indexRegistration.registerAsyncIndexer(task, t.getValue());
                this.closer.register(task);
            }
            PropertyIndexAsyncReindex asyncPI = new PropertyIndexAsyncReindex(new AsyncIndexUpdate("async-reindex", this.store, indexEditors, true), this.getExecutor());
            regs.add(WhiteboardUtils.registerMBean(this.whiteboard, PropertyIndexAsyncReindexMBean.class, asyncPI, "PropertyIndexAsyncReindex", "async"));
        }
        regs.add(WhiteboardUtils.registerMBean(this.whiteboard, NodeCounterMBean.class, new NodeCounter(this.store), "NodeCounter", "nodeCounter"));
        regs.add(WhiteboardUtils.registerMBean(this.whiteboard, QueryEngineSettingsMBean.class, this.queryEngineSettings, "QueryEngineSettings", "settings"));
        Iterable<WorkspaceInitializer> workspaceInitializers = Iterables.transform(this.securityProvider.getConfigurations(), new Function<SecurityConfiguration, WorkspaceInitializer>(){

            @Override
            public WorkspaceInitializer apply(SecurityConfiguration sc) {
                return sc.getWorkspaceInitializer();
            }
        });
        OakInitializer.initialize(workspaceInitializers, this.store, this.defaultWorkspaceName, indexEditors);
        this.with(new IndexUpdateProvider(indexEditors, this.failOnMissingIndexProvider));
        this.withEditorHook();
        for (Observer observer : this.observers) {
            regs.add(WhiteboardUtils.registerObserver(this.whiteboard, observer));
        }
        RepositoryManager repositoryManager = new RepositoryManager(this.whiteboard);
        regs.add(WhiteboardUtils.registerMBean(this.whiteboard, RepositoryManagementMBean.class, repositoryManager, "RepositoryManagement", repositoryManager.getName()));
        CommitHook composite = CompositeHook.compose(this.commitHooks);
        regs.add(this.whiteboard.register(CommitHook.class, composite, Collections.emptyMap()));
        Tracker<Descriptors> t = this.whiteboard.track(Descriptors.class);
        return new ContentRepositoryImpl(this.store, composite, this.defaultWorkspaceName, this.queryEngineSettings, indexProvider, this.securityProvider, new AggregatingDescriptors(t)){

            @Override
            public void close() throws IOException {
                super.close();
                repoStateCheckHook.close();
                new CompositeRegistration(regs).unregister();
                Oak.this.closer.close();
            }
        };
    }

    public ContentSession createContentSession() {
        try {
            return this.createContentRepository().login(null, null);
        }
        catch (NoSuchWorkspaceException e) {
            throw new IllegalStateException("Default workspace not found", e);
        }
        catch (LoginException e) {
            throw new IllegalStateException("Anonymous login not allowed", e);
        }
    }

    public Root createRoot() {
        return this.createContentSession().getLatestRoot();
    }

    private static class RepoStateCheckHook
    implements CommitHook,
    Closeable {
        private volatile boolean closed;

        private RepoStateCheckHook() {
        }

        @Override
        @Nonnull
        public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
            if (this.closed) {
                throw new CommitFailedException("Oak", 2, "ContentRepository closed");
            }
            return after;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

