/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.TransformConstants;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.ToStringUtils;

abstract class CaseTermQuery
extends MultiTermQuery
implements TransformConstants {
    protected final int transform;
    private final Term term;

    CaseTermQuery(Term term, int transform) {
        this.term = term;
        this.transform = transform;
        this.setRewriteMethod(CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseTermEnum(reader);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(':');
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    private final class CaseTermEnum
    extends FilteredTermEnum {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CaseTermEnum(IndexReader reader) throws IOException {
            final LinkedHashMap<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
            ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
            int nameLength = FieldNames.getNameLength(CaseTermQuery.this.term.text());
            String propName = CaseTermQuery.this.term.text().substring(0, nameLength);
            OffsetCharSequence termText = new OffsetCharSequence(nameLength, CaseTermQuery.this.term.text());
            OffsetCharSequence currentTerm = new OffsetCharSequence(nameLength, CaseTermQuery.this.term.text(), CaseTermQuery.this.transform);
            try {
                if (CaseTermQuery.this.term.text().length() > nameLength) {
                    StringBuffer lowerLimit = new StringBuffer(propName);
                    String string = termText.toString();
                    String upperTermStr = string.toUpperCase();
                    String lowerTermStr = string.toLowerCase();
                    lowerLimit.append(upperTermStr);
                    lowerLimit.setCharAt(nameLength, Character.toLowerCase(lowerLimit.charAt(nameLength)));
                    StringBuffer upperLimit = new StringBuffer(propName);
                    upperLimit.append(lowerTermStr);
                    rangeScans.add(new RangeScan(reader, new Term(CaseTermQuery.this.term.field(), lowerLimit.toString()), new Term(CaseTermQuery.this.term.field(), upperLimit.toString())));
                    lowerLimit = new StringBuffer(propName);
                    lowerLimit.append(upperTermStr);
                    upperLimit = new StringBuffer(propName);
                    upperLimit.append(lowerTermStr);
                    upperLimit.setCharAt(nameLength, Character.toUpperCase(upperLimit.charAt(nameLength)));
                    rangeScans.add(new RangeScan(reader, new Term(CaseTermQuery.this.term.field(), lowerLimit.toString()), new Term(CaseTermQuery.this.term.field(), upperLimit.toString())));
                } else {
                    rangeScans.add(new RangeScan(reader, CaseTermQuery.this.term, CaseTermQuery.this.term));
                }
                block7: for (TermEnum termEnum : rangeScans) {
                    Term t;
                    while ((t = termEnum.term()) != null) {
                        currentTerm.setBase(t.text());
                        int compare = currentTerm.compareTo(termText);
                        if (compare == 0) {
                            orderedTerms.put(t, termEnum.docFreq());
                        }
                        if (termEnum.next()) continue;
                        continue block7;
                    }
                }
            }
            finally {
                for (TermEnum termEnum : rangeScans) {
                    try {
                        termEnum.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            final Iterator it = orderedTerms.keySet().iterator();
            this.setEnum(new TermEnum(){
                private Term current;
                {
                    this.getNext();
                }

                @Override
                public boolean next() {
                    this.getNext();
                    return this.current != null;
                }

                @Override
                public Term term() {
                    return this.current;
                }

                @Override
                public int docFreq() {
                    Integer docFreq = (Integer)orderedTerms.get(this.current);
                    return docFreq != null ? docFreq : 0;
                }

                @Override
                public void close() {
                }

                private void getNext() {
                    this.current = it.hasNext() ? (Term)it.next() : null;
                }
            });
        }

        @Override
        protected boolean termCompare(Term term) {
            return true;
        }

        @Override
        public float difference() {
            return 1.0f;
        }

        @Override
        protected boolean endEnum() {
            return false;
        }
    }

    static final class Lower
    extends CaseTermQuery {
        Lower(Term term) {
            super(term, 1);
        }
    }

    static final class Upper
    extends CaseTermQuery {
        Upper(Term term) {
            super(term, 2);
        }
    }
}

