/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public final class Serializer {
    private static final byte[] NULL_UUID_PLACEHOLDER_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String ENCODING = "UTF-8";

    public static void serialize(NodeState state, OutputStream stream) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        out.writeUTF(state.getNodeTypeName().toString());
        if (state.getParentId() == null) {
            out.write(NULL_UUID_PLACEHOLDER_BYTES);
        } else {
            out.write(state.getParentId().getRawBytes());
        }
        out.writeUTF("");
        Set<Name> c = state.getMixinTypeNames();
        out.writeInt(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            out.writeUTF(((Name)iter.next()).toString());
        }
        out.writeShort(state.getModCount());
        c = state.getPropertyNames();
        out.writeInt(c.size());
        for (Name propName : c) {
            out.writeUTF(propName.toString());
        }
        List<ChildNodeEntry> collChildren = state.getChildNodeEntries();
        out.writeInt(collChildren.size());
        for (ChildNodeEntry entry : collChildren) {
            out.writeUTF(entry.getName().toString());
            out.write(entry.getId().getRawBytes());
        }
    }

    public static void deserialize(NodeState state, InputStream stream) throws Exception {
        int i;
        DataInputStream in = new DataInputStream(stream);
        String s = in.readUTF();
        state.setNodeTypeName(NameFactoryImpl.getInstance().create(s));
        byte[] uuidBytes = new byte[16];
        in.readFully(uuidBytes);
        if (!Arrays.equals(uuidBytes, NULL_UUID_PLACEHOLDER_BYTES)) {
            state.setParentId(new NodeId(uuidBytes));
        }
        in.readUTF();
        int count = in.readInt();
        HashSet<Name> set = new HashSet<Name>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            set.add(NameFactoryImpl.getInstance().create(in.readUTF()));
        }
        if (set.size() > 0) {
            state.setMixinTypeNames(set);
        }
        short modCount = in.readShort();
        state.setModCount(modCount);
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            state.addPropertyName(NameFactoryImpl.getInstance().create(in.readUTF()));
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            Name name = NameFactoryImpl.getInstance().create(in.readUTF());
            in.readFully(uuidBytes);
            state.addChildNodeEntry(name, new NodeId(uuidBytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(PropertyState state, OutputStream stream, BLOBStore blobStore) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        out.writeInt(state.getType());
        out.writeBoolean(state.isMultiValued());
        out.writeUTF("");
        out.writeShort(state.getModCount());
        InternalValue[] values = state.getValues();
        out.writeInt(values.length);
        for (int i = 0; i < values.length; ++i) {
            InternalValue val = values[i];
            if (state.getType() == 2) {
                InputStream in = val.getStream();
                String blobId = blobStore.createId(state.getPropertyId(), i);
                try {
                    blobStore.put(blobId, in, val.getLength());
                }
                finally {
                    IOUtils.closeQuietly(in);
                }
                out.writeUTF(blobId);
                if (blobStore instanceof ResourceBasedBLOBStore) {
                    FileSystemResource fsRes = ((ResourceBasedBLOBStore)blobStore).getResource(blobId);
                    values[i] = InternalValue.create(fsRes);
                } else {
                    in = blobStore.get(blobId);
                    try {
                        values[i] = InternalValue.create(in);
                    }
                    finally {
                        IOUtils.closeQuietly(in);
                    }
                }
                val.discard();
                continue;
            }
            byte[] bytes = val.toString().getBytes(ENCODING);
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deserialize(PropertyState state, InputStream stream, BLOBStore blobStore) throws Exception {
        DataInputStream in = new DataInputStream(stream);
        int type = in.readInt();
        state.setType(type);
        boolean multiValued = in.readBoolean();
        state.setMultiValued(multiValued);
        in.readUTF();
        short modCount = in.readShort();
        state.setModCount(modCount);
        int count = in.readInt();
        InternalValue[] values = new InternalValue[count];
        int i = 0;
        while (true) {
            InternalValue val;
            block12: {
                block11: {
                    if (i >= count) {
                        state.setValues(values);
                        return;
                    }
                    if (type != 2) break block11;
                    String s = in.readUTF();
                    if (blobStore instanceof ResourceBasedBLOBStore) {
                        FileSystemResource fsRes = ((ResourceBasedBLOBStore)blobStore).getResource(s);
                        val = InternalValue.create(fsRes);
                        break block12;
                    } else {
                        InputStream is = blobStore.get(s);
                        try {
                            val = InternalValue.create(is);
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                int len = in.readInt();
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                String s = new String(bytes, ENCODING);
                val = InternalValue.valueOf(s, type);
            }
            values[i] = val;
            ++i;
        }
    }

    public static void serialize(NodeReferences refs, OutputStream stream) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        List<PropertyId> c = refs.getReferences();
        out.writeInt(c.size());
        for (PropertyId propId : c) {
            out.writeUTF(propId.toString());
        }
    }

    public static void deserialize(NodeReferences refs, InputStream stream) throws Exception {
        DataInputStream in = new DataInputStream(stream);
        refs.clearAllReferences();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            refs.addReference(PropertyId.valueOf(in.readUTF()));
        }
    }
}

