/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AsyncUploadCache;
import org.apache.jackrabbit.core.data.AsyncUploadCacheResult;
import org.apache.jackrabbit.core.data.LocalCache;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocalCache
extends TestCase {
    private static final String CACHE_DIR = "target/cache";
    private static final String TEMP_DIR = "target/temp";
    private static final String TARGET_DIR = "target";
    protected String cacheDirPath;
    protected String tempDirPath;
    protected Random randomGen = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(TestLocalCache.class);

    protected void setUp() {
        try {
            this.cacheDirPath = "target/cache-" + String.valueOf(this.randomGen.nextInt(9999)) + "-" + String.valueOf(this.randomGen.nextInt(9999));
            File cachedir = new File(this.cacheDirPath);
            for (int i = 0; i < 4 && cachedir.exists(); ++i) {
                FileUtils.deleteQuietly(cachedir);
                Thread.sleep(1000L);
            }
            cachedir.mkdirs();
            this.tempDirPath = "target/temp-" + String.valueOf(this.randomGen.nextInt(9999)) + "-" + String.valueOf(this.randomGen.nextInt(9999));
            File tempdir = new File(this.tempDirPath);
            for (int i = 0; i < 4 && tempdir.exists(); ++i) {
                FileUtils.deleteQuietly(tempdir);
                Thread.sleep(1000L);
            }
            tempdir.mkdirs();
        }
        catch (Exception e) {
            LOG.error("error:", e);
            TestLocalCache.fail();
        }
    }

    protected void tearDown() throws Exception {
        File cachedir = new File(this.cacheDirPath);
        for (int i = 0; i < 4 && cachedir.exists(); ++i) {
            FileUtils.deleteQuietly(cachedir);
            Thread.sleep(1000L);
        }
        File tempdir = new File(this.tempDirPath);
        for (int i = 0; i < 4 && tempdir.exists(); ++i) {
            FileUtils.deleteQuietly(tempdir);
            Thread.sleep(1000L);
        }
    }

    public void testStoreRetrieve() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(this.tempDirPath, this.cacheDirPath, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(this.cacheDirPath, this.tempDirPath, 400L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            byte[] data = new byte[100];
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
            random.nextBytes(data);
            byteMap.put("a1", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a2", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a3", data);
            cache.store("a1", new ByteArrayInputStream((byte[])byteMap.get("a1")));
            cache.store("a2", new ByteArrayInputStream((byte[])byteMap.get("a2")));
            cache.store("a3", new ByteArrayInputStream((byte[])byteMap.get("a3")));
            InputStream result = cache.getIfStored("a1");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a2");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a3");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), result);
            IOUtils.closeQuietly(result);
        }
        catch (Exception e) {
            LOG.error("error:", e);
            TestLocalCache.fail();
        }
    }

    public void testAutoPurge() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(this.tempDirPath, this.cacheDirPath, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(this.cacheDirPath, this.tempDirPath, 400L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            byte[] data = new byte[100];
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
            random.nextBytes(data);
            byteMap.put("a1", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a2", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a3", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a4", data);
            cache.store("a1", new ByteArrayInputStream((byte[])byteMap.get("a1")));
            cache.store("a2", new ByteArrayInputStream((byte[])byteMap.get("a2")));
            cache.store("a3", new ByteArrayInputStream((byte[])byteMap.get("a3")));
            InputStream result = cache.getIfStored("a1");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a2");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a3");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), result);
            IOUtils.closeQuietly(result);
            data = new byte[90];
            random.nextBytes(data);
            byteMap.put("a4", data);
            cache.store("a4", new ByteArrayInputStream((byte[])byteMap.get("a4")));
            Thread.sleep(1000L);
            result = cache.getIfStored("a1");
            TestLocalCache.assertNull((String)"a1 should be null", (Object)result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a2");
            TestLocalCache.assertNull((String)"a2 should be null", (Object)result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a3");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), result);
            IOUtils.closeQuietly(result);
            result = cache.getIfStored("a4");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a4")), result);
            IOUtils.closeQuietly(result);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a5", data);
            cache.store("a5", new ByteArrayInputStream((byte[])byteMap.get("a5")));
            result = cache.getIfStored("a3");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), result);
            IOUtils.closeQuietly(result);
        }
        catch (Exception e) {
            LOG.error("error:", e);
            TestLocalCache.fail();
        }
    }

    public void testAutoPurgeWithPendingUpload() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(this.tempDirPath, this.cacheDirPath, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(this.cacheDirPath, this.tempDirPath, 400L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            byte[] data = new byte[125];
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
            random.nextBytes(data);
            byteMap.put("a1", data);
            data = new byte[125];
            random.nextBytes(data);
            byteMap.put("a2", data);
            data = new byte[125];
            random.nextBytes(data);
            byteMap.put("a3", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a4", data);
            File tempDir = new File(this.tempDirPath);
            File f = File.createTempFile("test", "tmp", tempDir);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a1"));
            fos.close();
            AsyncUploadCacheResult result = cache.store("a1", f, true);
            TestLocalCache.assertTrue((String)"should be able to add to pending upload", (boolean)result.canAsyncUpload());
            f = File.createTempFile("test", "tmp", tempDir);
            fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a2"));
            fos.close();
            result = cache.store("a2", f, true);
            TestLocalCache.assertTrue((String)"should be able to add to pending upload", (boolean)result.canAsyncUpload());
            f = File.createTempFile("test", "tmp", tempDir);
            fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a3"));
            fos.close();
            result = cache.store("a3", f, true);
            TestLocalCache.assertTrue((String)"should be able to add to pending upload", (boolean)result.canAsyncUpload());
            InputStream inp = cache.getIfStored("a1");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), inp);
            IOUtils.closeQuietly(inp);
            inp = cache.getIfStored("a2");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), inp);
            IOUtils.closeQuietly(inp);
            inp = cache.getIfStored("a3");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), inp);
            IOUtils.closeQuietly(inp);
            data = new byte[90];
            random.nextBytes(data);
            byteMap.put("a4", data);
            f = File.createTempFile("test", "tmp", tempDir);
            fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a4"));
            fos.close();
            result = cache.store("a4", f, true);
            TestLocalCache.assertFalse((String)"should not be able to add to pending upload", (boolean)result.canAsyncUpload());
            Thread.sleep(1000L);
            inp = cache.getIfStored("a1");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), inp);
            IOUtils.closeQuietly(inp);
            inp = cache.getIfStored("a2");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), inp);
            IOUtils.closeQuietly(inp);
            inp = cache.getIfStored("a3");
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), inp);
            IOUtils.closeQuietly(inp);
            inp = cache.getIfStored("a4");
            TestLocalCache.assertNull((String)"a4 should be null", (Object)inp);
        }
        catch (Exception e) {
            LOG.error("error:", e);
            TestLocalCache.fail();
        }
    }

    public void testConcurrentInitWithStore() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(this.tempDirPath, this.cacheDirPath, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(this.cacheDirPath, this.tempDirPath, 10000000L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            int fileUploads = 1000;
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>(fileUploads);
            for (int i = 0; i < fileUploads; ++i) {
                byte[] data = new byte[100];
                random.nextBytes(data);
                String key = "a" + i;
                byteMap.put(key, data);
                cache.store(key, new ByteArrayInputStream((byte[])byteMap.get(key)));
            }
            cache.close();
            ExecutorService executor = Executors.newFixedThreadPool(10, new NamedThreadFactory("localcache-store-worker"));
            cache = new LocalCache(this.cacheDirPath, this.tempDirPath, 10000000L, 0.95, 0.7, pendingFiles);
            executor.execute(new StoreWorker(cache, byteMap));
            executor.shutdown();
            while (!executor.awaitTermination(15L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            LOG.error("error:", e);
            TestLocalCache.fail();
        }
    }

    protected void assertEquals(InputStream a, InputStream b) throws IOException {
        int ai;
        do {
            ai = a.read();
            int bi = b.read();
            TestLocalCache.assertEquals((int)ai, (int)bi);
        } while (ai >= 0);
        IOUtils.closeQuietly(a);
        IOUtils.closeQuietly(b);
    }

    private class StoreWorker
    implements Runnable {
        Map<String, byte[]> byteMap;
        LocalCache cache;
        Random random;

        private StoreWorker(LocalCache cache, Map<String, byte[]> byteMap) {
            this.byteMap = byteMap;
            this.cache = cache;
            this.random = new Random(byteMap.size());
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    String key = "a" + this.random.nextInt(this.byteMap.size());
                    LOG.debug("key=" + key);
                    this.cache.store(key, new ByteArrayInputStream(this.byteMap.get(key)));
                }
            }
            catch (Exception e) {
                LOG.error("error:", e);
                Assert.fail();
            }
        }
    }
}

