/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.data.TestCaseBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileDataStore
extends TestCaseBase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestFileDataStore.class);
    String fsPath;

    @Override
    protected DataStore createDataStore() throws RepositoryException {
        FileDataStore fds = new FileDataStore();
        Properties props = this.loadProperties("/fs.properties");
        String pathValue = props.getProperty("fsBackendPath");
        this.fsPath = pathValue != null && !"".equals(pathValue.trim()) ? pathValue + "/fds" + "-" + String.valueOf(this.randomGen.nextInt(100000)) + "-" + String.valueOf(this.randomGen.nextInt(100000)) : this.dataStoreDir + "/repository/datastore";
        LOG.info("path [{}] set.", (Object)this.fsPath);
        fds.setPath(this.fsPath);
        fds.init(this.dataStoreDir);
        return fds;
    }

    @Override
    protected void tearDown() {
        LOG.info("cleaning fsPath [{}]", (Object)this.fsPath);
        File f = new File(this.fsPath);
        try {
            for (int i = 0; i < 4 && f.exists(); ++i) {
                FileUtils.deleteQuietly(f);
                Thread.sleep(2000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }
}

