/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.jackrabbit.core.data.AsyncTouchCallback;
import org.apache.jackrabbit.core.data.AsyncTouchResult;
import org.apache.jackrabbit.core.data.AsyncUploadCallback;
import org.apache.jackrabbit.core.data.AsyncUploadResult;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;

public class InMemoryBackend
implements Backend {
    private HashMap<DataIdentifier, byte[]> data = new HashMap();
    private HashMap<DataIdentifier, Long> timeMap = new HashMap();
    private CachingDataStore store;
    private Properties properties;

    @Override
    public void init(CachingDataStore store, String homeDir, String config) throws DataStoreException {
        this.log("init");
        this.store = store;
    }

    @Override
    public void close() {
        this.log("close");
    }

    @Override
    public boolean exists(DataIdentifier identifier) {
        this.log("exists " + identifier);
        return this.data.containsKey(identifier);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        this.log("getAllIdentifiers");
        return this.data.keySet().iterator();
    }

    @Override
    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        this.log("read " + identifier);
        return new ByteArrayInputStream(this.data.get(identifier));
    }

    @Override
    public void writeAsync(DataIdentifier identifier, File file, AsyncUploadCallback callback) throws DataStoreException {
        this.write(identifier, file, true, callback);
    }

    @Override
    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        this.write(identifier, file, false, null);
    }

    @Override
    public long getLastModified(DataIdentifier identifier) throws DataStoreException {
        this.log("getLastModified " + identifier);
        return this.timeMap.get(identifier);
    }

    @Override
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        this.timeMap.remove(identifier);
        this.data.remove(identifier);
    }

    @Override
    public Set<DataIdentifier> deleteAllOlderThan(long min) throws DataStoreException {
        this.log("deleteAllOlderThan " + min);
        HashSet<DataIdentifier> tobeDeleted = new HashSet<DataIdentifier>();
        for (Map.Entry<DataIdentifier, Long> entry : this.timeMap.entrySet()) {
            DataIdentifier identifier = entry.getKey();
            long timestamp = entry.getValue();
            if (timestamp >= min || this.store.isInUse(identifier) || !this.store.confirmDelete(identifier)) continue;
            this.store.deleteFromCache(identifier);
            tobeDeleted.add(identifier);
        }
        for (DataIdentifier identifier : tobeDeleted) {
            this.timeMap.remove(identifier);
            this.data.remove(identifier);
        }
        return tobeDeleted;
    }

    @Override
    public long getLength(DataIdentifier identifier) throws DataStoreException {
        try {
            return this.data.get(identifier).length;
        }
        catch (Exception e) {
            throw new DataStoreException(e);
        }
    }

    @Override
    public boolean exists(DataIdentifier identifier, boolean touch) throws DataStoreException {
        boolean retVal = this.data.containsKey(identifier);
        if (retVal && touch) {
            this.timeMap.put(identifier, System.currentTimeMillis());
        }
        return retVal;
    }

    @Override
    public void touch(DataIdentifier identifier, long minModifiedDate) {
        this.timeMap.put(identifier, System.currentTimeMillis());
    }

    @Override
    public void touchAsync(DataIdentifier identifier, long minModifiedDate, AsyncTouchCallback callback) {
        this.timeMap.put(identifier, System.currentTimeMillis());
        callback.onSuccess(new AsyncTouchResult(identifier));
    }

    private void write(DataIdentifier identifier, File file, boolean async, AsyncUploadCallback callback) throws DataStoreException {
        this.log("write " + identifier + " " + file.length());
        byte[] buffer = new byte[(int)file.length()];
        try {
            if (async && callback == null) {
                throw new IllegalArgumentException("callback parameter cannot be null");
            }
            DataInputStream din = new DataInputStream(new FileInputStream(file));
            din.readFully(buffer);
            din.close();
            this.data.put(identifier, buffer);
            this.timeMap.put(identifier, System.currentTimeMillis());
        }
        catch (IOException e) {
            if (async) {
                callback.onAbort(new AsyncUploadResult(identifier, file));
            }
            throw new DataStoreException(e);
        }
        if (async) {
            callback.onSuccess(new AsyncUploadResult(identifier, file));
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private void log(String message) {
    }
}

