/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.lucene.index.IndexReader;

public final class IndexAccessor {
    private IndexAccessor() {
    }

    public static IndexReader getReader(RepositoryContext ctx) throws RepositoryException, IOException {
        RepositoryImpl repo = ctx.getRepository();
        SearchManager searchMgr = repo.getSearchManager(ctx.getRepositoryConfig().getDefaultWorkspaceName());
        if (searchMgr == null) {
            return null;
        }
        QueryHandler handler = searchMgr.getQueryHandler();
        SearchIndex index = (SearchIndex)handler;
        return index.getIndexReader();
    }
}

