/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.bs.be.validate.MetricEventValidator;
import com.finconsgroup.itserr.marketplace.metrics.bs.client.MetricDmClient;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricEventService;
import feign.FeignException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricEventService
implements MetricEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricEventService.class);
    private final MetricDmClient metricDmClient;
    private final List<MetricEventValidator> validators;

    @NonNull
    public OutputMetricEventDto create(@NonNull MetricDtoType metric, @NonNull InputCreateMetricEventDto event) {
        this.validators.forEach(validator -> validator.validate(metric, event));
        try {
            return this.metricDmClient.createMetricEvent(metric.getViewValue(), event);
        }
        catch (FeignException.Conflict e) {
            throw new MetricEventConflictException((Throwable)e);
        }
    }

    @Generated
    public DefaultMetricEventService(MetricDmClient metricDmClient, List<MetricEventValidator> validators) {
        this.metricDmClient = metricDmClient;
        this.validators = validators;
    }
}

