/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.api;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Diagnostics", description="Diagnostics API: provides endpoints used for debugging and runtime analysis.")
@SecurityRequirement(name="BearerAuth")
public interface DiagnosticsApi {
    @Operation(summary="Download log file", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/workspace/diagnostics/download-logs"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadLogs();

    @Operation(summary="create metricEvent", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/metrics/diagnostics/metrics/{metricId}/events"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputMetricEventDto createMetricEvent(@PathVariable(value="metricId") MetricDtoType var1, @Valid @RequestBody InputCreateMetricEventDto var2);
}

