/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="member_request")
public class MemberRequestEntity
extends AbstractUUIDEntity {
    @Column(name="user_id", nullable=false)
    private UUID userId;
    @Column(name="institutional_page_id", nullable=false)
    private UUID institutionalPageId;
    @Column(name="request_type", nullable=false)
    private MemberRequestType requestType;
    @Column(name="wp_leader", nullable=false)
    private boolean wpLeader;
    @Column(name="message")
    private String message;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant currentTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = currentTime;
        }
        this.updateTime = currentTime;
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected MemberRequestEntity(MemberRequestEntityBuilder<?, ?> b) {
        super(b);
        this.userId = b.userId;
        this.institutionalPageId = b.institutionalPageId;
        this.requestType = b.requestType;
        this.wpLeader = b.wpLeader;
        this.message = b.message;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static MemberRequestEntityBuilder<?, ?> builder() {
        return new MemberRequestEntityBuilderImpl();
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public UUID getInstitutionalPageId() {
        return this.institutionalPageId;
    }

    @Generated
    public MemberRequestType getRequestType() {
        return this.requestType;
    }

    @Generated
    public boolean isWpLeader() {
        return this.wpLeader;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setInstitutionalPageId(UUID institutionalPageId) {
        this.institutionalPageId = institutionalPageId;
    }

    @Generated
    public void setRequestType(MemberRequestType requestType) {
        this.requestType = requestType;
    }

    @Generated
    public void setWpLeader(boolean wpLeader) {
        this.wpLeader = wpLeader;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "MemberRequestEntity(userId=" + String.valueOf(this.getUserId()) + ", institutionalPageId=" + String.valueOf(this.getInstitutionalPageId()) + ", requestType=" + String.valueOf(this.getRequestType()) + ", wpLeader=" + this.isWpLeader() + ", message=" + this.getMessage() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberRequestEntity)) {
            return false;
        }
        MemberRequestEntity other = (MemberRequestEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isWpLeader() != other.isWpLeader()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        UUID this$institutionalPageId = this.getInstitutionalPageId();
        UUID other$institutionalPageId = other.getInstitutionalPageId();
        if (this$institutionalPageId == null ? other$institutionalPageId != null : !((Object)this$institutionalPageId).equals(other$institutionalPageId)) {
            return false;
        }
        MemberRequestType this$requestType = this.getRequestType();
        MemberRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemberRequestEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isWpLeader() ? 79 : 97);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        UUID $institutionalPageId = this.getInstitutionalPageId();
        result = result * 59 + ($institutionalPageId == null ? 43 : ((Object)$institutionalPageId).hashCode());
        MemberRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public MemberRequestEntity() {
    }
}

