/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="institutional_page_member")
public class MemberEntity
extends AbstractUUIDEntity {
    @Column(name="member_id", nullable=false)
    private UUID memberId;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="institutional_page_id", updatable=false)
    private InstitutionalPageEntity institutionalPage;
    @Column(name="institutional_page_id", insertable=false, updatable=false)
    private UUID institutionalPageId;
    @Column(name="wp_lead", nullable=false)
    private boolean wpLead;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant currentTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = currentTime;
        }
        this.updateTime = currentTime;
    }

    @PostPersist
    public void postPersist() {
        this.institutionalPageId = this.institutionalPage.getId();
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected MemberEntity(MemberEntityBuilder<?, ?> b) {
        super(b);
        this.memberId = b.memberId;
        this.institutionalPage = b.institutionalPage;
        this.institutionalPageId = b.institutionalPageId;
        this.wpLead = b.wpLead;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static MemberEntityBuilder<?, ?> builder() {
        return new MemberEntityBuilderImpl();
    }

    @Generated
    public UUID getMemberId() {
        return this.memberId;
    }

    @Generated
    public InstitutionalPageEntity getInstitutionalPage() {
        return this.institutionalPage;
    }

    @Generated
    public UUID getInstitutionalPageId() {
        return this.institutionalPageId;
    }

    @Generated
    public boolean isWpLead() {
        return this.wpLead;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setMemberId(UUID memberId) {
        this.memberId = memberId;
    }

    @Generated
    public void setInstitutionalPage(InstitutionalPageEntity institutionalPage) {
        this.institutionalPage = institutionalPage;
    }

    @Generated
    public void setInstitutionalPageId(UUID institutionalPageId) {
        this.institutionalPageId = institutionalPageId;
    }

    @Generated
    public void setWpLead(boolean wpLead) {
        this.wpLead = wpLead;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "MemberEntity(memberId=" + String.valueOf(this.getMemberId()) + ", institutionalPage=" + String.valueOf(this.getInstitutionalPage()) + ", institutionalPageId=" + String.valueOf(this.getInstitutionalPageId()) + ", wpLead=" + this.isWpLead() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberEntity)) {
            return false;
        }
        MemberEntity other = (MemberEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isWpLead() != other.isWpLead()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        UUID this$memberId = this.getMemberId();
        UUID other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !((Object)this$memberId).equals(other$memberId)) {
            return false;
        }
        InstitutionalPageEntity this$institutionalPage = this.getInstitutionalPage();
        InstitutionalPageEntity other$institutionalPage = other.getInstitutionalPage();
        if (this$institutionalPage == null ? other$institutionalPage != null : !this$institutionalPage.equals(other$institutionalPage)) {
            return false;
        }
        UUID this$institutionalPageId = this.getInstitutionalPageId();
        UUID other$institutionalPageId = other.getInstitutionalPageId();
        if (this$institutionalPageId == null ? other$institutionalPageId != null : !((Object)this$institutionalPageId).equals(other$institutionalPageId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemberEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isWpLead() ? 79 : 97);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        UUID $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : ((Object)$memberId).hashCode());
        InstitutionalPageEntity $institutionalPage = this.getInstitutionalPage();
        result = result * 59 + ($institutionalPage == null ? 43 : $institutionalPage.hashCode());
        UUID $institutionalPageId = this.getInstitutionalPageId();
        result = result * 59 + ($institutionalPageId == null ? 43 : ((Object)$institutionalPageId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public MemberEntity() {
    }
}

