/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.dto.PageRequestDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.event.bs.api.EventApi;
import com.finconsgroup.itserr.marketplace.event.bs.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.service.EventService;
import java.beans.PropertyEditor;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventController
implements EventApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventController.class);
    private final EventService eventService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    public OutputPageDto<OutputEventDto> findAll(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        PageRequestDto pageRequest = PageRequestDto.builder().pageNumber(pageNumber).pageSize(pageSize).direction(direction).sort(sort).build();
        return this.eventService.findAll(associationsToLoad, pageRequest);
    }

    public OutputEventDto findById(UUID eventId) {
        return this.eventService.findById(eventId);
    }

    public OutputEventDto createEvent(InputCreateEventDto inputCreateEventDto) {
        return this.eventService.create(inputCreateEventDto);
    }

    public OutputEventDto updateEventById(UUID eventId, InputUpdateEventDto inputUpdateEventDto) {
        return this.eventService.updateById(eventId, inputUpdateEventDto);
    }

    public void deleteEventById(UUID eventId) {
        this.eventService.deleteById(eventId);
    }

    public OutputEventDto register(UUID id) {
        return this.eventService.register(id);
    }

    public OutputEventDto unregister(UUID id) {
        return this.eventService.unregister(id);
    }

    public OutputEventDto registerProgram(UUID eventId, UUID programId, InputProgramSubscribedParticipantDto inputProgramSubscribedParticipantDto) {
        return this.eventService.registerProgram(eventId, programId, inputProgramSubscribedParticipantDto);
    }

    public OutputEventDto unregisterProgram(UUID eventId, UUID programId) {
        return this.eventService.unregisterProgram(eventId, programId);
    }

    @Generated
    public EventController(EventService eventService) {
        this.eventService = eventService;
    }
}

