/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.dm.service.impl;

import com.finconsgroup.itserr.marketplace.audit.dm.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.dm.entity.AuditLogEntity;
import com.finconsgroup.itserr.marketplace.audit.dm.mapper.AuditMapper;
import com.finconsgroup.itserr.marketplace.audit.dm.repository.AuditRepository;
import com.finconsgroup.itserr.marketplace.audit.dm.service.AuditLogService;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultAuditLogService
implements AuditLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAuditLogService.class);
    private final AuditRepository auditRepository;
    private final AuditMapper auditMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputAuditLogDto> findAll(@NonNull Pageable pageable) {
        Page auditEntityPage = this.auditRepository.findAll(pageable);
        return auditEntityPage.map(arg_0 -> ((AuditMapper)this.auditMapper).toDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputAuditLogDto findById(@NonNull UUID auditId) {
        AuditLogEntity auditLogEntity = this.findByIdOrThrow(auditId);
        return this.auditMapper.toDto(auditLogEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputAuditLogDto create(@NonNull InputCreateAuditLogDto inputCreateAuditLogDto) {
        AuditLogEntity auditLogEntity = this.auditMapper.toEntity(inputCreateAuditLogDto);
        return this.auditMapper.toDto((AuditLogEntity)this.auditRepository.saveAndFlush((Object)auditLogEntity));
    }

    private AuditLogEntity findByIdOrThrow(@NonNull UUID auditId) {
        return (AuditLogEntity)this.auditRepository.findById((Object)auditId).orElseThrow(() -> new WP2ResourceNotFoundException(auditId));
    }

    @Generated
    public DefaultAuditLogService(AuditRepository auditRepository, AuditMapper auditMapper) {
        this.auditRepository = auditRepository;
        this.auditMapper = auditMapper;
    }
}

