/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.integration.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.MetadataLibsMetadataDmClient;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.integration.exception.WP2InvalidMetadataException;
import com.finconsgroup.itserr.marketplace.metadata.integration.exception.WP2MetadataNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.integration.exception.WP2MetadataRetrieveException;
import com.finconsgroup.itserr.marketplace.metadata.integration.mapper.FieldMapper;
import com.finconsgroup.itserr.marketplace.metadata.integration.service.MetadataValidationService;
import com.finconsgroup.itserr.marketplace.metadata.lib.ConstraintViolation;
import com.finconsgroup.itserr.marketplace.metadata.lib.MetadataValidator;
import com.finconsgroup.itserr.marketplace.metadata.lib.bean.Field;
import com.finconsgroup.itserr.marketplace.metadata.lib.validation.field.FieldValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.lang.NonNull;

public class DefaultMetadataValidationService
implements MetadataValidationService {
    private final List<FieldValidator> fieldValidators;
    private final MetadataLibsMetadataDmClient client;
    private final FieldMapper fieldMapper;

    @Override
    @NonNull
    public List<ConstraintViolation> validate(@NonNull UUID metadataId, @NonNull Map<String, Object> values) {
        OutputMetadataDmDto metadata;
        try {
            metadata = this.client.findById(metadataId);
        }
        catch (WP2ResourceNotFoundException e) {
            throw new WP2MetadataNotFoundException(e);
        }
        catch (Exception e) {
            throw new WP2MetadataRetrieveException(e);
        }
        List<Field> fields = Optional.ofNullable(metadata.getFields()).orElseGet(ArrayList::new).stream().map(this.fieldMapper::clientFieldToField).toList();
        MetadataValidator validator = new MetadataValidator(fields, this.fieldValidators);
        return validator.validate(values);
    }

    @Override
    public void validateOrThrow(@NonNull UUID metadataId, @NonNull Map<String, Object> values) {
        List<ConstraintViolation> metadataViolations = this.validate(metadataId, values);
        if (!metadataViolations.isEmpty()) {
            throw new WP2InvalidMetadataException(metadataViolations);
        }
    }

    @Generated
    public DefaultMetadataValidationService(List<FieldValidator> fieldValidators, MetadataLibsMetadataDmClient client, FieldMapper fieldMapper) {
        this.fieldValidators = fieldValidators;
        this.client = client;
        this.fieldMapper = fieldMapper;
    }
}

