package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ReferenceEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;


@Mapper(config = MapperConfiguration.class, uses = {ManualReferenceMapper.class})
public interface ReferenceMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "userProfile", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    ReferenceEntity toEntity(InputReferenceDto model);

    OutputReferenceDto toDto(ReferenceEntity entity);

    @AfterMapping
    default void setReferenceDetails(@MappingTarget ReferenceEntity referenceEntity) {
        if (referenceEntity != null && referenceEntity.getManualReferences() != null) {
            referenceEntity.getManualReferences().forEach(manualReferenceEntity -> manualReferenceEntity.setReference(referenceEntity));
        }
    }
}
