/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils;
import com.finconsgroup.itserr.marketplace.userprofile.dm.exception.UserProfileAlreadyExistsException;
import com.finconsgroup.itserr.marketplace.userprofile.dm.exception.UserProfileNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class CustomExceptionHandler {
    @ExceptionHandler(value={UserProfileNotFoundException.class})
    public ResponseEntity<ErrorResponseDto> handleUserProfileNotFoundException(UserProfileNotFoundException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.NOT_FOUND, (String)ex.getMessage());
    }

    @ExceptionHandler(value={UserProfileAlreadyExistsException.class})
    public ResponseEntity<ErrorResponseDto> handleUserProfileFoundException(UserProfileAlreadyExistsException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.CONFLICT, (String)ex.getMessage());
    }
}

