package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.userprofile.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * DTO for CV details.
 */
@Schema(name = "InputCVDto", description = "DTO for CV details")
@Data
@Builder
@AllArgsConstructor
public class InputCVDto {

    @Schema(description = "URL of the CV file", example = "https://example.com/cv.pdf")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String fileUrl;

    @Schema(description = "Filename of the CV", example = "Curriculum Vitae di John Doe")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String filename;

    @Schema(description = "Size of the CV file in bytes", example = "123456")
    @PositiveOrZero(message = "File size must be positive")
    private long size;
}
