package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Create document request.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "CreateDocumentRequest",
        description = "Contains the data of a document to be created"
)
public class InputCreateDocumentDto {

    @Schema(
            description = "Name of the document. Default is the uploaded document filename.",
            example = "my-file.pdf")
    private String name;

    @Schema(
            description = "Description of the document.",
            example = "My file")
    private String description;

}
