package com.finconsgroup.itserr.marketplace.search.dm.bean;

import lombok.Builder;

import java.util.List;

/**
 * The request to aggregate results of a query by term and return only the limited top hits
 * for the index on document of type T.
 *
 * @param name          the name of the aggregation used for processing response
 * @param term          the term to group by
 * @param topHitsLimit  the maximum number of documents to return per term
 * @param sourceFields  the fields of the document to read
 * @param includeScore  the flag to indicate if score should be included in results
 * @param documentClass the class representing type of the document
 * @param <T>           the type of the document
 */
@Builder
public record TopHitsAggregationRequest<T>(
        String name,
        String term,
        int topHitsLimit,
        List<String> sourceFields,
        boolean includeScore,
        Class<T> documentClass) {
}
