package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingNewsBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("newsResourceSubscriber")
@Slf4j
public class NewsResourceSubscriber extends AbstractResourceSubscriber {

    /**
     * Messaging configuration properties for news-bs events.
     */
    private final MessagingNewsBsProperties messagingNewsBsProperties;

    /**
     * The client used to interact with the search dm.
     */
    private final SearchDmClient searchDmClient;

    /**
     * Constructs the NewsResourceSubscriber
     *
     * @param searchBsConfigurationProperties the application configuration properties
     * @param searchDmClient                  http client for interacting with the search DM service
     */
    public NewsResourceSubscriber(
            SearchBsConfigurationProperties searchBsConfigurationProperties,
            SearchDmClient searchDmClient
    ) {
        this.messagingNewsBsProperties = searchBsConfigurationProperties.getMessaging().getNewsBs();
        this.searchDmClient = searchDmClient;
    }

    @Override
    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing news event, id: {}, payload: {}, type: {}", resourceId, resourcePayload, eventType);
        if (Objects.equals(eventType, messagingNewsBsProperties.getResourceCreatedEventType()) ||
                Objects.equals(eventType, messagingNewsBsProperties.getResourceUpdatedEventType())) {
            searchDmClient.upsertNews(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, messagingNewsBsProperties.getResourceDeletedEventType())) {
            searchDmClient.deleteNews(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", eventType, resourceId);
        }
    }
}
