package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingInstitutionalPageBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("institutionalPageResourceSubscriber")
@Slf4j
public class InstitutionalPageResourceSubscriber extends AbstractResourceSubscriber {

    /**
     * Messaging configuration properties for institutional-page-bs events.
     */
    private final MessagingInstitutionalPageBsProperties messagingInstitutionalPageBsProperties;

    /**
     * The client used to interact with the search dm.
     */
    private final SearchDmClient searchDmClient;

    /**
     * Constructs the InstitutionalPageResourceSubscriber
     *
     * @param searchBsConfigurationProperties the application configuration properties
     * @param searchDmClient                  http client for interacting with the search DM service
     */
    public InstitutionalPageResourceSubscriber(
            SearchBsConfigurationProperties searchBsConfigurationProperties,
            SearchDmClient searchDmClient
    ) {
        this.messagingInstitutionalPageBsProperties = searchBsConfigurationProperties.getMessaging().getInstitutionalPageBs();
        this.searchDmClient = searchDmClient;
    }

    @Override
    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing institutional page event, id: {}, payload: {}, type: {}", resourceId, resourcePayload, eventType);
        if (Objects.equals(eventType, messagingInstitutionalPageBsProperties.getResourceCreatedEventType()) ||
                Objects.equals(eventType, messagingInstitutionalPageBsProperties.getResourceUpdatedEventType())) {
            searchDmClient.upsertInstitutionalPage(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, messagingInstitutionalPageBsProperties.getResourceDeletedEventType())) {
            searchDmClient.deleteInstitutionalPage(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", eventType, resourceId);
        }
    }
}
