package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

/**
 * A wrapper class for extracting only the ID field from entity payloads.
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class EntityIdWrapper {
    /**
     * The unique identifier extracted from the entity payloads.
     * <p>
     * This field corresponds to the "id" field in the incoming JSON payload.
     * The field is case-sensitive and expects the JSON property to be named "id".
     * </p>
     */
    private String id;
}
