package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import lombok.Getter;
import org.springframework.lang.NonNull;

/**
 * Exception thrown when there is an error extracting field values from a source object. This exception provides details about the field that failed extraction
 * and the source object.
 */
@Getter
public class FieldExtractionException extends WP2BusinessException {

    /** The field name or pattern that failed to be extracted */
    private final String field;
    /** The source object from which field extraction was attempted */
    private final transient Object source;

    /**
     * Constructs a new FieldExtractionException with specified field, source object and cause.
     *
     * @param field the field name or pattern that failed extraction
     * @param source the source object from which extraction was attempted
     * @param cause the underlying cause of the extraction failure
     */
    public FieldExtractionException(
            @NonNull final String field,
            @NonNull final Object source,
            @NonNull final Throwable cause) {
        super("Error extracting field '" + field, cause);
        this.field = field;
        this.source = source;
    }

}
