/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client.NotificationBsClient;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.BusNotificationProperties;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.NotificationConsumerMessageHandler;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor.FieldExtractorRegistry;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class JsonNotificationConsumerMessageHandler
implements NotificationConsumerMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonNotificationConsumerMessageHandler.class);
    private final String name;
    private final BusNotificationProperties config;
    private final ObjectMapper objectMapper;
    private final FieldExtractorRegistry fieldExtractorRegistry;
    private final NotificationBsClient notificationBsClient;

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getNotificationType() {
        return this.config.getType();
    }

    public void handleMessage(CloudEvent cloudEvent) throws Exception {
        JsonNode node;
        CloudEventData rawData = cloudEvent.getData();
        if (rawData == null) {
            return;
        }
        String json = new String(rawData.toBytes());
        try {
            node = this.objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Error parsing event: id={}", (Object)cloudEvent.getId(), (Object)e);
            return;
        }
        this.handleMessage(cloudEvent, node);
    }

    private void handleMessage(CloudEvent cloudEvent, JsonNode data) {
        log.debug("Processing event: id={}, handler={}", (Object)cloudEvent.getId(), (Object)this.name);
        String resourceId = Optional.ofNullable(this.config.getResource()).map(field -> this.fieldExtractorRegistry.extractResourceId(field, (Object)data)).orElse(null);
        log.debug("Event resource id: {}", (Object)resourceId);
        Map placeholders = this.fieldExtractorRegistry.extractPlaceholders(this.config.getPlaceholders(), (Object)data);
        log.debug("Event placeholders: {}", (Object)placeholders);
        Set receivers = this.fieldExtractorRegistry.extractReceivers(this.config.getReceivers(), (Object)data);
        log.debug("Event receivers: {}", (Object)receivers);
        if (receivers.isEmpty()) {
            log.warn("No receivers found for event: id={}, handler={}", (Object)cloudEvent.getId(), (Object)this.name);
        } else {
            log.info("Creating notifications for event: id={}, handler={}, type={}, resourceId={}, receivers={}", new Object[]{cloudEvent.getId(), this.name, this.config.getType(), resourceId, receivers.size()});
            this.createNotifications(resourceId, placeholders, receivers);
        }
    }

    private void createNotifications(String resourceId, Map<String, String> placeholders, Set<String> receivers) {
        InputCreateUserNotificationDto request = InputCreateUserNotificationDto.builder().type(this.config.getType()).referencedId(resourceId).placeholderValues(placeholders).users(new ArrayList<String>(receivers)).build();
        this.notificationBsClient.create(request);
    }

    @Generated
    public JsonNotificationConsumerMessageHandler(String name, BusNotificationProperties config, ObjectMapper objectMapper, FieldExtractorRegistry fieldExtractorRegistry, NotificationBsClient notificationBsClient) {
        this.name = name;
        this.config = config;
        this.objectMapper = objectMapper;
        this.fieldExtractorRegistry = fieldExtractorRegistry;
        this.notificationBsClient = notificationBsClient;
    }
}

