package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties;

import jakarta.validation.Valid;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties class that manages notification system settings and driver configurations.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
@ConfigurationProperties(prefix = "notifications")
public class NotificationsConfigurationProperties {

    /** Properties configuration for different types of notification drivers */
    @Valid
    private DriversProperties drivers;

}
