package com.finconsgroup.itserr.marketplace.notification.bs.websocket.configuration;

import com.finconsgroup.itserr.marketplace.notification.bs.websocket.NotificationsWebSocketHandler;
import com.finconsgroup.itserr.marketplace.notification.bs.websocket.WsHandshakeInterceptor;
import com.finconsgroup.itserr.marketplace.notification.bs.websocket.WsProtocolJwtInterceptor;
import com.finconsgroup.itserr.marketplace.notification.bs.websocket.configuration.properties.WebSocketCORSConfigurationProperties;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

/**
 * Configuration class for WebSocket settings. Configures WebSocket endpoints, handlers and interceptors for the notification system.
 */
@Configuration
@EnableWebSocket
@RequiredArgsConstructor
public class WebSocketConfig implements WebSocketConfigurer {

    /** Holds the configuration properties for WebSocket Cross-Origin Resource Sharing (CORS) settings. */
    private final WebSocketCORSConfigurationProperties corsConfig;

    /** WebSocket handler for managing notification messages and connections */
    private final NotificationsWebSocketHandler handler;

    /** Interceptor for handling and processing JWT (JSON Web Token) from WebSocket protocol headers. */
    private final WsProtocolJwtInterceptor jwtInterceptor;
    /** Interceptor for handling WebSocket handshake and authentication */
    private final WsHandshakeInterceptor handshakeInterceptor;

    /**
     * Registers WebSocket handlers with their corresponding URL paths and configurations. Sets up the notifications endpoint with cross-origin support.
     *
     * @param registry the registry for registering WebSocket handlers
     */
    @Override
    public void registerWebSocketHandlers(
            final WebSocketHandlerRegistry registry) {
        registry
                .addHandler(handler, "/notification/notifications-ws")
                .addInterceptors(jwtInterceptor, handshakeInterceptor)
                .setAllowedOrigins(corsConfig.getAllowedOrigins());
    }

}

