package com.finconsgroup.itserr.marketplace.notification.bs.event;

import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Component responsible for publishing notification events within the application.
 */
@Component
public class NotificationPublisher {

    private final ApplicationEventPublisher publisher;

    /**
     * Constructor.
     *
     * @param publisher The Spring ApplicationEventPublisher for broadcasting events
     */
    public NotificationPublisher(final ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    /**
     * Publishes a notification created event to the application context.
     *
     * @param event The notification created event to publish
     * @throws NullPointerException if event is null
     */
    public void publishCreated(
            @NonNull final NotificationCreatedEvent event) {

        publisher.publishEvent(event);

    }

}
