package com.finconsgroup.itserr.marketplace.notification.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.notification.bs.api.UserNotificationApi;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.service.UserNotificationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.UUID;

/**
 * REST controller class for handling user Notification related API requests.
 *
 * <p>Implements the {@link UserNotificationApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class UserNotificationController implements UserNotificationApi {

    private final UserNotificationService userNotificationService;

    @Override
    public List<OutputUserNotificationDto> createNotification(
            final InputCreateUserNotificationDto inputCreateUserNotificationDto,
            final String acceptLanguage) {
        return userNotificationService.create(inputCreateUserNotificationDto, acceptLanguage);
    }

    @Override
    public void patchAll(final InputPatchUserNotificationsDto request) {
        userNotificationService.patchAll(request);
    }

    @Override
    public OutputPatchUserNotificationDto patchUserNotificationById(
            final UUID notificationId,
            final InputPatchUserNotificationDto inputPatchUserNotificationDto
    ) {
        JwtTokenHolder.getUserIdOrThrow();
        return userNotificationService.patchById(notificationId, inputPatchUserNotificationDto);
    }

    @Override
    public void deleteUserNotificationById(final UUID notificationId) {
        JwtTokenHolder.getUserIdOrThrow();
        userNotificationService.deleteById(notificationId);
    }

}
