/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.news.dm.api.NewsApi;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.service.NewsService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NewsController
implements NewsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsController.class);
    private final NewsService newsService;

    public Page<OutputNewsDto> findAll(int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.newsService.findAll((Pageable)pageable);
    }

    public OutputNewsDto findById(UUID newsId) {
        return this.newsService.findById(newsId);
    }

    public OutputNewsDto createNews(InputCreateNewsDto inputCreateNewsDto) {
        return this.newsService.create(JwtTokenHolder.getUserIdOrThrow(), inputCreateNewsDto);
    }

    public OutputNewsDto updateNewsById(UUID newsId, InputUpdateNewsDto inputUpdateNewsDto) {
        return this.newsService.updateById(JwtTokenHolder.getUserIdOrThrow(), newsId, inputUpdateNewsDto);
    }

    public void deleteNewsById(UUID newsId) {
        this.newsService.deleteById(JwtTokenHolder.getUserIdOrThrow(), newsId);
    }

    @Generated
    public NewsController(NewsService newsService) {
        this.newsService = newsService;
    }
}

